/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.com;

import java.util.Map;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.pdown.gui.util.I18nUtil;

public class Browser
extends Region {
    final WebView webView = new WebView();
    final WebEngine webEngine = this.webView.getEngine();
    private MenuItem copy;
    private MenuItem paste;

    public Browser() {
        this.getChildren().add((Object)this.webView);
        this.webView.setContextMenuEnabled(false);
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ContextMenu contextMenu = new ContextMenu();
        this.copy = new MenuItem();
        this.copy.setOnAction(e -> {
            ClipboardContent content = new ClipboardContent();
            Object selection = this.webView.getEngine().executeScript("window.getSelection().toString()");
            if (selection != null) {
                content.putString(selection.toString());
                clipboard.setContent((Map)content);
            }
        });
        this.paste = new MenuItem();
        this.paste.setOnAction(e -> {
            Object content = clipboard.getContent(DataFormat.PLAIN_TEXT);
            if (content != null) {
                this.webView.getEngine().executeScript("if(document.activeElement.selectionStart>=0){var value = document.activeElement.value;if(!value){ document.activeElement.value='" + content + "';}else{ document.activeElement.value=value.substring(0,document.activeElement.selectionStart)+'" + content + "'+value.substring(document.activeElement.selectionEnd);}var event = document.createEvent('Event');event.initEvent('input', true, true);document.activeElement.dispatchEvent(event);}");
            }
        });
        this.refreshText();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{this.copy, this.paste});
        this.webView.setOnMousePressed(e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                contextMenu.show((Node)this.webView, e.getScreenX(), e.getScreenY());
            } else {
                contextMenu.hide();
            }
        });
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.getHeight();
        this.layoutInArea((Node)this.webView, 0.0, 0.0, w, h, 0.0, HPos.CENTER, VPos.CENTER);
    }

    public void load(String url) {
        this.webEngine.load(url);
    }

    public boolean isLoad() {
        return this.webEngine.getLocation() != null;
    }

    public void refreshText() {
        this.copy.setText(I18nUtil.getMessage((String)"gui.menu.copy", (Object[])new Object[0]));
        this.paste.setText(I18nUtil.getMessage((String)"gui.menu.paste", (Object[])new Object[0]));
    }
}

