/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.swing.JOptionPane;
import org.pdown.core.util.OsUtil;
import org.pdown.gui.com.Browser;
import org.pdown.gui.com.Components;
import org.pdown.gui.content.PDownConfigContent;
import org.pdown.gui.entity.PDownConfigInfo;
import org.pdown.gui.extension.ExtensionContent;
import org.pdown.gui.extension.mitm.util.ExtensionProxyUtil;
import org.pdown.gui.http.EmbedHttpServer;
import org.pdown.gui.http.controller.ApiController;
import org.pdown.gui.http.controller.NativeController;
import org.pdown.gui.http.controller.PacController;
import org.pdown.gui.rest.HttpDownAppCallback;
import org.pdown.gui.util.AppUtil;
import org.pdown.gui.util.ConfigUtil;
import org.pdown.gui.util.ExecUtil;
import org.pdown.gui.util.I18nUtil;
import org.pdown.rest.DownRestServer;
import org.pdown.rest.content.ConfigContent;
import org.pdown.rest.content.RestWebServerFactoryCustomizer;
import org.pdown.rest.controller.HttpDownRestCallback;
import org.pdown.rest.entity.ServerConfigInfo;
import org.pdown.rest.util.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownApplication
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownApplication.class);
    private static final String OS = OsUtil.isWindows() ? "windows" : (OsUtil.isMac() ? "mac" : "linux");
    private static final String ICON_PATH = OS + (OsUtil.isWindowsXP() ? "/logo_xp.png" : "/logo.png");
    public static DownApplication INSTANCE;
    private Stage stage;
    private Browser browser;
    private TrayIcon trayIcon;
    private CountDownLatch countDownLatch;
    public int FRONT_PORT;
    public int API_PORT;
    public int PROXY_PORT;
    public static int macToolPort;
    private static final int REST_PORT = 26339;

    public void start(Stage primaryStage) throws Exception {
        INSTANCE = this;
        this.stage = primaryStage;
        Platform.setImplicitExit((boolean)false);
        this.initConfig();
        this.initRest();
        this.initMacMITMTool();
        this.initEmbedHttpServer();
        this.initExtension();
        this.initTray();
        if (!OsUtil.isWindowsXP()) {
            this.initWindow();
            this.initBrowser();
        }
        this.loadUri(null, true, true);
    }

    private void initConfig() throws IOException {
        PDownConfigContent.getInstance().load();
        this.FRONT_PORT = ConfigUtil.getInt((String)"front.port");
        this.API_PORT = ConfigUtil.getInt((String)"api.port");
        if ("prd".equals(ConfigUtil.getString((String)"spring.profiles.active"))) {
            try {
                this.API_PORT = OsUtil.getFreePort((int)this.API_PORT);
                if (this.FRONT_PORT == -1) {
                    this.FRONT_PORT = this.API_PORT;
                }
            }
            catch (IOException e) {
                LOGGER.error("initConfig error", (Throwable)e);
                this.alertAndExit(I18nUtil.getMessage((String)"gui.alert.startError", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void initRest() {
        HttpDownRestCallback.setCallback((HttpDownRestCallback)new HttpDownAppCallback());
        RestWebServerFactoryCustomizer.init(null);
        ServerConfigInfo serverConfigInfo = (ServerConfigInfo)ConfigContent.getInstance().get();
        serverConfigInfo.setPort(26339);
        if (StringUtils.isEmpty((Object)serverConfigInfo.getFilePath())) {
            serverConfigInfo.setFilePath(System.getProperty("user.home") + File.separator + "Downloads");
        }
        new SpringApplicationBuilder(new Class[]{DownRestServer.class}).headless(false).build().run(new String[0]);
    }

    private void initExtension() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (((PDownConfigInfo)PDownConfigContent.getInstance().get()).getProxyMode() == 1) {
                try {
                    ExtensionProxyUtil.disabledProxy();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }));
        new Thread(() -> {
            try {
                if (AppUtil.checkIsInstalledCert()) {
                    AppUtil.startProxyServer();
                }
            }
            catch (Exception e) {
                LOGGER.error("Init extension error", (Throwable)e);
            }
        }).start();
        try {
            ExtensionContent.load();
            AppUtil.refreshPAC();
        }
        catch (IOException e) {
            LOGGER.error("Extension content load error", (Throwable)e);
        }
    }

    private void initMacMITMTool() {
        if (OsUtil.isMac()) {
            new Thread(() -> {
                String toolUri = "mac/mitm-tool.bin";
                Path toolPath = Paths.get(PathUtil.ROOT_PATH + File.separator + toolUri, new String[0]);
                try {
                    ClassLoader classLoader;
                    URL url;
                    URLConnection connection;
                    if (!toolPath.toFile().exists() && (connection = (url = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(toolUri)).openConnection()) instanceof JarURLConnection) {
                        if (!toolPath.getParent().toFile().exists()) {
                            Files.createDirectories(toolPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(classLoader.getResourceAsStream(toolUri), toolPath, new CopyOption[0]);
                        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxrw-rw-");
                        Files.setPosixFilePermissions(toolPath, perms);
                    }
                    macToolPort = OsUtil.getFreePort();
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        try {
                            ExecUtil.httpGet((String)("http://127.0.0.1:" + macToolPort + "/quit"));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }));
                    ExecUtil.execBlockWithAdmin((String)("'" + toolPath.toFile().getPath() + "' " + macToolPort));
                }
                catch (Exception e) {
                    LOGGER.error("initMacMITMTool error", (Throwable)e);
                    this.alertAndExit("Init mitm-tool error\uff1a" + e.getMessage());
                }
                System.exit(0);
            }).start();
        }
    }

    private void initEmbedHttpServer() {
        this.countDownLatch = new CountDownLatch(1);
        new Thread(() -> {
            EmbedHttpServer embedHttpServer = new EmbedHttpServer(this.API_PORT);
            embedHttpServer.addController((Object)new NativeController());
            embedHttpServer.addController((Object)new ApiController());
            embedHttpServer.addController((Object)new PacController());
            embedHttpServer.start(future -> this.countDownLatch.countDown());
        }).start();
    }

    private void initTray() throws AWTException {
        if (SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            URL url = Thread.currentThread().getContextClassLoader().getResource(ICON_PATH);
            Image trayImage = Toolkit.getDefaultToolkit().getImage(url);
            Dimension trayIconSize = systemTray.getTrayIconSize();
            trayImage = trayImage.getScaledInstance(trayIconSize.width, trayIconSize.height, 4);
            this.trayIcon = new TrayIcon(trayImage, "Proxyee Down");
            systemTray.add(this.trayIcon);
            this.loadPopupMenu();
            this.trayIcon.addActionListener(event -> Platform.runLater(() -> this.loadUri(null, true)));
        }
    }

    public void loadPopupMenu() {
        PopupMenu popupMenu = new PopupMenu();
        MenuItem showItem = new MenuItem(I18nUtil.getMessage((String)"gui.tray.show", (Object[])new Object[0]));
        showItem.addActionListener(event -> Platform.runLater(() -> this.loadUri("", true)));
        MenuItem setItem = new MenuItem(I18nUtil.getMessage((String)"gui.tray.set", (Object[])new Object[0]));
        setItem.addActionListener(event -> this.loadUri("/#/setting", true));
        MenuItem aboutItem = new MenuItem(I18nUtil.getMessage((String)"gui.tray.about", (Object[])new Object[0]));
        aboutItem.addActionListener(event -> this.loadUri("/#/about", true));
        MenuItem supportItem = new MenuItem(I18nUtil.getMessage((String)"gui.tray.support", (Object[])new Object[0]));
        supportItem.addActionListener(event -> this.loadUri("/#/support", true));
        MenuItem closeItem = new MenuItem(I18nUtil.getMessage((String)"gui.tray.exit", (Object[])new Object[0]));
        closeItem.addActionListener(event -> {
            Platform.exit();
            System.exit(0);
        });
        popupMenu.add(showItem);
        popupMenu.addSeparator();
        popupMenu.add(setItem);
        popupMenu.add(aboutItem);
        popupMenu.add(supportItem);
        popupMenu.addSeparator();
        popupMenu.add(closeItem);
        this.trayIcon.setPopupMenu(popupMenu);
    }

    public void refreshBrowserMenu() {
        this.browser.refreshText();
    }

    private void initBrowser() throws AWTException {
        this.browser = new Browser();
        this.stage.setScene(new Scene((Parent)this.browser));
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initWindow() {
        this.stage.setTitle("Proxyee Down");
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        int width = 1024;
        int height = 576;
        this.stage.setX((bounds.getWidth() - (double)width) / 2.0);
        this.stage.setY((bounds.getHeight() - (double)height) / 2.0);
        this.stage.setMinWidth((double)width);
        this.stage.setMinHeight((double)height);
        this.stage.getIcons().add((Object)new javafx.scene.image.Image(Thread.currentThread().getContextClassLoader().getResourceAsStream(ICON_PATH)));
        this.stage.setResizable(true);
        this.stage.setOnCloseRequest(event -> {
            event.consume();
            this.stage.hide();
        });
    }

    public void show(boolean isTray) {
        boolean isFront = false;
        if (this.stage.isShowing()) {
            if (this.stage.isIconified()) {
                this.stage.setIconified(false);
            } else {
                isFront = true;
                this.stage.toFront();
            }
        } else {
            isFront = true;
            this.stage.show();
            this.stage.toFront();
        }
        if (isFront && !isTray && OsUtil.isWindows()) {
            this.stage.setIconified(true);
            this.stage.setIconified(false);
        }
    }

    public void loadUri(String uri, boolean isTray, boolean isStartup) {
        String url = "http://127.0.0.1:" + this.FRONT_PORT + (uri == null ? "" : uri);
        boolean autoOpen = ((PDownConfigInfo)PDownConfigContent.getInstance().get()).isAutoOpen();
        if (OsUtil.isWindowsXP() || ((PDownConfigInfo)PDownConfigContent.getInstance().get()).getUiMode() == 0) {
            if (!isStartup || autoOpen) {
                try {
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (IOException e) {
                    LOGGER.error("Open browse error", (Throwable)e);
                }
            }
        } else {
            Platform.runLater(() -> {
                if (uri != null || !this.browser.isLoad()) {
                    this.browser.load(url);
                }
                if (!isStartup || autoOpen) {
                    this.show(isTray);
                }
            });
        }
    }

    public void loadUri(String uri, boolean isTray) {
        this.loadUri(uri, isTray, false);
    }

    private void alertAndExit(String msg) {
        Platform.runLater(() -> {
            Components.alert((String)msg);
            System.exit(0);
        });
    }

    private static void doCheck() {
        if (OsUtil.isBusyPort((int)26339)) {
            JOptionPane.showMessageDialog(null, I18nUtil.getMessage((String)"gui.alert.startError", (Object[])new Object[]{I18nUtil.getMessage((String)"gui.alert.restPortBusy", (Object[])new Object[0])}), I18nUtil.getMessage((String)"gui.warning", (Object[])new Object[0]), 2);
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        DownApplication.doCheck();
        DownApplication.launch((String[])args);
    }

    static {
        System.setProperty("ROOT_PATH", PathUtil.ROOT_PATH);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        if (OsUtil.isMac()) {
            try {
                Class<?> appClass = Class.forName("com.apple.eawt.Application");
                Method getApplication = appClass.getMethod("getApplication", new Class[0]);
                Object application = getApplication.invoke(appClass, new Object[0]);
                Method setDockIconImage = appClass.getMethod("setDockIconImage", Image.class);
                URL url = Thread.currentThread().getContextClassLoader().getResource("mac/dock_logo.png");
                Image image = Toolkit.getDefaultToolkit().getImage(url);
                setDockIconImage.invoke(application, image);
            }
            catch (Exception e) {
                LOGGER.error("handle mac dock icon error", (Throwable)e);
            }
        }
    }
}

