/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 2);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

exports.__esModule = true;
var constants_1 = __webpack_require__(1);
exports.fetchResource = function (url) {
    return new Promise(function (resolve, reject) {
        var script = document.createElement('script');
        script.src = url;
        script.async = true;
        script.onload = resolve;
        script.onerror = reject;
        document.body.appendChild(script);
    });
};
exports.fetchContentResource = function () {
    var ruleResource = constants_1.resourceUrl + "/content.js";
    return exports.fetchResource(ruleResource);
};
exports.fetchPopupResource = function () {
    var ruleResource = constants_1.resourceUrl + "/popup.js";
    return exports.fetchResource(ruleResource);
};
exports.fetchBackgroundResource = function () {
    var ruleResource = constants_1.resourceUrl + "/background.js";
    return exports.fetchResource(ruleResource);
};


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

exports.__esModule = true;
var isProdPlugin = "production" === 'production';
var isTestPlugin = "production" === 'test';
exports.WebtoolsHost = isProdPlugin
    ? 'https://webtool.pdflux.com'
    : 'http://xa.cheftin.com:1700/';
exports.resourceUrl = isProdPlugin
    ? 'https://sr.paodingai.com/pdflux-browser-extensions'
    : isTestPlugin
        ? 'https://bohr.cheftin.com:7080'
        : 'http://localhost:9001';
exports.pdfluxClientDownloadLink = 'https://pdflux.com/downloads/PDFlux_latest.dmg';


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
exports.__esModule = true;
var fetch_resources_1 = __webpack_require__(0);
var backgroundLoadStatus = false;
var postMessageFromContentToContentScript = function (data) {
    var newEvent = new CustomEvent('contentToContentScriptRequest', {
        detail: __assign(__assign({}, data), { to: 'content' }),
    });
    window.dispatchEvent(newEvent);
};
var postMessageFromContentToPopup = function (data) {
    chrome.runtime.sendMessage(__assign(__assign({}, data), { to: 'popup' }));
};
var postMessageFromContentToBackground = function (data) {
    chrome.runtime.sendMessage(__assign(__assign({}, data), { to: 'background' }));
};
window.addEventListener('contentScriptToContentRequest', function (e) {
    var _a;
    var data = e.detail;
    if (data.type === 'checkBackgroundLoadStatus') {
        postMessageFromContentToContentScript({
            from: 'content',
            type: 'backgroundLoadStatus',
            data: { status: backgroundLoadStatus },
        });
        return;
    }
    if (data.type === 'locale') {
        var localeObj_1 = {};
        Object.keys(data.message).forEach(function (key) {
            localeObj_1[key] = chrome.i18n.getMessage(key);
        });
        postMessageFromContentToContentScript({
            from: 'content',
            type: 'locale',
            data: localeObj_1,
        });
        return;
    }
    if (data.type === 'getStorage') {
        chrome.storage.sync.get(null, function (storageData) {
            return postMessageFromContentToContentScript({
                from: 'content',
                type: 'storage',
                data: storageData,
            });
        });
        return;
    }
    if (data.type === 'setStorage') {
        var key = data.key, value = data.value;
        chrome.storage.sync.set((_a = {}, _a[key] = value, _a), function () { });
        return;
    }
    postMessageFromContentToPopup(data);
    postMessageFromContentToBackground(data);
});
chrome.runtime.onMessage.addListener(function (request) {
    var _a;
    if (request.from === 'background') {
        if (request.type === 'backgroundLoad') {
            backgroundLoadStatus = true;
        }
        postMessageFromContentToContentScript(request);
        return;
    }
    if (request.from === 'popup') {
        if (request.type === 'locale') {
            var localeObj_2 = {};
            Object.keys(request.message).forEach(function (key) {
                localeObj_2[key] = chrome.i18n.getMessage(key);
            });
            postMessageFromContentToPopup({
                from: 'content',
                type: 'locale',
                data: localeObj_2,
            });
        }
        else if (request.type === 'getStorage') {
            chrome.storage.sync.get(null, function (storageData) {
                return postMessageFromContentToPopup({
                    from: 'content',
                    type: 'storage',
                    data: storageData,
                });
            });
        }
        else if (request.type === 'setStorage') {
            var key = request.key, value = request.value;
            chrome.storage.sync.set((_a = {}, _a[key] = value, _a), function () { });
        }
        else {
            postMessageFromContentToContentScript(request);
        }
        return;
    }
});
postMessageFromContentToBackground({
    from: 'content',
    type: 'checkBackgroundLoad',
});
fetch_resources_1.fetchContentResource();
document.cookie = 'pdflux_extension_installed=true';


/***/ })
/******/ ]);