#include "version.inl"

uniform sampler2D diffuseTexture;

uniform vec2 clamplower;
uniform vec2 clampupper;
uniform vec2 resolution;

in vec4 color;
in vec2 texCoord;

void main()
{
    vec2 p = gl_FragCoord.xy;
    p.y = resolution.y - p.y;

    if (p.x < clamplower.x
            || p.y < clamplower.y
            || p.x > clampupper.x
            || p.y > clampupper.y)
        discard;

    vec4 texColor = texture(diffuseTexture, texCoord);
    texColor.a *= 1.5f;

    outFragColor = color * texColor;
//    outFragColor.rg = p.xy / vec2(1920, 1080);
//    outFragColor.b = 0;
//    outFragColor.a = 1;
}
