#include "version.inl"

uniform sampler2D diffuseTexture;
uniform float invert;
uniform float highlight;

in vec4 color;
in vec2 texCoord;



void main()
{
    vec2 coords;
    if (invert == 0.0)
    {
        coords = vec2(texCoord.x, 1.0f - texCoord.y);
    }
    else
    {
        coords = vec2(texCoord.x, texCoord.y);
    }

    vec4 texColor = texture(diffuseTexture, coords);

    vec4 iconColor = vec4(texColor.rgb, max(texColor.r, max(texColor.g, texColor.b)));

    vec4 finalColor = iconColor;

    float d = min(1.0, max(0.0, 1.0 - distance(texCoord, vec2(texCoord.x)) / 0.45));
    vec4 shaded = mix(color, color + vec4(vec3(highlight), 0.0), d);

    outFragColor = finalColor * shaded;

}

