
#include "version.inl"

uniform samplerCube skyTexture;

in vec3 position;

void main()
{
    vec4 texColor = texture(skyTexture, position);

    texColor.rgb *= 255;

    float contrast = 3;
    float factor = (259 * (contrast + 255)) / (255 * (259 - contrast));
    texColor.rgb = clamp((factor * (texColor.rgb - 128) + 128), 0, 255);

    texColor.rgb /= 255;

    outFragColor = vec4(texColor.rgb, 1.0f);
}
