#include "version.inl"

uniform sampler2D diffuseTexture;
uniform sampler2D grateTexture;

in vec2 texCoord;

mat3 sx = mat3(
    1.0, 2.0, 1.0,
    0.0, 0.0, 0.0,
   -1.0, -2.0, -1.0
);
mat3 sy = mat3(
    1.0, 0.0, -1.0,
    2.0, 0.0, -2.0,
    1.0, 0.0, -1.0
);


void main()
{
    // simple sobel edge detection
    vec3 diffuse = texture(diffuseTexture, texCoord).rgb;
    vec3 grate = texture(grateTexture, texCoord * 0.5).rgb;

    mat3 samples;
    for (int x = 0; x < 3; ++x)
    {
        for (int y = 0; y < 3; ++y)
        {
            vec3 sample = texelFetch(diffuseTexture, ivec2(gl_FragCoord) + ivec2(x - 1, y - 1), 0).rgb;
            samples[x][y] = (sample.x * 0.299f + sample.y * 0.587f + sample.z * 0.144f) * (1.0f / 3.0f);
        }
    }

    float gx = dot(sx[0], samples[0]) + dot(sx[1], samples[1]) + dot(sx[2], samples[2]);
    float gy = dot(sy[0], samples[0]) + dot(sy[1], samples[1]) + dot(sy[2], samples[2]);

    float g = sqrt(gx * gx + gy * gy);

    outFragColor = vec4(vec3(0, 0.35, 0.75) + clamp(g * 3.0f, 0, 0.7) + grate * 0.35, 0.5 + g * 3.0f);
}
