#include "version.inl"

out vec4 color;
out vec2 texCoord;
out vec3 position;

uniform vec2 texOffset;
uniform vec2 positionOffset;

void main(void)
{
    gl_Position.xyz = vPosition;
    gl_Position.xy += positionOffset;
    gl_Position.w = 1.0;

    color = vColor;
    texCoord = vTex + texOffset;
    position = vPosition + vec3(positionOffset, 0);
}

