uniform samplerCube ambientTexture;
uniform float ambient;

vec3 getAmbientLighting(vec3 normal, vec3 dir, inout vec3 colorSum)
{
    vec3 color = texture(ambientTexture, -dir).rgb;
    colorSum = colorSum + color;

    // darken a little, not all the light shall be used as a light source
    float intensity = clamp(dot(normal, -dir), 0.0, 1.0);

    return intensity * color;
}

vec3 getAmbientLighting(vec3 normal)
{
    vec3 result = vec3(0);
    vec3 colorSum = vec3(0);

    result += getAmbientLighting(normal, vec3(1, 0, 0), colorSum);
    result += getAmbientLighting(normal, vec3(-1, 0, 0), colorSum);
    result += getAmbientLighting(normal, vec3(0, 1, 0), colorSum);
    result += getAmbientLighting(normal, vec3(0, -1, 0), colorSum);
    result += getAmbientLighting(normal, vec3(0, 0, 1), colorSum);
    result += getAmbientLighting(normal, vec3(0, 0, -1), colorSum);

    {
        colorSum = (colorSum + 0.5) / 6.0;
        float len = colorSum.r * 0.299 + colorSum.g * 0.587 + colorSum.b * 0.144;
        colorSum = colorSum / (len + 0.001);
    }

    float len = result.r * 0.299 + result.g * 0.587 + result.b * 0.144;

    // pseudo-desaturate
    result = mix(vec3(len, len, len), result, 0.6);

    {
        // add a second, "back-light" to improve lighting
        vec3 offcolor = colorSum;

        vec3 offLightDirection = normalize(cross(lightDir, vec3(0, 1, 0)));
        result += clamp(dot(-offLightDirection, normal), 0, 1) * offcolor * 0.33;

        vec3 offLight2Direction = normalize(offLightDirection + lightDir);
        result += clamp(dot(offLight2Direction, normal), 0, 1) * 0.2;
    }

    return result + ambient * colorSum;
}
