package.path = package.path .. ";data/scripts/lib/?.lua"
include ("randomext")
include ("galaxy")
local SectorTurretGenerator = include ("sectorturretgenerator")
local SectorSpecifics = include("sectorspecifics")
include("weapontype")
local FactionPacks = include("factionpacks")

function initializeAIFaction(faction)

    local seed = Server().seed + faction.index
    local random = Random(seed)

    function createRandomTrait(trait, contrary)
        local a = random:getFloat(-1.0, 1.0)
        local b = -a

        faction:setTrait(trait, a)
        faction:setTrait(contrary, b)
    end

    local turretGenerator = SectorTurretGenerator(seed)

    local x, y = faction:getHomeSectorCoordinates()

    local armed1 = turretGenerator:generateArmed(x, y, 0, Rarity(RarityType.Common))
    armed1.coaxial = false

    local armed2 = turretGenerator:generateArmed(x, y, 0, Rarity(RarityType.Common))
    armed2.coaxial = false

    local unarmed1 = turretGenerator:generate(x, y, 0, Rarity(RarityType.Common), WeaponType.MiningLaser)
    unarmed1.coaxial = false;

    -- make sure the armed turrets don't have a too high fire rate
    -- so they don't slow down update times too much when there's lots of firing going on
    for _, turret in pairs({armed1, armed2}) do

        local weapons = {turret:getWeapons()}
        turret:clearWeapons()

        for _, weapon in pairs(weapons) do

            if weapon.isProjectile and (weapon.fireRate or 0) > 2 then
                local old = weapon.fireRate
                weapon.fireRate = math.random(1.0, 2.0)
                weapon.damage = weapon.damage * old / weapon.fireRate;
            end

            turret:addWeapon(weapon)
        end
    end

    faction:getInventory():add(armed1, false)
    faction:getInventory():add(armed2, false)
    faction:getInventory():add(unarmed1, false)

    createRandomTrait("peaceful"%_T, "aggressive"%_T)
    createRandomTrait("careful"%_T, "brave"%_T)
    createRandomTrait("generous"%_T, "greedy"%_T)
    createRandomTrait("opportunistic"%_T, "honorable"%_T)
    createRandomTrait("trusting"%_T, "mistrustful"%_T)

    if random:test(0.5) then
        faction:setTrait("forgiving", random:getFloat(0.0, 1.0))
    end

    FactionPacks.tryApply(faction)
end

function initializePlayer(player)

    local galaxy = Galaxy()
    local server = Server()

    local random = Random(server.seed)

    -- get a random angle, fixed for the server seed
    local angle = random:getFloat(2.0 * math.pi)


    -- for each player registered, add a small amount on top of this angle
    -- this way, all players are near each other
    local home = {x = 0, y = 0}
    local faction

    local distFromCenter = 450.0

    local distBetweenPlayers = 1 + random:getFloat(0, 1) -- distance between the home sectors of different players

    for i = 1, 3000 do
        -- we're looking at a distance of 450, so the perimeter is ~1413
        -- with every failure we walk a distance of 3 on the perimeter, so we're finishing a complete round about every 500 failing iterations
        -- every failed round we reduce the radius by several sectors to cover a bigger area.
        local offset = math.floor(i / 500) * 15

        home.x = math.cos(angle) * (distFromCenter - offset)
        home.y = math.sin(angle) * (distFromCenter - offset)

        -- try to place the player in the area of a faction
        faction = galaxy:getLocalFaction(home.x, home.y)
        if faction then
            -- found a faction we can place the player to - stop looking if we don't need different start sectors
            if server.sameStartSector then break end

            -- in case we need different starting sectors: keep looking
            if galaxy:sectorExists(home.x, home.y) then
                angle = angle + (distBetweenPlayers / distFromCenter)
            else
                break
            end
        else
            angle = angle + (3 / distFromCenter)
        end
    end

    player:setHomeSectorCoordinates(home.x, home.y)
    player:setRespawnSectorCoordinates(home.x, home.y)

    -- make sure the player has an early ally
    if not faction then
        faction = Galaxy():getNearestFaction(home.x, home.y)
    end

    faction:setValue("enemy_faction", -1) -- this faction won't participate in faction wars
    Galaxy():setFactionRelations(faction, player, 85000)
    player:setValue("start_ally", faction.index)

    local random = Random(SectorSeed(home.x, home.y) + player.index)

    if server.difficulty == Difficulty.Beginner then
        player:receive(40000, 5000)
    elseif server.difficulty == Difficulty.Easy then
        player:receive(20000, 2000)
    else
        player:receive(10000)
    end

    -- create turret generator
    local generator = SectorTurretGenerator()

    local turret = InventoryTurret(generator:generate(450, 0, nil, Rarity(RarityType.Uncommon), WeaponType.ChainGun, Material(MaterialType.Iron)))
    player:getInventory():add(turret, false)
    player:getInventory():add(turret, false)

    local turret = InventoryTurret(generator:generate(450, 0, nil, Rarity(RarityType.Uncommon), WeaponType.MiningLaser, Material(MaterialType.Iron)))
    player:getInventory():add(turret, false)
    player:getInventory():add(turret, false)

end

function initializeAlliance(alliance)
end

function matchResources(player)
    player.infiniteResources = Server().infiniteResources
end
