package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

local SectorGenerator = include ("SectorGenerator")
local Balancing = include ("galaxy")
local Placer = include("placer")
include ("stationextensions")
include ("stringutility")
include ("music")

local SectorTemplate = {}

-- must be defined, will be used to get the probability of this sector
function SectorTemplate.getProbabilityWeight(x, y, serverSeed)

    local d = length(vec2(x, y)) - Balancing.BlockRingMax
    if d > 0 and d < 1.2 then
        if makeFastHash(x, y, serverSeed.int32) % 4 == 1 then
            return 10000000
        end
    end

    return 0
end

function SectorTemplate.offgrid(x, y)
    return true
end

-- this function returns whether or not a sector should have space gates
function SectorTemplate.gates(x, y)
    return false
end

-- this function returns what relevant contents there will be in the sector (exact)
function SectorTemplate.contents(x, y)
    local seed = Seed(string.join({GameSeed(), x, y, "teleporter"}, "-"))
    math.randomseed(seed);
    local random = random()
    local contents = {ships = 0, stations = 0, seed = tostring(seed)}

    return contents, random
end

function SectorTemplate.musicTracks()
    local good = {
        primary = combine(TrackCollection.Desolate()),
        secondary = combine(TrackCollection.Melancholic(), TrackCollection.Neutral()),
    }

    local neutral = {
        primary = combine(TrackCollection.Middle(), TrackCollection.Desolate()),
        secondary = TrackCollection.All(),
    }

    local bad = {
        primary = combine(TrackCollection.Middle(), TrackCollection.Desolate()),
        secondary = TrackCollection.Neutral(),
    }

    return good, neutral, bad
end

function SectorTemplate.getPlan()

    if SectorTemplate.plan then return SectorTemplate.plan end

    local plan = LoadPlanFromFile("data/plans/teleporter.xml")
    plan.accumulatingHealth = true

    SectorTemplate.plan = plan

    return plan
end

-- player is the player who triggered the creation of the sector (only set in start sector, otherwise nil)
function SectorTemplate.generate(player, seed, x, y)
    local contents, random = SectorTemplate.contents(x, y)

    local generator = SectorGenerator(x, y)

    local num = 8
    for i = 1, num do
        local angle = i * (1 / num) * math.pi * 2.0
        local p = vec3(math.sin(angle), 0, math.cos(angle)) * 1000

        local desc = EntityDescriptor()
        desc:addComponents(
           ComponentType.Plan,
           ComponentType.BspTree,
           ComponentType.Intersection,
           ComponentType.Asleep,
           ComponentType.DamageContributors,
           ComponentType.BoundingSphere,
           ComponentType.BoundingBox,
           ComponentType.Velocity,
           ComponentType.Physics,
           ComponentType.Scripts,
           ComponentType.ScriptCallback,
           ComponentType.Title,
           ComponentType.WreckageCreator
           )

        desc:setPlan(SectorTemplate.getPlan())
        desc.title = toRomanLiterals(i)
        desc.position = MatrixLookUpPosition(vec3(0, 1, 0), p, p)

        addAsteroid(desc)

        local entity = Sector():createEntity(desc)

        entity:setValue("teleporter", i)
    end

    Sector():addScriptOnce("story/activateteleport")

    Placer.resolveIntersections()
end

return SectorTemplate
