package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

local SectorGenerator = include ("SectorGenerator")
local NamePool = include ("namepool")
local Placer = include("placer")
local Smuggler = include("story/smuggler")
local Balancing = include("galaxy")
include("stringutility")
include("music")

local SectorTemplate = {}

-- must be defined, will be used to get the probability of this sector
function SectorTemplate.getProbabilityWeight(x, y)
    return 350
end

function SectorTemplate.offgrid(x, y)
    return true
end

-- this function returns whether or not a sector should have space gates
function SectorTemplate.gates(x, y)
    return false
end

-- this function returns what relevant contents there will be in the sector (exact)
function SectorTemplate.contents(x, y)
    local seed = Seed(string.join({GameSeed(), x, y, "smugglerhideout"}, "-"))
    math.randomseed(seed);

    local random = random()

    local contents = {ships = 0, stations = 0, seed = tostring(seed)}

    contents.smugglersMarkets = 1
    contents.stations = 1
    contents.defenders = 3
    contents.ships = 3

    contents.resourceAsteroids = random:getInt(0, 2)

    local coords = vec2(x, y)
    if length2(coords) >= Balancing.BlockRingMin2 then
        contents.ships = contents.ships + 1
    end

    return contents, random
end

function SectorTemplate.musicTracks()
    local good = {
        primary = combine(TrackCollection.Desolate()),
        secondary = combine(TrackCollection.Neutral()),
    }

    local neutral = {
        primary = combine(TrackCollection.Desolate()),
        secondary = combine(TrackCollection.Neutral(), TrackCollection.Middle()),
    }

    local bad = {
        primary = combine(TrackCollection.Middle(), TrackCollection.Desolate()),
        secondary = TrackCollection.Neutral(),
    }

    return good, neutral, bad
end

-- player is the player who triggered the creation of the sector (only set in start sector, otherwise nil)
function SectorTemplate.generate(player, seed, x, y)
    local contents, random = SectorTemplate.contents(x, y)

    local generator = SectorGenerator(x, y)

    local language = Language(Seed(makeFastHash(seed.value, x, y)))
    local factionName = language:getFactionName()

    local faction = Galaxy():findFaction(factionName)
    if not faction then
        faction = Galaxy():createFaction(factionName, x, y)
    end

    local station = generator:createStation(faction, "merchants/smugglersmarket.lua")
    station.title = "Smuggler Hideout"%_t
    station:addScript("merchants/tradingpost")
    NamePool.setStationName(station)

    -- create ships
    for i = 1, contents.defenders do
        local ship = ShipGenerator.createDefender(faction, generator:getPositionInSector())
        ship:removeScript("antismuggle.lua")
    end

    -- create some asteroids
    local numFields = random:getInt(3, 4)
    for i = 1, numFields do
        local mat = generator:createAsteroidField();
        if random:test(0.15) then generator:createStash(mat) end
    end

    for i = 1, contents.resourceAsteroids do
        local position = generator:createAsteroidField()
        generator:createBigAsteroid(position)
    end

    local numSmallFields = random:getInt(2, 5)
    for i = 1, numSmallFields do
        generator:createSmallAsteroidField()
    end

    if SectorTemplate.gates(x, y) then generator:createGates() end

    if random:test(generator:getWormHoleProbability()) then generator:createRandomWormHole() end

    generator:addOffgridAmbientEvents()
    Placer.resolveIntersections()

    -- create a shady representative
    Smuggler.spawnRepresentative(station)

    Sector():addScript("data/scripts/sector/background/respawnresourceasteroids.lua")

    Placer.resolveIntersections()
end


return SectorTemplate
