package.path = package.path .. ";data/scripts/lib/?.lua"
include("callable")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace GuardianPrecursorBar
GuardianPrecursorBar = {}

local timeStarted = 0
local chargeTime = 10 * 60
local localTime = 0
local active = true

function GuardianPrecursorBar.updateActiveStatus()
    if onClient() then invokeServerFunction("updateActiveStatus") return end

    active = Server():getValue("xsotan_swarm_active") or false
end
callable(GuardianPrecursorBar, "updateActiveStatus")

function GuardianPrecursorBar.sync(data_in)

    if onServer() then broadcastInvokeClientFunction("sync", active) return end

    if onClient() then
        if data_in == false or data_in == true then
            active = data_in
        else
            invokeServerFunction("sync")
        end
    end
end
callable(GuardianPrecursorBar, "sync")

function GuardianPrecursorBar.getUpdateInterval()
    return 0.2
end

if onClient() then

function GuardianPrecursorBar.updateClient(timePassed)
    localTime = localTime + timePassed
    GuardianPrecursorBar.updateActiveStatus()
    GuardianPrecursorBar.sync()

    if not active then
        unregisterBoss(Uuid())
        invokeServerFunction("terminateServer")
    else
        registerBoss(Uuid(), nil, nil)
        setBossHealth(Uuid(), localTime, chargeTime, nil, nil)
        local quote = localTime / chargeTime
        if quote < 0.4 then
            setBossHealthColor(Uuid(), ColorRGB(0.6, 0.6, 0.6), nil)
        elseif quote < 0.6 then
            setBossHealthColor(Uuid(), ColorRGB(1, 0.5, 0), nil)
        elseif quote < 0.8 then
            setBossHealthColor(Uuid(), ColorRGB(1, 0.3, 0), nil)
        else
            setBossHealthColor(Uuid(), ColorRGB(0.6, 0, 0), nil)
        end
    end
end

end

function GuardianPrecursorBar.terminateServer()
    terminate()
end
callable(GuardianPrecursorBar, "terminateServer")
