package.path = package.path .. ";data/scripts/lib/?.lua"

include("randomext")
local SectorGenerator = include("SectorGenerator")
local Placer = include("placer")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace RespawnResourceAsteroids
RespawnResourceAsteroids = {}

if onServer() then

function RespawnResourceAsteroids.initialize()

    local sector = Sector()
    local richAsteroids = sector:getNumEntitiesByComponent(ComponentType.MineableMaterial)
    local numAsteroids = sector:getNumEntitiesByType(EntityType.Asteroid)

    if richAsteroids / numAsteroids > 0.015 then return end

    -- respawn them
    local asteroids = {Sector():getEntitiesByType(EntityType.Asteroid)}
    local generator = SectorGenerator(Sector():getCoordinates())

    local spawned = {}

    for _, asteroid in pairs(asteroids) do

        local sphere = Sphere(asteroid.translationf, 200.0)
        local others = {Sector():getEntitiesByLocation(sphere)}

        local numEmptyAsteroids = 0
        if #others >= 10 then
            for _, entity in pairs(others) do
                if entity:hasComponent(ComponentType.MineableMaterial) then
                    numEmptyAsteroids = 0
                    break
                end

                if entity.type == EntityType.Asteroid then
                    numEmptyAsteroids = numEmptyAsteroids + 1
                end
            end
        end

        if numEmptyAsteroids >= 10 then
            local translation = sphere.center + random():getDirection() * sphere.radius
            local size = random():getFloat(5.0, 15.0)

            local asteroid = generator:createSmallAsteroid(translation, size, true, generator:getAsteroidType())

            table.insert(spawned, asteroid)

            richAsteroids = richAsteroids + 1
            numAsteroids = numAsteroids + 1
        end

        if richAsteroids / numAsteroids > 0.06 then break end
    end

    Placer.resolveIntersections(spawned)
end


end
