package.path = package.path .. ";data/scripts/lib/?.lua"
include ("stringutility")
include ("randomext")
include ("callable")
include ("galaxy")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace RadioChatter
RadioChatter = {}
local self = RadioChatter
local xsotanChatter = nil

if onClient() then

self.entityTimes = {}
self.specificLines = {}

self.EntityTimeBetweenSpeechBubbles = 120

self.GeneralStationChatter =
{
    -- jibber jabber
    "Dock ${LN2} is clear."%_t,
    "Dock ${LN2} is not clear."%_t,
    "${R}: Docking permission granted."%_t,
    "${R}: Docking permission denied."%_t,
    "Approach vector ${N2}/${N} confirmed."%_t,
    "We cannot allow just anybody to come aboard."%_t,
    "General reminder to the populace: open doors create unnecessary suction."%_t,
    "According to form ${R}, all taxes have been paid."%_t,
    "Requesting confirmation of received goods."%_t,
    "All incoming vessels: we welcome you in our sector and we hope for you that your intentions are peaceful."%_t,
    "Freighter ${N2}: this is ${R}. Please identify yourself."%_t,
    "Oh, back so early?"%_t,
    "Major Tom, please come in."%_t,
    "Please repeat the last statement."%_t,
    "${R}, what is your estimated time of arrival?"%_t,
    "${R}, you're free to dock. Choose whichever dock you please."%_t,
    "${R}, please send us position and approach angle."%_t,
    "Negative, we are still waiting for the delivery."%_t,
    "Hello ${R}, it's great to see you again!"%_t,
    "${R}? What are you guys doing here?"%_t,
    "This is the automated response system. Denied requests can be reviewed at any time by our algorithm."%_t,
    "Mandatory meeting of all station commanders tomorrow in room ${R}."%_t,
    "${R}, please come in."%_t,
    "No, that form is no longer up to date."%_t,
    "We ask all captains and pilots not to occupy docks any longer than necessary."%_t,
}

self.GeneralShipChatter =
{
    -- jibber jabber
    "Hyperspace engine is a code ${N2}, shields are a code ${N}. Repairs not urgent, but welcome."%_t,
    "Requesting permission to dock."%_t,
    "Requesting flight vector."%_t,
    "We are now at vector ${N2}/${N}."%_t,
    "Negative, we are still waiting for our goods."%_t,
    "Asking for clearance."%_t,
    "So far, so good."%_t,
    "I have a bad feeling about this."%_t,
    "${R} entering flight vector."%_t,

    -- weapons
    "Personally, I don't like those fancy energy weapons. I'd take some good old chain guns over plasma any day."%_t,
    "... yeah, but shields are nearly useless against plasma weapons."%_t,
    "Railguns rip through a ship's hull like hot targo through a panem. /* Those are fantasy words */"%_t,

    -- general hints
    "One of these days I'll find one of those asteroids and claim it for myself."%_t,
    "No, no, no! With R-Mining Lasers, you get high yields of ores that you have to refine!"%_t,
    "Greedy bastard got himself killed going after the yellow blips on his galaxy map. Pirates everywhere."%_t,
    "Yes, really! If you don't shoot the Xsotan, they just move on! Saw it with my own eyes!"%_t,
    "The lightest material in the galaxy is Trinium. Trinium ships are a dream to steer."%_t,
    "They started building Cloning Pods with Xanion. Gives me the shivers."%_t,

    -- flair
    "Contact message: We have encountered increased pirate presence in the vicinity. Combat operation requested."%_t,
}

self.HostileShipChatter =
{
    -- Move along
    "Hey you! You'd better move along!"%_t,
    "You need to leave."%_t,
    "Leave our territory."%_t,
    "Please leave our territory."%_t,
    "You should leave our territory."%_t,
    "You had better run along."%_t,
    "I think it would be better for you to move on."%_t,

    -- More formal move along
    "This is a friendly reminder: please leave our territory."%_t,
    "This is a friendly reminder: hostile parties are not welcome, and will find their stay less than rewarding."%_t,
    "You aren't welcome around these parts. We kindly ask you to vacate our territory."%_t,
    "According to our records, you're an enemy of our faction. Please leave our territory, otherwise we'll have to take actions against you."%_t,
    "We'd like to ask you to leave our territory. You're not welcome here."%_t,
    "Our records state that you have to leave our territory."%_t,
    "Our leadership has ordered us to open fire if you don't leave our territory."%_t,

    -- Threatening
    "We've got our eyes on you. One wrong step is all it takes."%_t,
    "We've got orders to shoot down any hostiles if they try something and right now you're on that list. Better move on."%_t,
    "There they are again. Should we shoot them down?"%_t,
    "I hope you're only passing through. Otherwise things could get ugly."%_t,
    "This is a friendly reminder: our faction has mercenaries on their payroll."%_t,
    "This is a friendly reminder: if you don't leave our territory, we will open fire."%_t,
    "This is an unfriendly reminder to leave. Now."%_t,
    "Warning: if you don't leave this territory, we will open fire."%_t,
    "Warning: mercenaries have been contacted."%_t,
    "Warning: your details have been forwarded to our mercenary squad."%_t,
}

self.XsotanSwarmChatter = {
{
    -- xsotanSwarmOngoing
    "There are too many!"%_t,
    "SOS! We're being overrun! Requesting immediate backup!"%_t,
    "When will it stop? Please make it stop!"%_t,
    "Bloody Xsotan. We'll show you how to stand fast!"%_t,
    "We won't lose! Stay strong!"%_t,
},
{
    -- xsotanSwarmSuccess
    "Let's hope this swarm never comes back!"%_t,
    "We showed them damn Xsotan! Woohoo!"%_t,
    "Did those Xsotan really think they could win?!"%_t
},
{
    -- xsotanSwarmFail
    "Have we really lost? What now?"%_t,
    "We hoped to defeat the Xsotan plague once and for all. Guess it wasn't meant to be."%_t
},
{
    -- xsotanSwarmForeshadow
    "The Xsotan swarm was so damn strong. Let's hope this doesn't happen again!"%_t,
    "It's so good that we defeated the Xsotan swarm. Who knows what would have happened otherwise."%_t,
    "A lot of Xsotan appeared on our radars... are they regrouping?"%_t,
}
}

local x, y = Sector():getCoordinates()
local dist = length(vec2(x, y))

if dist > 350 and dist < 430 then
    -- swoks
    table.insert(self.GeneralShipChatter, "Yes, Swoks was his name. I heard he ambushes anyone who is looking for new Titanium asteroid fields."%_t)
    table.insert(self.GeneralShipChatter, "Don't fly around outside the civilized sectors, or Swoks will come for you."%_t)
    table.insert(self.GeneralShipChatter, "Have you heard of this pirate boss, too?"%_t)
    table.insert(self.GeneralShipChatter, "Oh no, not here. I won't take even a single jump outside the civilized sectors."%_t)
    table.insert(self.GeneralShipChatter, "You should stay on the gate routes. There is increased pirate activity in the unexplored and empty sectors."%_t)

    table.insert(self.GeneralShipChatter, "Yes, around here. He appears when you do ten consecutive jumps into empty sectors."%_t)
    table.insert(self.GeneralShipChatter, "There's a myth around here: after ten consecutive jumps through empty sectors, Swoks will come for you."%_t)
    table.insert(self.GeneralShipChatter, "Personally, I don't believe it, but they say that after at least ten consecutive jumps through empty sectors, Swoks will come for you."%_t)
    table.insert(self.GeneralShipChatter, "... don't ask ME how he does it! All I know is, that after ten jumps into empty sectors, he'll come for you."%_t)

end

if dist > 240 and dist < 340 then
    -- the AI
    table.insert(self.GeneralShipChatter, "When you venture off into the unknown around here, you can find old war machines."%_t)
    table.insert(self.GeneralShipChatter, "Don't trail off into the unknown. There is some unknown terror around here."%_t)
    table.insert(self.GeneralShipChatter, "Oh no, not here. I won't take even a single jump outside the civilized sectors."%_t)
    table.insert(self.GeneralShipChatter, "I've heard it's an old AI, programmed to fight the Xsotan."%_t)
    table.insert(self.GeneralShipChatter, "It's harmless. Just don't attack it and don't be in the same sector when there are Xsotan."%_t)
    table.insert(self.GeneralShipChatter, "I've seen it once. It's huge and green and terrifying, with tons of plasma cannons."%_t)

    table.insert(self.GeneralShipChatter, "Yes, it tracks you when you jump through no-man's space. Ten jumps or more and you're guaranteed to meet it."%_t)
    table.insert(self.GeneralShipChatter, "Do you actually believe in this myth? How would the number of jumps into empty sectors influence you meeting a monster?"%_t)
    table.insert(self.GeneralShipChatter, "... and it's always watching. It tracks your jumps. Ten or more and it'll come for you."%_t)

end

if dist > 150 and dist < 240 then
    -- energy lab
    table.insert(self.GeneralShipChatter, "You can find those satellites in the yellow-blip sectors around here."%_t)
    table.insert(self.GeneralShipChatter, "There are plenty of those research satellites around here, in the non-civilized sectors."%_t)
    table.insert(self.GeneralShipChatter, "My buddy tried to salvage some of those yellow-blip satellites a few days back. Haven't heard from him since."%_t)
    table.insert(self.GeneralShipChatter, "Those new weapons sound like a threat. Are you sure they can't penetrate stone?"%_t)
    table.insert(self.GeneralShipChatter, "Stone can help you defend even against the strongest lightning weapons."%_t)
    table.insert(self.GeneralShipChatter, "They lost contact with their scouts. All they registered was an intense energy signature."%_t)
end

if dist > 350 then
    table.insert(self.GeneralShipChatter, "Yes, you can build shield generators out of Naonite! I have to find some!"%_t)
    table.insert(self.GeneralShipChatter, "Naonite, that green metal. Lets you build shield generators. Won't protect against collisions though."%_t)
    table.insert(self.GeneralShipChatter, "I know there's plenty of Iron floating around, but you should really look for Titanium to build your ship."%_t)
    table.insert(self.GeneralShipChatter, "I equipped a buddy's ship with Titanium Integrity Generators. Now it can take quite a few more hits before it breaks apart."%_t)
    table.insert(self.GeneralShipChatter, "I'll start looking for Naonite soon. I really need shield generators."%_t)

end

if dist > 330 then
    table.insert(self.GeneralShipChatter, "Best ship building material around here? Titanium. So much lighter than both Naonite and Iron."%_t)
    table.insert(self.GeneralShipChatter, "What? It's your own fault that you don't build ships out of Titanium, it's 42% lighter than Iron!"%_t)
end

--chatter only outside the barrier
if dist > Balancing_GetBlockRingMax() then
    -- swoks
    table.insert(self.GeneralShipChatter, "I heard that in the Iron and Titanium regions, there is this pirate leader Swoks who ambushes anyone who explores the non-civilized sectors."%_t)
    table.insert(self.GeneralShipChatter, "The pirate infestation in the Iron and Titanium regions just doesn't end. As if their leader had doppelgangers."%_t)
    table.insert(self.GeneralShipChatter, "Have you heard of this pirate boss in the Iron and Titanium regions, too?"%_t)
    table.insert(self.GeneralShipChatter, "Don't go exploring in the Iron and Titanium reaches, or you'll be killed by Swoks."%_t)
    table.insert(self.GeneralShipChatter, "Don't fly around outside the civilized sectors in the Iron and Titanium reaches, or Swoks will come for you."%_t)

    -- the 4
    table.insert(self.GeneralShipChatter, "Have you heard of this Brotherhood? Apparently they're looking for Xsotan Artifacts near the Barrier."%_t)
    table.insert(self.GeneralShipChatter, "My colleague found a Xsotan artifact once. He took it to the Brotherhood. Haven't heard from him since."%_t)
    table.insert(self.GeneralShipChatter, "When I find one of those Xsotan artifacts, I'll take it to the Brotherhood and get rich."%_t)
    table.insert(self.GeneralShipChatter, "The Brotherhood pays anyone who brings them Xsotan artifacts good money."%_t)

    -- exodus
    table.insert(self.GeneralShipChatter, "... I kid you not! Some kind of beacon that always repeats the same message."%_t)
    table.insert(self.GeneralShipChatter, "I don't know how they are activated, but apparently those old gates take you far away."%_t)
    table.insert(self.GeneralShipChatter, "My nephew's brother in law's friend told me about this mysterious gate network."%_t)
    table.insert(self.GeneralShipChatter, "... In order to activate those gates, you need Xsotan artifacts."%_t)
    table.insert(self.GeneralShipChatter, "... beacons that always repeat the same message. I found one in an asteroid field."%_t)

    -- research artifact
    table.insert(self.GeneralShipChatter, "Apparently the AI of Research Stations combines legendary-tier upgrades into something new and strange."%_t)
    table.insert(self.GeneralShipChatter, "Some researchers of my wife's Research Station combined legendary-tier upgrades into something new."%_t)
    table.insert(self.GeneralShipChatter, "... and the three legendary-tier upgrades turned into something weird. An artifact with two scratches on it."%_t)
end

--chatter only inside the barrier
if dist < Balancing_GetBlockRingMax() then
    -- xsotan swarm
    table.insert(self.GeneralShipChatter,"Remember the great Xsotan Attack? Hundreds of Xsotan swarming all over.\nI wonder what made them stop."%_t)


    -- corrupted AI
    table.insert(self.GeneralShipChatter,"... and they turned it against us... without knowing our language."%_t)
    table.insert(self.GeneralShipChatter,"A lot of the parts that had broken off started flying in our direction and tried to ram us."%_t)

    -- laserboss
    table.insert(self.GeneralShipChatter,"The whole ship...destroyed in seconds."%_t)
    table.insert(self.GeneralShipChatter,"It was protected by some new technology, had something to do with the asteroids around it."%_t)
    table.insert(self.GeneralShipChatter,"We evaded its big laser, but there was no damaging it!"%_t)

end

function RadioChatter.getUpdateInterval()
    if not self.which then return 1 end

    return 30 + random():getInt(15)
end

function RadioChatter.addStationChatter(lines)
    for _, line in pairs(lines) do
        table.insert(self.GeneralStationChatter, line)
    end
end

function RadioChatter.addShipChatter(lines)
    for _, line in pairs(lines) do
        table.insert(self.GeneralShipChatter, line)
    end
end

function RadioChatter.addHostileShipChatter(lines)
    for _, line in pairs(lines) do
        table.insert(self.HostileShipChatter, line)
    end
end

function RadioChatter.addSpecificLines(id, lines)
    local entity = Entity(id)
    if entity then
        entity:setValue("npc_chatter", true)
    end

    local id_str = tostring(id)

    local tbl = self.specificLines[id_str]
    if not tbl then
        tbl = {}
        self.specificLines[id_str] = tbl
    end

    for _, line in pairs(lines) do
        table.insert(tbl, line)
    end
end


local generalChatter =
{
    -- jibber jabber
    "Radio test: Can you hear me? Frank? Hello?"%_t,
    "Checking radio... Changing frequency to ${R}."%_t,
    "Looks like the comm is still on."%_t,

    -- general flair
    "The Xsotan are slowly becoming a threat."%_t,
    "I heard that inside the Barrier, the Xsotan eat up entire planets."%_t,
}

RadioChatter.addStationChatter(generalChatter)
RadioChatter.addShipChatter(generalChatter)

function RadioChatter.updateClient()
    self.which = self.which or random():getInt(1, 2)

    if self.which == 1 then
        self.updateStationChatter()
        self.which = 2
    else
        self.updateShipChatter()
        self.which = 1
    end
end

function RadioChatter.selectLine(entity, general)
    local specific = self.specificLines[entity.id.string]

    local line = ""
    if specific and random():test(0.35) then
        line = randomEntry(random(), specific)
    else
        line = randomEntry(random(), general)
    end

    return self.fillInIdentifiers(line)
end

function RadioChatter.getChatterCandidates(type)

    local firstSelection = {}
    if type == EntityType.Station then
        firstSelection = {Sector():getEntitiesByType(EntityType.Station)}
    else
        firstSelection = {Sector():getEntitiesByScriptValue("npc_chatter")}
    end

    if #firstSelection == 0 then return {} end

    local player = Player()
    local now = appTime()

    local candidates = {}
    for _, candidate in pairs(firstSelection) do
        if candidate:getValue("is_xsotan") then goto continue end
        if candidate.type ~= type then goto continue end
        if player and player:getRelationStatus(candidate.factionIndex) == RelationStatus.War then goto continue end

        local time = self.entityTimes[candidate.id.string]
        if time and now - time < self.EntityTimeBetweenSpeechBubbles then goto continue end

        local ai = ShipAI(candidate)
        if ai and (ai.isBusy or ai.isAttackingSomething) then goto continue end

        table.insert(candidates, candidate)

        ::continue::
    end

    return candidates
end

function RadioChatter.updateStationChatter()
    local stations = RadioChatter.getChatterCandidates(EntityType.Station)
    if #stations == 0 then return end

    local station = randomEntry(random(), stations)
    if station.hasPilot then return end -- don't show chatter if player is flying this ship

    -- if relations are hostile, player shouldn't be able to listen in on chatter
    if Player():getRelations(station.factionIndex) < -80000 then return end

    self.entityTimes[station.id.string] = appTime()

    -- check for xsotan event
    RadioChatter.showXsotanSwarmChatter()
    RadioChatter.sync()

    if xsotanChatter and dist < 150 then
        displaySpeechBubble(station, randomEntry(random(), self.XsotanSwarmChatter[xsotanChatter]))
    else
        displaySpeechBubble(station, self.selectLine(station, self.GeneralStationChatter))
    end
end

function RadioChatter.updateShipChatter()
    local ships = RadioChatter.getChatterCandidates(EntityType.Ship)
    if #ships == 0 then return end

    local ship = randomEntry(random(), ships)
    if ship.hasPilot then return end -- don't show chatter if player is flying this ship
    self.entityTimes[ship.id.string] = appTime()

    -- check for xsotan event
    RadioChatter.showXsotanSwarmChatter()
    RadioChatter.sync()

    if Player():getRelations(ship.factionIndex) < -80000 then
        displaySpeechBubble(ship, self.selectLine(ship, self.HostileShipChatter))
    else
        if xsotanChatter and dist < 150 then
            displaySpeechBubble(ship, randomEntry(random(), self.XsotanSwarmChatter[xsotanChatter]))
        else
            displaySpeechBubble(ship, self.selectLine(ship, self.GeneralShipChatter))
        end
    end
end

function RadioChatter.generate(chars, num)
    local result = ""

    for i = 1, num do
        local c = random():getInt(1, #chars)
        result = result .. chars:sub(c, c)
    end

    return result
end

function RadioChatter.fillInIdentifiers(str)

    local numbers = "0123456789"
    local letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

    local args = {}
    args.L = self.generate(letters, 1)
    args.L2 = self.generate(letters, 2)
    args.L3 = self.generate(letters, 3)
    args.L4 = self.generate(letters, 4)

    args.N = self.generate(numbers, 1)
    args.N2 = self.generate(numbers, 2)
    args.N3 = self.generate(numbers, 3)
    args.N4 = self.generate(numbers, 4)

    args.LN = self.generate(letters, 1) .. "-" .. self.generate(numbers, 1)
    args.LN2 = self.generate(letters, 1) .. "-" .. self.generate(numbers, 2)
    args.LN3 = self.generate(letters, 1) .. "-" .. self.generate(numbers, 3)
    args.L2N = self.generate(letters, 2) .. "-" .. self.generate(numbers, 1)
    args.L2N2 = self.generate(letters, 2) .. "-" .. self.generate(numbers, 2)
    args.L2N3 = self.generate(letters, 2) .. "-" .. self.generate(numbers, 3)

    args.player = Player().name

    if random():getInt(1, 2) == 1 then
        args.R = self.generate(letters, random():getInt(1,2)) .. "-" .. self.generate(numbers, random():getInt(1,2))
    else
        args.R = self.generate(numbers, random():getInt(1,2)) .. "-" .. self.generate(letters, random():getInt(1,2))
    end

    return str % args
end


end

function RadioChatter.showXsotanSwarmChatter()
    if onClient() then invokeServerFunction("showXsotanSwarmChatter") return end

    local server = Server()
    if server:getValue("xsotan_swarm_active") then
        xsotanChatter = 1
    else
        local swarmSuccess = server:getValue("xsotan_swarm_success")
        local swarmTime = server:getValue("xsotan_swarm_time")
        if swarmTime and swarmTime < (15 * 60) then
            xsotanChatter = 4
        elseif swarmSuccess and swarmTime and swarmTime > (115 * 60) then
            xsotanChatter = 2
        elseif swarmSuccess == false and swarmTime and swarmTime > (115 * 60) then
            xsotanChatter = 3
        else
            xsotanChatter = nil
        end
    end
    RadioChatter.sync()
end
callable(RadioChatter, "showXsotanSwarmChatter")

function RadioChatter.sync(data_in)
    if onServer() then invokeClientFunction(Player(callingPlayer), "sync", xsotanChatter) return end
    if onClient() then
        if data_in then xsotanChatter = data_in else invokeServerFunction("sync") end
    end
end
callable(RadioChatter, "sync")

