
package.path = package.path .. ";data/scripts/lib/?.lua"
include ("defaultscripts")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace BoardingUtility
BoardingUtility = {}

local forbidden = {}
forbidden["data/scripts/entity/antismuggle.lua"] = true
forbidden["data/scripts/entity/blocker.lua"] = true
forbidden["data/scripts/entity/civilship.lua"] = true
forbidden["data/scripts/entity/claim.lua"] = true
forbidden["data/scripts/entity/claimalliance.lua"] = true
forbidden["data/scripts/entity/deleteonplayersleft.lua"] = true
forbidden["data/scripts/entity/restoreshipcountondelete.lua"] = true

if onServer() then

function BoardingUtility.initialize()
    local sector = Sector()
    sector:registerCallback("onBoardingSuccessful", "onBoardingSuccessful")
end

function BoardingUtility.onBoardingSuccessful(id, oldFactionIndex, newFactionIndex)
    local newFaction = Faction(newFactionIndex)
    if not newFaction then return end

    -- only update scripts if a player now owns the craft
    if not newFaction.isAIFaction then
        local entity = Entity(id)
        BoardingUtility.updateScripts(entity)
        BoardingUtility.clearScriptValues(entity)
    end

end

function BoardingUtility.clearScriptValues(entity)
    entity:clearValues()
end

function BoardingUtility.updateScripts(entity)
--    print("update scripts")

    for index, name in pairs(entity:getScripts()) do
        if string.match(name, "data/scripts/entity/ai/") or
                string.match(name, "data/scripts/entity/dialogs/") or
                string.match(name, "data/scripts/entity/story/") or
                string.match(name, "data/scripts/entity/merchants/") then

--            print("removing script '" .. name .. "'")
            entity:removeScript(index)

        elseif forbidden[name] then
--            print("removing script  '" .. name .. "'")
            entity:removeScript(index)
        end
    end

    if entity.type == EntityType.Ship then
        AddDefaultShipScripts(entity)
    elseif entity.type == EntityType.Station then
        AddDefaultStationScripts(entity)
        SetBoardingDefenseLevel(entity)

        local type = entity:getValue("factory_type")
        if type and type == "mine" then
            entity:addScript("data/scripts/entity/derelictminefounder.lua")
        else
            entity:addScript("data/scripts/entity/derelictstationfounder.lua")
        end
    end
end

end
