
package.path = package.path .. ";data/scripts/lib/?.lua"
include("utility")
include("stringutility")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace SectorShipOverview
SectorShipOverview = {}
local self = SectorShipOverview

if onClient() then

function SectorShipOverview.getUpdateInterval()
    return 1
end

function SectorShipOverview.initialize()
    local player = Player()
    player:registerCallback("onStateChanged", "onPlayerStateChanged")

    local res = getResolution()
    local size = vec2(350, 600)
    local position = vec2(res.x - size.x - 20, 180)

    local rect = Rect(position, position + size )

    self.window = Hud():createWindow(rect)
    self.window.caption = "Sector"%_t
    self.window.moveable = true
    self.window.showCloseButton = true

    local hsplit = UIHorizontalSplitter(Rect(size), 0, 10, 0.0)
    self.list = self.window:createListBoxEx(hsplit.bottom)
    self.list.columns = 2
    self.list:setColumnWidth(0, 25)
    self.list:setColumnWidth(1, self.list.width)
    self.list.onSelectFunction = "onEntrySelected"

    self.show()
    self.hide()
end

function SectorShipOverview.updateClient(timeStep)
    if not self.window.visible then return end

    self.refreshList()
end

function SectorShipOverview.refreshList()
    local player = Player()
    local sector = Sector()

    local stationList = {header = "Stations"%_t, entries = {}}
    local shipList = {header = "Ships"%_t, entries = {}}
    local gateList = {header = "Other"%_t, entries = {}}
    local lists = {stationList, shipList, gateList}


    -- collect stations
    local stations = {sector:getEntitiesByType(EntityType.Station)}
    for _, entity in pairs(stations) do

        local name = entity.translatedTitle or ""
        local icon = ""

        local iconComponent = EntityIcon(entity)
        if iconComponent then icon = iconComponent.icon end

        if name == "" then name = entity.typename %_t .. " - " .. (entity.name or "<No Name>"%_t) end

        table.insert(stationList.entries, {entity = entity, icon = icon, name = name, faction = entity.factionIndex or 0})
    end

    -- collect ships
    local ships = {sector:getEntitiesByType(EntityType.Ship)}
    for _, entity in pairs(ships) do

        local name = entity.translatedTitle or ""
        local icon = ""

        local iconComponent = EntityIcon(entity)
        if iconComponent then icon = iconComponent.icon end

        if name == "" then name = entity.typename %_t .. " - " .. (entity.name or "<No Name>"%_t) end

        table.insert(shipList.entries, {entity = entity, icon = icon, name = name, faction = entity.factionIndex or 0})
    end

    -- collect all other objects
    local gates = {sector:getEntitiesByComponent(ComponentType.WormHole)}
    for _, entity in pairs(gates) do

        local name = ""
        local icon = ""

        if entity:hasComponent(ComponentType.Plan) then
            name = entity.translatedTitle

            local iconComponent = EntityIcon(entity)
            if iconComponent then icon = iconComponent.icon end
        else
            name = "Wormhole"%_t
        end

        table.insert(gateList.entries, {entity = entity, icon = icon, name = name, faction = 0})
    end

    -- sort to make it easier to read
    for _, list in pairs(lists) do
        table.sort(list.entries, function(a, b)
            if a.icon == b.icon then
                if a.faction == b.faction then
                    if a.name == b.name then
                        return a.entity.id.string < b.entity.id.string
                    end
                    return a.name < b.name
                end
                return a.faction < b.faction
            end
            return a.icon < b.icon
        end)
    end

    local selected = self.list.selectedValue
    local scrollPosition = self.list.scrollPosition

    self.list:clear()

    local white = ColorRGB(1, 1, 1)

    for _, list in pairs(lists) do
        if #list.entries > 0 then
            self.list:addRow(nil, "", "--- " .. list.header .. " ---")

            for _, entry in pairs(list.entries) do

                local entity = entry.entity

                local color = ColorRGB(1, 1, 1)
                if entity.factionIndex and entity.factionIndex > 0 then
                    local relation = player:getRelation(entity.factionIndex)

                    color = relation.color
                end

                self.list:addRow(entity.id.string)
                self.list:setEntry(0, self.list.rows-1, entry.icon, false, false, white)
                self.list:setEntry(1, self.list.rows-1, entry.name, false, false, color)

                self.list:setEntryType(0, self.list.rows-1, 3)
            end

            self.list:addRow()
        end
    end

    if player.selectedObject then
        self.list:selectValueNoCallback(player.selectedObject.string)
    end

    self.list.scrollPosition = scrollPosition

end

function SectorShipOverview.show()
    self.window:center()
    self.window:show()

    self.refreshList()

    Sector():registerCallback("onEntityCreated", "onEntityCreated")
end

function SectorShipOverview.hide()
     self.window:hide()
end

function SectorShipOverview.onEntrySelected(index, value)
    if not value or value == "" then return end

    local player = Player()

    player.selectedObject = Entity(value)
end

function SectorShipOverview.onPlayerStateChanged(new,  old)

    if new == PlayerStateType.Strategy then
        self.show()
    else
        self.hide()
    end

end

end
