package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/player/ui/encyclopedia/lib/?.lua"
package.path = package.path .. ";data/scripts/player/ui/encyclopedia/?.lua"

include("stringutility")
include("utility")
include("callable")

if onClient() then
--include("chapters/template")
---[[
include("chapters/basics")
include("chapters/exploring")
include("chapters/building")
include("chapters/resourcemanagement")
include("chapters/craftmanagement")
include("chapters/fleetmanagement")
include("chapters/diplomacy")
include("chapters/combat")
include("chapters/trade")
include("chapters/coopmultiplayer")
--]]
end

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace Encyclopedia
Encyclopedia = {}
local self = Encyclopedia

if onClient() then

self.categories = {}
self.chapters = {}
self.articles = {}

self.titleLabel = nil
self.picture = nil
self.pictureLabel = nil
self.textField = nil
self.nextButton = nil
self.backButton = nil
self.originalRect = nil
self.tab = nil
self.tree = nil

function Encyclopedia.initialize()
    self.tab = PlayerWindow():createTab("Encyclopedia"%_t, "data/textures/icons/open-book.png", "Encyclopedia"%_t)

    local vsplit = UIVerticalSplitter (Rect(self.tab.size), 10, 0, 0.3)

    -- create the tree that will be filled with content
    self.tree = self.tab:createTree(vsplit.left)
    self.fillTree()

    -- create the right side that will display the content
    local hsplit = UIHorizontalSplitter(vsplit.right, 30, 0, 0.5)
    hsplit.topSize = 20

    local hsplit2 = UIHorizontalSplitter(hsplit.bottom, 10, 0, 0.60)

    local hsplit3 = UIHorizontalSplitter(hsplit2.bottom, 10, 0, 0.5)
    hsplit3.bottomSize = 35

    hsplit.marginLeft = 10
    local titleRect = hsplit.top
    local textRect = hsplit3.top
    local buttonsRect = hsplit3.bottom

    self.titleLabel = self.tab:createLabel(titleRect, "Avorion Encyclopedia"%_t, 30)

    self.originalRect = hsplit2.top
    self.picture = self.tab:createPicture(self.originalRect, "data/textures/ui/mining_changes/mining-alpha.png")
    self.picture.flipped = true

    -- extra layer to show key binding
    self.pictureLabel = self.tab:createLabel(Rect(self.originalRect.lower + 25, self.originalRect.upper - 25), "Ctrl", 25)
    self.pictureLabel:setBottomLeftAligned()
    self.pictureLabel:hide()

    -- background for text field
    local backgroundBox = self.tab:createFrame(textRect)

    local text = "Welcome to the Avorion \\c(0d0)Encyclopedia\\c()! This is where you'll find information on a lot of Avorion's features.\n\nSimply select one of the \\c(0d0)categories\\c() on the left to get started!"%_t
    self.textField = self.tab:createTextField(textRect, text)
    self.textField.scrollable = false
    self.textField.font = FontType.Normal
    self.textField.fontSize = 14
    self.textField.fontColor = ColorRGB(0.7, 0.7, 0.7)

    local vsplit = UIVerticalMultiSplitter(buttonsRect, 10, 0, 3)
    self.backButton = self.tab:createButton(vsplit.left, "<", "onBackPressed")
    self.nextButton = self.tab:createButton(vsplit.right, ">", "onNextPressed")
end

function Encyclopedia.getCurrentEntry()
    local index = self.tree.selectedIndex
    local result = self.categories[index]
    if not result then result = self.chapters[index] end
    if not result then result = self.articles[index] end

    return result
end

function Encyclopedia.getCurrentArticle()

    local entry = Encyclopedia.getCurrentEntry()
    if not entry then return nil end

    if entry.text then return entry end

    if entry.chapters then
        entry = entry.chapters[1]
    end
    if entry.text then return entry end

    -- check if entry has articles
    if entry.articles then
        entry = entry.articles[1]
    end
    if entry.text then return entry end

    return nil

end

function Encyclopedia.fillTree()
    -- remember index, so that we can go on where we left off after updating tree
    local index = self.tree.selectedIndex

    -- clear tree and refill it
    self.tree:clear()
    self.categories = {}
    self.chapters = {}
    self.articles = {}

    for _, category in pairs(Categories or {}) do

        if category.isUnlocked then
            if not category:isUnlocked() then
                goto continueCategory
            end
            category.unlocked = true
        end

        local hasContent = (category.text ~= nil)
        local categoryIndex = self.tree:add(nil, category.title, "onEntrySelected", hasContent)
        self.categories[categoryIndex] = category

        for _, chapter in pairs(category.chapters or {}) do

            if chapter.isUnlocked then
                if not chapter:isUnlocked() then
                    goto continueChapter
                end
                chapter.unlocked = true
            end

            local hasContent = (chapter.text ~= nil)
            local chapterIndex = self.tree:add(categoryIndex, chapter.title, "onEntrySelected", hasContent)
            self.chapters[chapterIndex] = chapter

            for _, article in pairs(chapter.articles or {}) do

                if article.isUnlocked then
                    if not article:isUnlocked() then
                        goto continueArticle
                    end
                    article.unlocked = true
                end

                local hasContent = (article.text ~= nil)
                local articleIndex = self.tree:add(chapterIndex, article.title, "onEntrySelected", hasContent)
                self.articles[articleIndex] = article

                ::continueArticle::
            end
            ::continueChapter::
        end
        ::continueCategory::
    end

    -- put saved index back
    self.tree.selectedIndex = index

end

function Encyclopedia.onBackPressed()
    self.tree:selectPrevious()
    self.refreshUI()
end

function Encyclopedia.onNextPressed()
    self.tree:selectNext()
    self.refreshUI()
end

function Encyclopedia.onEntrySelected(index)
    self.tree.selectedIndex = index
    self.refreshUI()
end

function Encyclopedia.getUpdateInterval()
    return 1
end

function Encyclopedia.update(timeStep)

    -- check whether a new article is available
    local newUnlocked = false
    local entryToUnlock = nil
    for _, category in pairs(Categories or {}) do
        if category.isUnlocked then
            if not category.unlocked and category:isUnlocked() then
                newUnlocked = true
                entryToUnlock = category
                category.unlocked = true
            end
        end

        for _, chapter in pairs(category.chapters or {}) do
            if chapter.isUnlocked then
                if not chapter.unlocked and chapter:isUnlocked() then
                    newUnlocked = true
                    entryToUnlock = chapter
                    chapter.unlocked = true
                end
            end

            for _, article in pairs(chapter.articles or {}) do
                if article.isUnlocked then
                    if not article.unlocked then
                        if article:isUnlocked() then
                            newUnlocked = true
                            entryToUnlock = article
                            article.unlocked = true
                        end
                    end
                end
            end
        end
    end

    if newUnlocked then
        invokeServerFunction("sendChangeNotification", entryToUnlock)
        self.fillTree()
    end


    -- update currently viewed article
    local article = self.getCurrentArticle()
    if not article then return end
    if not article.pictures then return end

    local timePerFrame = 1 / (article.fps or 1)
    article.timer = (article.timer or 0) + timeStep
    if article.timer > timePerFrame then
        article.timer = article.timer - timePerFrame

        -- increase frame and update picture
        article.frame = (article.frame or 1) + 1
        if article.frame > #article.pictures then
            article.frame = 1
        end

        article.picture = article.pictures[article.frame]
        if type(article.picture) == "table" then
            self.picture.picture = article.picture.path
            self.pictureLabel.caption = article.picture.caption
            self.pictureLabel.active = article.picture.showLabel
            self.pictureLabel:show()
        else
            self.picture.picture = article.picture
            self.pictureLabel:hide()
        end

        self.picture.rect = Rect(self.originalRect.lower + self.tab.lower, self.originalRect.upper + self.tab.lower)
        self.picture:fitIntoRect()
    end

end

function Encyclopedia.refreshUI()

    local entry = self.getCurrentEntry()
    local currentArticle = self.getCurrentArticle()

    if currentArticle then
        if currentArticle.pictures then
            if type(currentArticle.pictures[1]) == "table" then
                currentArticle.picture = currentArticle.pictures[1].path
                self.pictureLabel.caption = currentArticle.pictures[1].caption
                self.pictureLabel.active = currentArticle.pictures[1].showLabel
                self.pictureLabel:show()
            else
                currentArticle.picture = currentArticle.pictures[1]
                self.pictureLabel:hide()
            end
            currentArticle.frame = 1
            currentArticle.timer = 0
        elseif currentArticle.picture then
            if type(currentArticle.picture) == "table" then
                self.pictureLabel.caption = currentArticle.picture.caption
                self.pictureLabel.active = currentArticle.picture.showLabel
                self.pictureLabel:show()
            else
                self.pictureLabel:hide()
            end
        end

        self.titleLabel.caption = currentArticle.title or entry.title or ""
        self.picture.picture = currentArticle.picture or ""
        self.textField.text = currentArticle.text or ""

        self.picture.rect = Rect(self.originalRect.lower + self.tab.lower, self.originalRect.upper + self.tab.lower)
        self.picture:fitIntoRect()
        self.picture:show()
    else
        self.titleLabel.caption = ""
        self.picture:hide()
        self.pictureLabel:hide()
        self.textField.text = ""
    end

end

end

if onServer() then

function Encyclopedia.setValue(name)
    Player():setValue("encyclopedia_"..name, true)
end
callable(Encyclopedia, "setValue")

function Encyclopedia.sendChangeNotification(entry)
    if entry then
        Player():sendChatMessage("Encyclopedia", ChatMessageType.Information, "New entry in Encyclopedia unlocked: %s"%_T, entry.title)
    end
end
callable(Encyclopedia, "sendChangeNotification")

end
