package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/?.lua"
include ("stringutility")
include ("contents")

Categories = Categories or {}
category = {}

table.insert(Categories, category)

category.title = "Trade"%_t
category.chapters =
{
    {
        title = "Trading"%_t,
        pictures =
        {
            "data/textures/ui/encyclopedia/trade/docking/dock_1.jpg",
            "data/textures/ui/encyclopedia/trade/docking/dock_2.jpg",
            "data/textures/ui/encyclopedia/trade/docking/dock_3.jpg",
            "data/textures/ui/encyclopedia/trade/docking/dock_4.jpg",
            "data/textures/ui/encyclopedia/trade/docking/dock_5.jpg",
            "data/textures/ui/encyclopedia/trade/docking/dock_6.jpg",
            "data/textures/ui/encyclopedia/trade/docking/dock_6.jpg",
        },
        fps = 2,
        text = "Stations trade with a variety of \\c(0d0)Trading Goods\\c(). Buy and sell them for a fine profit, or liberate them from other sources. Beware though: Stealing goods is seen as offensive and might lead to massive reputation loss!\n\n\\c(ddd)Note: a \\c(0d0)Trading System\\c() can list all tradeable goods and their price margins in the last visited sectors.\\c()"%_t,
    },
    {   
        title = "Goods"%_t,
        articles =
        {
            {
                title = "Trade goods"%_t,
                picture = "data/textures/ui/encyclopedia/trade/cargoTab_small.jpg",
                text = "All goods on your ship are shown in the \\c(0d0)Cargo Tab\\c() of the Ship Menu. There you'll find a drop-down menu where you can set your ship to either pick up or not pick up stolen goods.\n\nSmuggling and scavenging is a big problem, so military ships always scan for dangerous and illegal goods. When they catch someone, they fine them and confiscate the cargo."%_t,
            },
            {
                title = "Normal goods"%_t,
                picture = "data/textures/ui/encyclopedia/trade/goods_small.jpg",
                text = "These trade goods are freely available to everyone. They are not subject to any further restrictions."%_t,
            },
            {
                title = "Special goods"%_t,
                picture = "data/textures/ui/encyclopedia/trade/cargo_license_small.jpg",
                text = "To transport \\c(0d0)special goods\\c(), the corresponding \\c(0d0)license\\c() of the respective faction is required. With a license, special goods can be traded as if they were normal goods. When someone is caught without a license, they will be fined and their cargo confiscated."%_t,
            },
            {
                title = "Stolen goods"%_t,
                picture = "data/textures/ui/encyclopedia/trade/stolenGoods_small.jpg",
                text = "Goods are automatically branded to the faction that buys them by all certified traders found on stations. So, goods obtained by destroying or robbing ships are \\c(0d0)branded as 'stolen'\\c(). No honorable station will accept goods that are branded as 'stolen'.\n\nA special \\c(0d0)license\\c() is required to transport stolen goods. When someone is caught without a license, they will be fined and their cargo confiscated.\n\nSmugglers are said to have means of unbranding stolen cargo, but these are not exactly legal."%_t,
            },
        },
    },
}

contents.trading = category.chapters[1]
contents.goods = category.chapters[2]
