package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/?.lua"
include ("stringutility")
include ("contents")

Categories = Categories or {}
category = {}

table.insert(Categories, category)

category.title = "Resource Management"%_t
category.chapters =
{
    {
        title = "Mining"%_t,
        pictures =
        {
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_1.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_2.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_3.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_4.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_5.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_6.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_7.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_8.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_9.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/mining/mine_9.jpg",
        },
        fps = 2,
        text = "To mine asteroids, special \\c(0d0)Mining Lasers\\c() are necessary. Two types of mining lasers are commonly known: \\c(0d0)Refining\\c() and \\c(0d0)Raw\\c() (short: \\c(0d0)R\\c()). Refining lasers extract and immediately refine ores. R-Mining lasers can't refine ores, which means the ship will need a cargo bay to collect the ores. But R-Mining lasers usually have a much higher efficiency, making them the best choice for larger mining vessels.\nOres can be \\c(0d0)refined\\c() at a \\c(0d0)Resource Depot\\c() (for a small fee)."%_t,
    },
    {
        title = "Salvaging"%_t,
        pictures =
        {
            "data/textures/ui/encyclopedia/resourceManagment/salvaging/salvaging_1_small.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/salvaging/salvaging_2_small.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/salvaging/salvaging_3_small.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/salvaging/salvaging_4_small.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/salvaging/salvaging_5_small.jpg",
            "data/textures/ui/encyclopedia/resourceManagment/salvaging/salvaging_1_small.jpg",
        },
        fps = 2,
        text = "Special \\c(0d0)Salvaging Lasers\\c() allow to extract materials and equipment from wreckages. Depending on the type of laser they'll yield refined materials (\\c(0d0)Refining Lasers\\c()) or scrap metals (\\c(0d0)R-Salvaging Lasers\\c()). Refining lasers are very good for smaller ships without cargo bays, but tend to have lower efficiency than comparable R-Salvaging Lasers.\nTo pick up and transport \\c(0d0)scrap metal\\c(), a ship needs to have a \\c(0d0)cargo bay\\c(). Scrap metals can be \\c(0d0)refined\\c() at a \\c(0d0)Resource Depot\\c() (for a small fee)."%_t,
    },
    {
        title = "Materials"%_t,
        picture = "data/textures/ui/encyclopedia/resourceManagment/materials/materials_UI_small.jpg",
        text = "Now that Avorion has been discovered, there are seven known materials. These seven materials can be used to build and repair ships. Collect them by \\c(0d0)Mining\\c(), \\c(0d0)Salvaging\\c() or buy them at a \\c(0d0)Resource Depot\\c()."%_t,
        articles =
        {
            {
                title = "Iron"%_t,
                picture = "data/textures/ui/encyclopedia/resourceManagment/materials/iron.jpg",
                text = "\\c(0d0)Iron\\c() is the simplest material. It's heavy but very easy to form, so blocks made from Iron don't cost a lot of money, but ships made from Iron are rather weak and heavy and thus won't steer very well.\nOnly basic necessities can be built from Iron, but Iron is the only known material that can be used for building \\c(0d0)Inertia Dampeners\\c().\nIron can be found in large quantities at the edge of the galaxy.\n\nCheck out the block tooltips in Building Mode for more information about the specific blocks!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_iron_found") then return true end

                    local res = {Player():getResources()}

                    if res[MaterialType.Iron+1] > 0 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "iron_found")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Titanium"%_t,
                picture = "data/textures/ui/encyclopedia/resourceManagment/materials/titanium.jpg",
                text = "\\c(0d0)Titanium\\c() is a very light material and more durable than Iron. It has better energy properties than Iron, making it possible to build \\c(0d0)Energy Generators\\c(), \\c(0d0)Batteries\\c() and \\c(0d0)Integrity Field Generators\\c().\nIn the outer regions of the galaxy, Titanium is the preferred material to build ships.\nTitanium can be found nearly anywhere in the galaxy, even in the outermost rim of the galaxy.\n\nCheck out the block tooltips in Building Mode for more information about the specific blocks!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_titanium_found") then return true end

                    local res = {Player():getResources()}

                    if res[MaterialType.Titanium+1] > 0 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "titanium_found")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Naonite"%_t,
                picture = "data/textures/ui/encyclopedia/resourceManagment/materials/naonite.jpg",
                text = "\\c(0d0)Naonite\\c() is a little heavier than Titanium, but it is even more durable. With Naonite you gain access to \\c(0d0)Shield Generators\\c() and \\c(0d0)Hyperspace Cores\\c(). Unfortunately Naonite armor tends to break easily and is no longer available for purchase.\nNaonite starts to appear at a distance of about 350 sectors to the galaxy core, and closer.\n\nCheck out the block tooltips in Building Mode for more information about the specific blocks!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_naonite_found") then return true end

                    local res = {Player():getResources()}

                    if res[MaterialType.Naonite+1] > 0 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "naonite_found")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Trinium"%_t,
                picture = "data/textures/ui/encyclopedia/resourceManagment/materials/trinium.jpg",
                text = "\\c(0d0)Trinium\\c() has the perfect combination of lightness and durability. Ships built from Trinium tend to be very nimble and \\c(0d0)Hangar Blocks\\c() allow the usage of fighters. Pair the Hangar with an \\c(0d0)Assembly Block\\c() to produce fighters on the ship. To increase ship processing power, and with that the ability to install more upgrades, \\c(0d0)Computer Cores\\c() can be added. And last, but not least, Trinium allows to build an \\c(0d0)Academy\\c() to train your crew members.\nTrinium can be found at about half way between the galaxy’s edge and its core.\n\nCheck out the block tooltips in Building Mode for more information about the specific blocks!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_trinium_found") then return true end

                    local res = {Player():getResources()}

                    if res[MaterialType.Trinium+1] > 0 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "trinium_found")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Xanion"%_t,
                picture = "data/textures/ui/encyclopedia/resourceManagment/materials/xanion.jpg",
                text = "\\c(0d0)Xanion\\c() is the last material that is still known to the civilizations around the Barrier. It's quite a bit more durable than Trinium but has more weight to it. It lacks Armor Blocks, but has very good technical properties and lets you build \\c(0d0)Transporter Blocks\\c() that increase a ship's docking range. The M.A.D. association recently invented \\c(0d0)Cloning Pods\\c(). Research is still ongoing, but the M.A.D. association has successfully shown that cloned crew members are indistinguishable from natural ones.\nXanion can be found around the Barrier to the galaxy core.\n\nCheck out the block tooltips in Building Mode for more information about the specific blocks!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_xanion_found") then return true end

                    local res = {Player():getResources()}

                    if res[MaterialType.Xanion+1] > 0 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "xanion_found")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Ogonite"%_t,
                picture = "data/textures/ui/encyclopedia/resourceManagment/materials/ogonite.jpg",
                text = "\\c(0d0)Ogonite\\c() is very heavy, but at the same time very durable! While many of the technical blocks aren't available in Ogonite, it shines in the \\c(0d0)Armor\\c() department. Ships built from Ogonite will be heavy and not at all nimble, but shrug off most attacks with ease.\nOgonite can be found beyond the Barrier, not far into the center.\n\nCheck out the block tooltips in Building Mode for more information about the specific blocks!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_ogonite_found") then return true end

                    local res = {Player():getResources()}

                    if res[MaterialType.Ogonite+1] > 0 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "ogonite_found")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Avorion"%_t,
                picture = "data/textures/ui/encyclopedia/resourceManagment/materials/avorion.jpg",
                text = "\\c(0d0)Avorion\\c() is a light material with very good energy characteristics, and the material preferred by the Xsotan for building their ships. \\c(0d0)Hyperspace Cores\\c() built from Avorion even let you traverse the Great Barrier!\nAvorion can be found in the very center of the galaxy.\n\nCheck out the block tooltips in Building Mode for more information about the specific blocks!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_avorion_found") then return true end

                    local res = {Player():getResources()}

                    if res[MaterialType.Avorion+1] > 0 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "avorion_found")
                        return true
                    end

                    return false
                end
            },
        },
    },
}

contents.mining = category.chapters[1]
contents.salvaging = category.chapters[2]
contents.materials = category.chapters[3]
