package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/?.lua"
include ("stringutility")
include ("contents")

Categories = Categories or {}
category = {}

table.insert(Categories, category)

category.title = "Fleet Management"%_t
category.chapters =
{
    {
        title = "Orders"%_t,
        pictures =
        {
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_1_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_2_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_2_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_3_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_3_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_4_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_4_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_5_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_5_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_6_small.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/orders/orders_6_small.jpg",
        },
        fps = 2,
        text = "If your ship has a \\c(0d0)Captain\\c(), you can order it to perform various tasks for you. For example you can tell it to \\c(0d0)harvest materials\\c(), \\c(0d0)trade goods\\c() or \\c(0d0)escort you\\c(). See the next chapter for more advanced orders."%_t,
    },
    {
        title = "Commanding a Fleet"%_t,
        picture = "data/textures/ui/encyclopedia/fleetManagment/mapCommands_small.jpg",
        text = string.format("You don't have to stay in the same sector as the ships following your orders, they'll perform their orders without you there.\nOne way of giving orders is to switch to the sector and give each ship the orders individually. You can also give orders to a group of ships in the \\c(0d0)Strategic View\\c() (\\c(fff)${strat}\\c()).\n\nIf you want your ship to perform a series of orders stretched over multiple sectors, command them via the \\c(0d0)Galaxy Map\\c(). Press \\c(fff)${shift}\\c() while issuing orders to enchain them. With the loop-command, you can have ships jump back to the first order after they completed all previous commands."%_t % {strat=GameInput():getKeyName(ControlAction.ToggleStrategyMode), shift=GameInput():getKeyName(ControlAction.ReleaseMouse)}),
    },
    {
        title = "Founding Stations"%_t,
        pictures =
        {
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found1.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found1.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found2.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found2.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found3_red.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found3_red.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found4.jpg",
            "data/textures/ui/encyclopedia/fleetManagment/foundStation/found4.jpg",
        },
        fps = 2,
        text = "When buying a ship at a \\c(0d0)Shipyard\\c() you can choose to order a \\c(0d0)Station Founder\\c(). With the necessary funds, it can be transformed into a station. Once transformed, the ship won't be able to move, so this process should only be undertaken after reaching the destination. Stations buy and sell trading goods and will make profit over time."%_t,
    },
    {
        title = "Production Chains"%_t,
        picture = "data/textures/ui/encyclopedia/fleetManagment/cargoShuttle_small.jpg",
        text = "In order to produce goods, most stations need resources. These have to be bought from other stations or traders.\n\nYou can also provide goods to your stations by building a production line consisting of multiple stations. Transport goods between them with \\c(0d0)Cargo Shuttles\\c()! Place Cargo Shuttles in a factory's \\c(0d0)Hangar\\c() and configure them in the factory menu to fetch or bring goods to another station in the sector."%_t,
    },
}

contents.outOfSector = category.chapters[1]
contents.Orders = category.chapters[2]
contents.foundingStations = category.chapters[3]
contents.productionChains = category.chapters[4]
