package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/?.lua"
include ("stringutility")
include ("contents")

Categories = Categories or {}
category = {}

table.insert(Categories, category)

category.title = "Exploring"%_t
category.chapters =
{
    {   
        title = "Galaxy Map"%_t,
        articles =
        {
            {
                title = "Map Markers"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/map/map_blips.jpg",
                text = "The galaxy map has several types of markers: \\c(0d0)Colonized sectors\\c() are shown with a green blip, while sectors with \\c(0d0)Hidden Mass\\c() are marked with a yellow blip. Hidden mass sectors can contain good things, like huge asteroid fields, but also pirates. Be careful when venturing into the unknown!\n\\c(0d0)Visited sectors\\c() are marked with dots. Green dots represent allies, purple ones neutral objects, red ones hostile forces.\n\n\\c(ddd)Note: to see the yellow markers it's necessary to install a \\c(0d0)Radar Upgrade\\c(ddd) with deep scan function.\\c()"%_t,

            },
            {
                title = "Indicators"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/map/indicators.jpg",
                text = "Your \\c(0d0)current sector\\c() is marked with a blinking green frame and the \\c(0d0)selected sector\\c() with a white frame. A non-blinking green frame indicates a \\c(0d0)sector containing crafts\\c() that belong to you. The white dots on the side show how many crafts you have there.\nAlliance ships are marked in the same way, but with a pink frame.\n\nThe blue outline is your hyperspace jump range. Building \\c(0d0)Hyperspace Core Blocks\\c() or using a \\c(0d0)Hyperspace Upgrade\\c() improves your range."%_t,

            },
            {
                title = "Sector Menu"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/map/context_small.jpg",
                text = "The \\c(0d0)Sector Context Menu\\c() is opened when right-clicking on a sector. Here you can have your \\c(0d0)Hyperspace Jump Route\\c() calculated, \\c(0d0)post\\c() the sector to chat and \\c(0d0)tag\\c() it. Once a sector is tagged, you can also add \\c(0d0)notes\\c() for you and your alliance."%_t,

            },
        },
    }, 
    {
        title = "Zones"%_t,
        articles =
        {
            {
                title = "Neutral Zone"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/zones/neutral_zone.jpg",
                text = "The \\c(0d0)Neutral Zone\\c() is a safe zone. Player-vs-player damage is disabled. You cannot damage other players, not even by collision damage, but you can use repair turrets or repair fighters to heal them."%_t,

            },
            {
                title = "Hazard Zone"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/zones/hazard_zone.jpg",
                text = "If someone causes too much trouble and destroys or boards structures of other factions, the faction controlling the sector will call the sector out as a \\c(0d0)Hazard Zone\\c(). Civilian ships, traders and freighters will avoid this sector for a certain amount of time. Instead, military ships will appear and restore peace."%_t,

            },
        },
    },

    {
        title = "Stations"%_t,
        articles =
        {
            {
                title = "Shipyard"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/Shipyard.jpg",
                text = "If you are in need of a new ship go to a \\c(0d0)Shipyard\\c(). They can build you a ship from scrap and have a lot of customization options. For example you can let them add cargo blocks and a full crew to have a ready to go miner.\n\nShipyards are also the perfect place to go if you're in need of a Crew or need some repairs done."%_t,

            },
            {
               title = "Repair Dock"%_t,
               picture = "data/textures/ui/encyclopedia/exploring/stations/RepairDock.jpg",
               text = "Have a dent in your ship? Go to a \\c(0d0)Repair Dock\\c() and have it fixed right away!\n\\c(0d0)Repair Docks\\c() also sell \\c(0d0)Reconstruction Tokens\\c(). These handy items allow you to fully reconstruct your ship in case it is destroyed."%_t,

            },
            {
                title = "Equipment Dock"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/EquipmentDock.jpg",
                text = "\\c(0d0)Equipment Docks\\c() trade all kinds of equipment: \\c(0d0)Turrets\\c(), \\c(0d0)Torpedoes\\c(), \\c(0d0)Fighters\\c() and more. You can sell unused equipment here as well."%_t,
            },
            {
                title = "Resource Depot"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/ResourceDepot.jpg",
                text = "Material trade is done at a \\c(0d0)Resource Depot\\c(). You can \\c(0d0)buy and sell\\c() resources for Credits, and \\c(0d0)refine\\c() metal scraps and ores into usable materials."%_t,

            },
            {
                title = "Headquarters"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/Headquarters.jpg",
                text = "The \\c(0d0)Headquarters\\c() is a unique station for every faction. If you need to contact the whole faction, you should talk to their Headquarters."%_t,
            },
            {
                title = "Research Station"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/Research.jpg",
                text = "At the \\c(0d0)Research Station\\c() you can combine items into a better, random new one. The better the items, the better the resulting item will be."%_t,
            },
            {
                title = "Fighter Factory"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/FighterFactory.jpg",
                text = "At a \\c(0d0)Fighter Factory\\c(), you can design and build your own \\c(0d0)custom Fighters\\c(). You can combine a block design with 200 blocks or less with a turret of your choice to get a new fighter."%_t,
            },
            {
              title = "Turret Factory"%_t,
              picture = "data/textures/ui/encyclopedia/exploring/stations/TurretFactory.jpg",
              text = "Found the perfect turret, but got only one of them? You can go to a \\c(0d0)Turret Factory\\c() and break it down to a blueprint. Once you got the blueprint, you can build more of the turret out of trading goods.\n\nTurret Factories will also have a variety of blueprints already available. The higher the tech level of a Turret Factory the better the turrets it can build."%_t,
            },
            {
                title = "Trading Post"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/TradingPost.jpg",
                text = "\\c(0d0)Trading Posts\\c() buy and sell a wide variety of goods, and are always worth checking out. They sell \\c(0d0)Trading Licenses\\c() too if you want to transport special or illegal goods.\n\nIf you're looking to build your own turrets have a look here as well. Some Trading Posts specialize in trading goods that can be used as ingredients."%_t,
            },
            {
                title = "Scrapyard"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/Scrapyard.jpg",
                text = "At \\c(0d0)Scrapyards\\c(), you can sell off old ships and \\c(0d0)dismantle turrets\\c() to get resources. Additionally, Scrapyards sell licenses allowing you to \\c(0d0)salvage wreckages\\c() to get turrets, upgrades and material scraps."%_t,

            },
            {
                title = "Smuggler's Market"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/SmugglersMarket.jpg",
                text = "If you ever find yourself in the possession of \\c(0d0)Stolen Goods\\c() you can sell or have them \\c(0d0)unbranded\\c() here. Unbranded goods can then be traded with any station. Nobody will ask questions at a \\c(0d0)smuggler's market\\c()."%_t,
            },
            {
                title = "Military Outpost"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/MilitaryOutpost.jpg",
                text = "A \\c(0d0)Military Outpost\\c() represents the military force of a faction. Their personnel is well trained, so if you want the best \\c(0d0)Gunners\\c() and high-ranking \\c(0d0)Officers\\c(), this is where you look."%_t,
            },
            {
                title = "Factories"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/Factory.jpg",
                text = "\\c(0d0)Factories\\c() produce a variety of trading goods out of lower tier goods. They sell what they produce and they buy the goods they need."%_t,
            },
            {
                title = "Consumers"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/stations/Casino.jpg",
                text = "\\c(0d0)Consumer stations\\c() buy all kinds of goods people need to live. \\c(0d0)Casinos\\c(), \\c(0d0)Habitats\\c() and \\c(0d0)Biotopes\\c() tend to buy different kinds of food, beverages and luxury items."%_t,
            },
        },
    },
    {
        title = "Bulletin Board"%_t,
        picture = "data/textures/ui/encyclopedia/exploring/bulletinBoard.jpg",
        text = "Each station is equipped with a standardized \\c(0d0)Bulletin Board\\c(). If a station is marked with a \\c(0d0)green exclamation mark\\c(), it has a job offer."%_t,

    },
    {
        title = "Characters"%_t,
        articles =
        {
            {
                title = "Pirates"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/pirate1.jpg",
                text = "When civilization took to space, everyone was excited for this opportunity to start new lives. But it wasn't long before problems arose - the economy favored the rich, while the poor became poorer and poorer. Inter-faction disputes and weak governments that weren't able to protect their citizen's rights didn't help the issue.\nSome people decided to take matters into their own hands. The number of pirates has steadily increased since the Event 200 years back, with a drastic increase in raids as well. Many empty sectors are now overrun with pirates that kill anyone who dares to come onto their turf. Neighboring Factions are suffering constant \\c(0d0)pirate attacks\\c() and will pay handsome \\c(0d0)rewards\\c() for anyone willing to help."%_t,
            },
            {
                title = "Headhunters"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/headHunter.jpg",
                text = "The recent rise in crime has led to a sharp decrease in the factions' patience to deal with enemies. It's more and more common to see Factions enlist \\c(0d0)Headhunters\\c() to hunt down unwanted ships. Headhunters are heavily armed and often bring a \\c(0d0)Hyperspace Blocker\\c() to stop ships from escaping into hyperspace."%_t,
            },
            {
                title = "Persecutors"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/persecutors.jpg",
                text = "Beware on your travels to the center of the galaxy. More and more travellers report sightings of marauding ships. These scoundrels attack any \\c(0d0)weak ship\\c() that makes the mistake of coming into their sight. Because they aren't easy to give up, and even follow their prey through hyperspace, they've been aptly named \\c(0d0)'Persecutors'\\c()."%_t,
            },
            {
                title = "Xsotan"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/xsotan1.jpg",
                text = "Ever since the Event ships of unknown origin roam the galaxy. If no weapons are fired they remain peaceful, but one shot is enough to turn them hostile. Many great scientists are puzzled by their unique traits. Research is still ongoing."%_t,
            },
            {
                title = "Adventurer"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/adventurer.jpg",
                text = "The \\c(0d0)Adventurer\\c() is a lonesome fellow trying to get to the center of the galaxy. He's positive that there's a way through the \\c(0d0)Barrier\\c()!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_adventurer_met") then return true end

                    local adventurer = Sector():getEntitiesByScript("adventurer1.lua")
                    if adventurer then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "adventurer_met")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Swoks"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/swoks_fight.jpg",
                text = "\\c(0d0)Swoks III\\c() is the third offspring of a pirate dynasty. After his older brothers were defeated, he became the pirate king!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_swoks_met") then return true end

                    local swoks = Sector():getEntitiesByScript("swoks.lua")
                    if swoks then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "swoks_met")
                        return true
                    end

                    return false
                end
            },

            {
                title = "Mobile Energy Lab"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/mobileLab.jpg",
                text = "The \\c(0d0)M.A.D. Science Association\\c() researches \\c(0d0)Xsotan\\c() energy technology. They own multiple satellites all over the galaxy that give off weird vibes."%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_MAD_met") then return true end

                    local scientist = Sector():getEntitiesByScript("scientist.lua")
                    if scientist then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "MAD_met")
                        return true
                    end

                    return false
                end
            },
            {
                title = "The AI"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/ai.jpg",
                text = "Apparently, the \\c(0d0)AI\\c() was once programmed to fend off the Xsotan. Legends say that the manufacturer promised it would never attack non-Xsotan!"%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_AI_met") then return true end

                    local ai = Sector():getEntitiesByScript("aidialog.lua")
                    if ai then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "AI_met")
                        return true
                    end

                    return false
                end
            },
            {
                title = "Bottan"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/smuggler.jpg",
                text = "\\c(0d0)Bottan\\c() is an infamous smuggler, known to screw over friend and foe."%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_bottan_met") then return true end

                    local smuggler = Sector():getEntitiesByScript("smuggler.lua")
                    if smuggler then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "bottan_met")
                        return true
                    end

                    return false
                end
            },
            {
                title = "The Four"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/theFour_posing.jpg",
                text = "The \\c(0d0)Four\\c() are a group of ruthless scientists, trying to be the first over the Barrier. They'll try everything to get their hands on any of the exceedingly rare \\c(0d0)Xsotan Artifacts\\c()."%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_the4_met") then return true end

                    local the4 = Sector():getEntitiesByScript("the4.lua")
                    if the4 then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "the4_met")
                        return true
                    end

                    return false
                end
            },
            {
                title = "The Wormhole Guardian"%_t,
                picture = "data/textures/ui/encyclopedia/exploring/characters/wormhole_guardian.jpg",
                text = "This strange \\c(0d0)Xsotan\\c() ship seems to be guarding the center of the galaxy. It's a Xsotan mothership that can utilize the black hole's energy to open \\c(0d0)Wormholes\\c() to call more and more Xsotan reinforcements."%_t,

                isUnlocked = function()
                    if Player():getValue("encyclopedia_wormhole_met") then return true end

                    local wormholeguardian = Sector():getEntitiesByScript("wormholeguardian.lua")
                    if wormholeguardian then
                        -- RemoteInvocations_Ignore
                        invokeServerFunction("setValue", "wormhole_met")
                        return true
                    end

                    return false
                end
            },
        },
    },
}

contents.galaxyMap = category.chapters[1]
contents.stations = category.chapters[2]
contents.bulletinBoard = category.chapters[3]
contents.characters = category.chapters[4]
