package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/?.lua"
include ("stringutility")
include ("contents")

Categories = Categories or {}
category = {}

table.insert(Categories, category)

category.title = "Craft Management"%_t
category.chapters =
{
    {
        title = "Crew"%_t,
        picture = "data/textures/ui/encyclopedia/craftManagment/crewTab.jpg",
        text = "A \\c(0d0)crew\\c() is what keeps a ship together. Most of the work on a ship can be done by untrained crew members. But past experiences showed that untrained personnel should never be given higher-ranking positions. Trained higher-ranking officers and other professionals can be \\c(0d0)hired at stations\\c(). Professionals take a high salary, but studies have shown that professional crew members can increase productivity by up to 200 %.\nThe crew has to be \\c(0d0)paid every three hours\\c(). How much each crew member earns is listed in the Ship Menu's crew tab.\nFrom Trinium and higher materials \\c(0d0)Academy Blocks\\c() are available. Building an Academy Block will unlock training. With training former untrained crew members become professionals. With Xanion and higher materials \\c(0d0)Cloning Pods\\c() can be built. After building Cloning Pods, untrained crew members can be cloned for a small fee."%_t,
    },
    {
        title = "Reconstruction Tokens"%_t,
        picture = "data/textures/ui/encyclopedia/craftManagment/recon_arrow.jpg",
        text = "\\c(0d0)Repair Docks\\c() sell \\c(0d0)Reconstruction Tokens\\c(). These tokens contain all information necessary to restore a ship in case it gets destroyed. The \\c(0d0)reconstruction\\c() with a token is free, but the token will be consumed. When you buy a new token, Repair Docks offer the additional service to repair your ship before programming the token.\nReconstruction without a token takes a lot more expertise, and Repair Docks will ask higher prices for it."%_t,
    },
    {
        title = "Upgrades"%_t,
        articles =
        {
            {
                title = "General Function"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgradeTab.jpg",
                text = "\\c(0d0)Upgrades\\c() can improve certain aspects of a ship. This allows the specialization of ships for certain jobs.\n\n\\c(0d0)Permanently installed\\c() upgrades usually give huge bonuses, but can only be removed close to an \\c(0d0)Equipment Dock\\c().\n\n\\c(ddd)Note: Some upgrades HAVE to be installed permanently to work.\\c()"%_t,
            },
            {
                title = "Turret Control Systems"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/tcs.jpg",
                text = "Each \\c(0d0)Turret Control System\\c() increases the amount of available \\c(0d0)turret slots\\c(). Depending on the type of the upgrade, it increases the number of slots for military, civil or both turret types."%_t,
            },
            {
                title = "Battery Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/battery.jpg",
                text = "The \\c(0d0)Battery Upgrade\\c() contains algorithms to allow better management of recharging, meaning batteries have a \\c(0d0)higher capacity\\c() and \\c(0d0)lower recharge\\c() time with it installed."%_t,
            },
            {
                title = "Cargo Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/cargoupgrade.jpg",
                text = "\\c(0d0)Cargo Upgrades\\c() increase \\c(0d0)cargo capacity\\c() without the need to add more Cargo Blocks. Organization is the key!"%_t,
            },
            {
                title = "Generator Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/generator.jpg",
                text = "Increasing the generated \\c(0d0)energy output\\c() and battery \\c(0d0)recharge rate\\c() can be achieved with a \\c(0d0)Generator Upgrade\\c()."%_t,
            },
            {
                title = "Engine Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/engine.jpg",
                text = "The \\c(0d0)Engine Upgrade\\c() improves overall velocity and engine thrust. More \\c(0d0)engine power\\c() without the hassle of adding more Engine Blocks to the ship."%_t,
            },
            {
                title = "Hyperspace Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/hyperspace.jpg",
                text = "The \\c(0d0)Hyperspace Upgrade\\c() improves the hyperspace \\c(0d0)jump range\\c() of a ship and decreases the necessary \\c(0d0)recharge energy\\c(). If installed permanently it can additionally shorten the recharge time."%_t,
            },
            {
                title = "Radar Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/radar.jpg",
                text = "\\c(0d0)Radar Upgrades\\c() improve \\c(0d0)radar range\\c() and can add to the \\c(0d0)deep scan range\\c() too. With a deep scanner, hidden mass sectors will be highlighted on the Galaxy Map."%_t,
            },
            {
                title = "Shield Booster"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/shieldbooster.jpg",
                text = "A \\c(0d0)Shield Booster\\c() improves \\c(0d0)shield durability\\c() and \\c(0d0)recharge rate\\c()."%_t,
            },
            {
                title = "Tractor Beam Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/tractor.jpg",
                text = "A \\c(0d0)Tractor Beam Upgrade\\c() will increase the \\c(0d0)loot range\\c() of a ship. They are very handy when collecting free-floating loot."%_t,
            },
            {
                title = "Scanner Upgrade"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/scanner.jpg",
                text = "The \\c(0d0)Scanner Upgrade\\c() allows you to detect contents of a ship's or station's cargo from longer distances. They're widely used by sector security to scan for illegal or dangerous goods."%_t,
            },
            {
                title = "Mining System"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/miningupgrade.jpg",
                text = "The \\c(0d0)Mining Upgrade\\c() marks resource rich \\c(0d0)asteroids\\c() containing the specified material or lower materials, even if the materials are hidden inside. It adds small marker arrows to the HUD so that finding asteroids with materials is easier."%_t,
            },
            {
                title = "Trading System"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/trading.jpg",
                text = "A \\c(0d0)Trading Upgrade\\c() will ease trade and commerce a lot. Depending on the quality of the upgrade, it can show all trading possibilities with \\c(0d0)prices\\c() and \\c(0d0)price margins\\c() in the last visited sectors. It will even detect trade routes over the last few visited sectors.\nAll ships working trade routes should be equipped with one of these."%_t,
            },
            {
                title = "Object Detector"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/objectdetector.jpg",
                text = "The \\c(0d0)Object Detector\\c() detects and marks all objects worth checking out in the current sector."%_t,
            },
            {
                title = "Shield Reinforcer"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/shieldreinforcer.jpg",
                text = "With a \\c(0d0)Shield Reinforcer\\c() shields won't be \\c(0d0)penetrated by torpedoes and shots\\c(). Disadvantages of upgrades like this include a weaker shield overall and a longer recharge time.\n\n\\c(ddd)Note: This upgrade has to be installed permanently to function.\\c()"%_t,
            },
            {
                title = "Energy to Shield Converter"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/energytoshield.jpg",
                text = "The \\c(0d0)Energy Converter\\c() reroutes part of the ship's energy into the shield. This means less energy for ship systems but a much \\c(0d0)higher shield durability\\c()."%_t,
            },
            {
                title = "Transporter Software"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/transporter.jpg",
                text = "A \\c(0d0)Transporter Block\\c() only works with the corresponding \\c(0d0)Transporter Software Upgrade\\c(). The software increases the \\c(0d0)docking range\\c() and allows fighters to pick up cargo for a ship."%_t,
            },
            {
                title = "Velocity SCB"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/velocitybypass.jpg",
                text = "The \\c(0d0)Velocity Security Control Bypass\\c() allows you to ignore a ship's \\c(0d0)maximum speed\\c() limitations.\n\\c(ddd)Please note: Braking without friction takes a while. The Intergalactic Security Agency advises against the use of VSCB upgrades.\\c()"%_t,
            },
            {
                title = "Internal Defense System"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/defense_system.jpg",
                text = "If somebody has the audacity to try and board one of your ships, install an \\c(0d0)Internal Defense System\\c(). It constructs specialized weapons that help your crew defend against enemy boarders. And the best thing? If \\c(0d0)Internal Defense Weapons\\c() are overpowered by enemy boarders, they are not destroyed, only disabled until the next attack!"%_t,
            },
            {
                title = "Hull Polarizer"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/hull_polarizer.jpg",
                text = "There are several versions of the \\c(0d0)Shield Ionizer\\c(). Each one of them greatly increases hull strength. But be careful: As a side effect, the hull takes more damage from a certain damage type. You can only install one at a time."%_t,
            },
            {
                title = "Shield Ionizer"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/upgrades/shield_ionizer.jpg",
                text = "There are several versions of the \\c(0d0)Shield Ionizer\\c(). Each one of them greatly reduces the amount of damage taken from a certain damage type. You can only install one at a time."%_t,
            },


        },
    },
    {
        title = "Armed Turrets"%_t,
        picture = "data/textures/ui/encyclopedia/craftManagment/inventoryTab.jpg",
        text = "There are many different weapon types with different features. Some weapons do more damage to shields, others do more damage to hull. Others can even bypass shields entirely or damage more than one block at a time.\nSome turrets have the \\c(0d0)Independent Targeting\\c() trait, allowing them to function independently from the player's controls. These turrets can be set to attack a target, always attack, defend or to be controlled by the player. The tooltip shows all traits of a turret.\n\nAll turrets can be categorized into one of three categories: \\c(0d0)Overheating\\c(), \\c(0d0)Energy Using\\c() or \\c(0d0)Special\\c()."%_t,

        articles =
        {
            {
                title = "Overheating Turrets"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/overheatingWeapons.jpg",
                text = "\\c(0d0)Overheating turrets\\c() build up heat while shooting and regularly need to cool down. Once overheated, they won't be able to fire until they have cooled down for a while.\n\nWeapons in this categorie include \\c(0d0)Railguns\\c(), \\c(0d0)Rocket Launchers\\c(), \\c(0d0)Bolters\\c() and \\c(0d0)Cannons\\c()."%_t,
            },
            {
                title = "Energy Turrets"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/energyWeapons.jpg",
                text = "\\c(0d0)Energy-Using Turrets\\c() have batteries that first need to be charged with your ship's energy. Once this battery is depleted, the turret will stop shooting until its battery has been recharged.\n\nWeapons of this category inlcude \\c(0d0)Lasers\\c(), \\c(0d0)Tesla\\c() and \\c(0d0)Lightning Guns\\c() and \\c(0d0)Plasma Turrets\\c()."%_t,
            },
            {
                title = "Special Turrets"%_t,
                picture = "data/textures/ui/encyclopedia/craftManagment/defenseWeapons_red.jpg",
                text = "Some turrets don't fit into one of the above categories.\n\n\\c(0d0)Point Defense Weapons\\c(): Those weapons can always fire and need no ammunition. Point Defense Weapons are very good against enemy fighters and torpedoes. Set them to 'Defensive' to have them automatically target torpedoes, fighters and nearby enemies.\n\nUtility Turrets: Those include \\c(0d0)Healing\\c() and \\c(0d0)Force turrets\\c(), which can heal other ships or push or pull them around."%_t,
            },
        }
    },
    {
        title = "Fighters"%_t,
        picture = "data/textures/ui/encyclopedia/craftManagment/fighterTab.jpg",
        text = "Having a \\c(0d0)Hangar\\c() enables a ship to use fighters. \\c(0d0)Fighters\\c() can be bought at \\c(0d0)Equipment Docks\\c(), or be created at a \\c(0d0)Fighter Factory\\c(). With an \\c(0d0)Assembly Block\\c(), copies of a fighter can be produced on the ship. To create a producible blueprint, a fighter has to be placed in the blueprint slot. It'll be disassembled and the ship will use this blueprint to create new fighters for money and resources.\n\nFighters are organized in \\c(0d0)Squads\\c(). Buttons on the left side of the screen allow to set a command for each squad. Depending on the type of fighter, they can attack or defend the ship, be used for mining or salvaging or shuttle crew or cargo between crafts."%_t,
    },
    {
        title = "Torpedoes"%_t,
        picture = "data/textures/ui/encyclopedia/craftManagment/torpedoTab.jpg",
        text = "\\c(0d0)Torpedoes\\c() are special weapons with \\c(0d0)very high range\\c(). The various types can be distinguished by the color of the warhead. Each kind of torpedo has its advantages and disadvantages. Some are extremely good against shields, others are better against the hull and some damage both.\n\nTorpedoes can be deadly. To defend yourself against them, build \\c(0d0)Point Defense Weapons\\c() that automatically shoot them down before impact."%_t,
    },
}

contents.crew = category.chapters[1]
contents.reconToken = category.chapters[2]
contents.upgrades = category.chapters[3]
contents.armedTurrets = category.chapters[4]
contents.fighter = category.chapters[5]
contents.torpedos = category.chapters[6]
