package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/lib/?.lua"
package.path = package.path .. ";data/scripts/encyclopedia/?.lua"
include ("stringutility")
include ("contents")

Categories = Categories or {}
category = {}

table.insert(Categories, category)

category.title = "Building"%_t
category.chapters =
{
    {
        title = "Founding a Ship"%_t,
        pictures =
        {
            "data/textures/ui/encyclopedia/building/foundingship/screen10.jpg",
            "data/textures/ui/encyclopedia/building/foundingship/screen10_red.jpg",
            "data/textures/ui/encyclopedia/building/foundingship/screen11_red.jpg",
            "data/textures/ui/encyclopedia/building/foundingship/screen12.jpg",
            "data/textures/ui/encyclopedia/building/foundingship/screen13_red.jpg",
            "data/textures/ui/encyclopedia/building/foundingship/screen14.jpg",
            "data/textures/ui/encyclopedia/building/foundingship/screen14.jpg",
        },
        fps = 1,
        text = "Click on the flag icon (\\c(0d0)\"Found Ship\"\\c()) in the upper right corner to found a ship. Founding a ship this way will create a \\c(0d0)base block\\c() and add a \\c(0d0)base crew\\c(). Use this base block to build your ship."%_t,
    },
    {
        title = "Building Mode"%_t,
        articles =
        {
            {
                title = "Controls"%_t,
                pictures =
                {
                    "data/textures/ui/encyclopedia/building/controls/01.jpg",
                    "data/textures/ui/encyclopedia/building/controls/02.jpg",
                    "data/textures/ui/encyclopedia/building/controls/03.jpg",
                    "data/textures/ui/encyclopedia/building/controls/04.jpg",
                    "data/textures/ui/encyclopedia/building/controls/05.jpg",
                    "data/textures/ui/encyclopedia/building/controls/06.jpg",
                    "data/textures/ui/encyclopedia/building/controls/07.jpg",
                    "data/textures/ui/encyclopedia/building/controls/08.jpg",
                    "data/textures/ui/encyclopedia/building/controls/09.jpg",
                    "data/textures/ui/encyclopedia/building/controls/10.jpg",
                    "data/textures/ui/encyclopedia/building/controls/11.jpg",
                    "data/textures/ui/encyclopedia/building/controls/12.jpg",
                    "data/textures/ui/encyclopedia/building/controls/13.jpg",
                    "data/textures/ui/encyclopedia/building/controls/14.jpg",
                    "data/textures/ui/encyclopedia/building/controls/14.jpg",
                    "data/textures/ui/encyclopedia/building/controls/14.jpg",
                },
                fps = 2,
                text = string.format("Open \\c(0d0)Building Mode\\c() by pressing \\c(fff)${openBuild}\\c() or use the hammer icon in the top right corner. Once in Building Mode, move the camera by pressing \\c(fff)${movCam}\\c() and moving the mouse.\nIf you want to see all available \\c(0d0)blocks\\c(), hold \\c(fff)${inventory}\\c(). All blocks can be \\c(0d0)scaled\\c() in any direction by holding \\c(fff)${W}\\c(), \\c(fff)${A}\\c(), \\c(fff)${S}\\c(), \\c(fff)${D}\\c() and moving the mouse.\nIf you don't know how to do something, press \\c(fff)${short}\\c() to get an overview of all \\c(0d0)building shortcuts\\c()!"%_t % {openBuild=GameInput():getKeyName(ControlAction.BuildingMode), movCam=GameInput():getKeyName(ControlAction.MoveCamera), inventory=GameInput():getKeyName(ControlAction.ShowInventory), W =GameInput():getKeyName(ControlAction.ScaleBlockLinear), A=GameInput():getKeyName(ControlAction.ScaleBlockX), S=GameInput():getKeyName(ControlAction.ScaleBlockY), D=GameInput():getKeyName(ControlAction.ScaleBlockZ), short=GameInput():getKeyName(ControlAction.ShowServerInfo)}),
            },
            {

                title = "Saving Ships"%_t,
                pictures =
                {
                    "data/textures/ui/encyclopedia/building/savedDesigns/building-mode.jpg",
                    "data/textures/ui/encyclopedia/building/savedDesigns/designs-button-highlight.jpg",
                    "data/textures/ui/encyclopedia/building/savedDesigns/saved-design.jpg",
                    "data/textures/ui/encyclopedia/building/savedDesigns/saved-design.jpg",
                },
                text = "By default your ship design will automatically be saved if you leave \\c(0d0)Building Mode\\c(). You can find these auto saves in the \\c(0d0)Saved Designs\\c() menu on the left side.\nYou can also save your ship design manually. All saved designs will be available as designs throughout the game."%_t,
            },
        },
    },
    {
        title = "Workshop"%_t,
        pictures =
        {
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop_red.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop_red.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop_red.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/designs-button-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/designs-button-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop-folder-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop-folder-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop-ship-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop-ship-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop-ship-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop-ship-highlight.jpg",
            "data/textures/ui/encyclopedia/building/savedDesigns/workshop_red.jpg",
        },
        fps = 2,
        text = "Avorion has \\c(0d0)Steam Workshop\\c() integration. \\c(0d0)Subscribe\\c() to an item and find it in your \\c(0d0)Saved Designs\\c().\nDownloadable content includes ship, station, fighter and turret designs."%_t,
    },
}

contents.foundShip = category.chapters[1]
contents.buildingMode = category.chapters[2]
contents.workshop = category.chapters[3]
