
package.path = package.path .. ";data/scripts/lib/?.lua"
local Xsotan = include("story/xsotan")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace SpawnGuardian
SpawnGuardian = {}

if onServer() then

function SpawnGuardian.initialize()
    Player():registerCallback("onSectorEntered", "onSectorEntered")
end

function SpawnGuardian.onSectorEntered(player, x, y, changeType)
    if not (x == 0 and y == 0) then return end
    if changeType ~= SectorChangeType.Jump then return end

    local respawnTime = Server():getValue("guardian_respawn_time")
    if respawnTime then return end
    local xsotanSwarmTime = Server():getValue("xsotan_swarm_time")
    if xsotanSwarmTime then return end
    local xsotanSwarmDuration = Server():getValue("xsotan_swarm_duration")
    if xsotanSwarmDuration then return end

    -- only spawn him once
    local sector = Sector()
    if Sector():getEntitiesByScript("data/scripts/entity/story/wormholeguardian.lua") then return end

    -- clear everything that's not player owned
    local entities = {sector:getEntities()}
    for _, entity in pairs(entities) do
        if not entity.allianceOwned and not entity.playerOwned then
            sector:deleteEntity(entity)
        end
    end

    Xsotan.createGuardian()
end

end
