package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("utility")
include("stringutility")
include("callable")
include("structuredmission")
MissionUT = include("missionutility")

-- mission.tracing = true

mission.data.brief = "Trading Instructions"%_T
mission.data.title = "Trading Instructions"%_T
mission.data.icon = "data/textures/icons/graduate-cap.png"
mission.data.priority = 5
mission.data.description =
{
    "The Adventurer wants to teach you about trading. He has sent you an email about that."%_T,
    {text = "Add 250 or more cargo space to your ship"%_T, bulletPoint = true, fulfilled = false}
}


mission.phases[1] = {}
mission.phases[1].onBeginServer = function()
    local player = Player()
    local mail = Mail()
    mail.text = Format("Hi there,\n\nIf you want to make money, you should learn how to trade. To make a profit, it's important to buy goods cheaply and sell them for a lot more money. Let's try to buy something from a trading post and sell it somewhere else.\n\nGreetings,\n%1%"%_T, getAdventurerName())
    mail.header = "Trading Instructions /* Mail Subject */"%_T
    mail.sender = Format("${name}, the Adventurer"%_T % {name = getAdventurerName()})
    player:addMail(mail)
end

mission.phases[1].updateServer = function()
    -- See if player has enough cargo space
    local player = Player()
    local craft = player.craft
    if not craft then return end

    if craft.freeCargoSpace and craft.freeCargoSpace > 250 then
        mission.data.description[2].fulfilled = true
        mission.data.description[3] = {text = "Buy goods from a trader"%_T, bulletPoint = true, fulfilled = false}
        nextPhase()
    end
end
mission.phases[1].showUpdateOnEnd = true

mission.phases[2] = {}
mission.phases[2].onBegin = function()
    local player = Player()
    player:registerCallback("onTradingmanagerSellToPlayer", "onTradingmanagerSellToPlayer")
end
mission.phases[2].updateServer = function(timestep)
    if mission.data.goodsBought then
        mission.data.description[3].fulfilled = true
        mission.data.description[4] = {text = "Sell goods to another station"%_T, bulletPoint = true, fulfilled = false}
        nextPhase()
    end
end
mission.phases[2].showUpdateOnEnd = true

mission.phases[3] = {}
mission.phases[3].onBegin = function()
    local player = Player()
    player:registerCallback("onTradingmanagerBuyFromPlayer", "onTradingmanagerBuyFromPlayer")
end
mission.phases[3].updateServer = function(timestep)
    if mission.data.goodsSold then
        sendReward()
        accomplish()
    end
end

function onTradingmanagerSellToPlayer()
    print("onTradingmanagerSellToPlayer")
    mission.data.goodsBought = true
end

function onTradingmanagerBuyFromPlayer()
    print("onTradingmanagerBuyFromPlayer")
    mission.data.goodsSold = true
end

function sendReward()
    local player = Player()
    local mail = Mail()
    mail.header = "Trading Instructions: Well done! /* Mail Subject */"%_T
    mail.text = Format("Hi there,\n\nCongratulations, you've taken your first steps towards becoming a trader! If you keep finding great trading opportunities, you can become very rich. I hope you'll remember me once that day comes!\n\nGreetings,\n%s"%_T, getAdventurerName())
    mail.sender = Format("%s, the Adventurer"%_T, getAdventurerName())
    mail.money = 10000

    player:addMail(mail)
    player:setValue("tutorial_trading_accomplished", true) -- set this here, so that player can't repeat mission after receiving reward
end

function getAdventurerName()
    local player = Player()
    local faction = Galaxy():getNearestFaction(player:getHomeSectorCoordinates())
    local language = faction:getLanguage()
    language.seed = Server().seed
    return language:getName()
end

function onAbandon()
    Player():setValue("tutorial_trading_accomplished", true) -- player doesn't want to be bugged again
end
