package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include ("utility")
include ("stringutility")
include ("callable")
include ("galaxy")
include ("faction")
include("randomext")
include ("structuredmission")

MissionUT = include ("missionutility")
local ShipUtility = include ("shiputility")
local AdventurerGuide = include ("story/adventurerguide")
local SectorGenerator = include ("SectorGenerator")
local TorpedoGenerator = include ("torpedogenerator")
local AsyncPirateGenerator = include("asyncpirategenerator")

-- mission.tracing = true

-- mission data
mission.data.brief = "Torpedo Tests"%_T
mission.data.title = "Torpedo Tests"%_T
mission.data.icon = "data/textures/icons/graduate-cap.png"
mission.data.priority = 5
mission.data.description = {}
-- custom data
mission.data.custom = {}
mission.data.custom.interacted = false
mission.data.custom.adventurerId = nil
mission.data.custom.startMailRead = false
mission.data.custom.pirateSetAggressive = false
mission.data.custom.torpedoAssigned = false
mission.data.custom.torpedoLaunched = false
mission.data.custom.torpedoesLaunched = 0
mission.data.custom.pirateId = nil
mission.data.custom.wreckage = nil
mission.data.custom.torpedoHit = false
mission.data.custom.targetCoords = {}

-- mission phases
mission.globalPhase = {}
mission.globalPhase.onTargetLocationEntered = function()

    createAdventurer()

    if mission.phases[3].triggers[1].triggered then
        mission.phases[3].triggers[1].triggered = nil
    elseif mission.currentPhase == mission.phases[4] then
        buildTorpedoStorageDialog()
    elseif mission.currentPhase == mission.phases[5] or mission.currentPhase == mission.phases[6] or mission.currentPhase == mission.phases[7] then
        equipTorpedoDialog()
    end
end
mission.globalPhase.onAbandon = function()
    local entity = Sector():getEntitiesByScript("data/scripts/entity/story/missionadventurer.lua")
    if entity then Sector():deleteEntityJumped(entity) end
end

mission.phases[1] = {}
mission.phases[1].onBeginServer = function()

    mission.data.description[1] = Format("Learn how to use torpedoes. A complete guide by your friend ${name}, the Adventurer."%_T % {name = getAdventurerName()})
    mission.data.description[2] = {text = "Read the instruction mail"%_T, bulletPoint = true, fulfilled = false}

    local player = Player()
    player:registerCallback("onMailRead", "onMailRead")

    local mail = createStartMail()
    player:addMail(mail)
end
mission.phases[1].onRestore = function()
    Player():registerCallback("onMailRead", "onMailRead")
end

mission.phases[2] = {}
mission.phases[2].onTargetLocationEntered = function()
    createAdventurer()
    createWreckage()
    nextPhase()
end
mission.phases[2].noBossEncountersTargetSector = true
mission.phases[2].noPlayerEventsTargetSector = true

mission.phases[3] = {}
mission.phases[3].triggers = {}
mission.phases[3].triggers[1] =
{
    condition = function() return checkAdventurerCreated() end,
    callback = function () return onStartFirstDialog() end,
}
mission.phases[3].showUpdateOnEnd = true
mission.phases[3].noBossEncountersTargetSector = true
mission.phases[3].noPlayerEventsTargetSector = true


mission.phases[4] = {}
mission.phases[4].onBeginServer = function()
    mission.data.description[3].fulfilled = true
    mission.data.description[4] = {text = "Build a Torpedo Storage of at least size 9"%_T, bulletPoint = true, fulfilled = false}
end
mission.phases[4].onBeginClient = function()
    buildTorpedoStorageDialog()
end
mission.phases[4].updateServer = function()
    if checkTorpedoStorage() then
        mission.data.description[4].fulfilled = true
        nextPhase()
    end
end
mission.phases[4].showUpdateOnEnd = true
mission.phases[4].noBossEncountersTargetSector = true
mission.phases[4].noPlayerEventsTargetSector = true


mission.phases[5] = {}
mission.phases[5].onBeginServer = function()
    mission.data.description[3].fulfilled = true
    givePlayerTorpedo()
    nextPhase()
end
mission.phases[5].onBeginClient = function()
    equipTorpedoDialog()
end
mission.phases[5].showUpdateOnEnd = true
mission.phases[5].noBossEncountersTargetSector = true
mission.phases[5].noPlayerEventsTargetSector = true


mission.phases[6] = {}
mission.phases[6].onBeginServer = function()
    mission.data.description[5] = {text = "Equip the torpedo into a torpedo shaft and bind the shaft to a keyboard shortcut to activate it"%_T, bulletPoint = true, fulfilled = false}
    mission.data.description[6] = {text = "Shoot the wreckage with the torpedo"%_T, bulletPoint = true, fulfilled = false}
    nextPhase()
end
mission.phases[6].onBeginClient = function()
    -- this highlights the wreckage as interesting object and draws a little arrow
    Player():registerCallback("onPreRenderHud", "onPreRenderHud")
end
mission.phases[6].noBossEncountersTargetSector = true
mission.phases[6].noPlayerEventsTargetSector = true


mission.phases[7] = {}
mission.phases[7].onBeginServer = function()
    local entity = Entity(mission.data.custom.wreckage)
    if entity then
        entity:registerCallback("onTorpedoHit", "onTorpedoHit")
    end
    local craft = Player().craft
    if not craft then return end
    craft:registerCallback("onTorpedoLaunched", "onWreckageTorpedoLaunched")
end
mission.phases[7].updateServer = function()
    if mission.data.custom.pirateSetAggressive then
        mission.data.description[7] = {text = "Use the torpedo to destroy the pirate"%_T, bulletPoint = true, fulfilled = false}
        nextPhase()
    end
end
mission.phases[7].timers = {}
mission.phases[7].timers[1] = {callback = function() onSpawnPirate() end}
mission.phases[7].timers[2] = {callback = function() onMissedWreckage() end}
mission.phases[7].onRestore = function()
    local entity = Entity(mission.data.custom.wreckage)
    if entity then
        entity:registerCallback("onTorpedoHit", "onTorpedoHit")
    end

    local craft = Player().craft
    if not craft then return end

    craft:registerCallback("onTorpedoLaunched", "onWreckageTorpedoLaunched")
end
mission.phases[7].onTargetLocationEntered = function()
    local entity = Entity(mission.data.custom.wreckage)
    if entity then
        entity:registerCallback("onTorpedoHit", "onTorpedoHit")
    end

    local craft = Player().craft
    if not craft then return end

    craft:registerCallback("onTorpedoLaunched", "onWreckageTorpedoLaunched")
end
mission.phases[7].showUpdateOnEnd = true
mission.phases[7].noBossEncountersTargetSector = true
mission.phases[7].noPlayerEventsTargetSector = true


mission.phases[8] = {}
mission.phases[8].onBeginServer = function()
    local craft = Player().craft
    if not craft then return end

    craft:registerCallback("onTorpedoLaunched", "onPirateTorpedoLaunched")
end
mission.phases[8].updateServer = function()
    if mission.data.custom.torpedoLaunched then
        local torps = Sector():getEntitiesByType(EntityType.Torpedo)
        if not torps then
            nextPhase()
        end
    end
end
mission.phases[8].onRestore = function()
    local craft = Player().craft
    if not craft then return end
    craft:registerCallback("onTorpedoLaunched", "onPirateTorpedoLaunched")
end
mission.phases[8].onTargetLocationEntered = function()
    local craft = Player().craft
    if not craft then return end
    craft:registerCallback("onTorpedoLaunched", "onPirateTorpedoLaunched")
end
mission.phases[8].noBossEncountersTargetSector = true
mission.phases[8].noPlayerEventsTargetSector = true


mission.phases[9] = {}
mission.phases[9].onBeginServer = function()
    Player():sendChatMessage(Entity(mission.data.custom.pirateId), ChatMessageType.Chatter, "Dammit, torpedoes again, that's not worth it. I'm out of here."%_T)
    if mission.data.custom.pirateId then
        ShipAI(mission.data.custom.pirateId):setPassive()
    end

    mission.phases[9].timers[1].time = 5
end
mission.phases[9].timers = {}
mission.phases[9].timers[1] = {callback = function() onPirateJump() end}
mission.phases[9].noBossEncountersTargetSector = true
mission.phases[9].noPlayerEventsTargetSector = true


mission.phases[10] = {}
mission.phases[10].onBeginClient = function()
    local dialog = {}
    dialog.text = "Phew! This pirate had special anti-torpedo weapons. Good for us that he wasn't in the mood for a fight!\n\nLet me give you my spare torpedoes. I've got three with different warheads here. Warheads change the effect of the torpedo, while bodies change speed and maneuverability.\n\nHere, take them, I'd rather do research than fight. They'll be of more use to you."%_t
    dialog.onEnd = "onFinalDialogEnd"

    local entity = Entity(mission.data.custom.adventurerId)
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end
mission.phases[10].timers = {}
mission.phases[10].timers[1] = {callback = function() showAdventurerChatter() end}


-- helper functions
function getAdventurerName()
    local player = Player()
    local faction = Galaxy():getNearestFaction(player:getHomeSectorCoordinates())
    local language = faction:getLanguage()
    language.seed = Server().seed
    return language:getName()
end

function onMailRead(playerIndex, mailIndex)
    -- define mission location here, so that sector is only marked after player read the mail
    mission.data.location = mission.data.custom.targetCoords

    local player = Player()
    local mail = player:getMail(mailIndex)
    if mail.id == "Tutorial_Torpedoes" then
        mission.data.description[2].fulfilled = true
        mission.data.description[3] = {text = "Meet the Adventurer in (${xCoord}:${yCoord})"%_T, arguments = {xCoord = mission.data.location.x, yCoord = mission.data.location.y}, bulletPoint = true, fulfilled = false}
        player:unregisterCallback("onMailRead", "onMailRead")
        mission.data.custom.startMailRead = true
        nextPhase()
    end
end

function findEmptySector()
    local target = {}
    local x, y = Sector():getCoordinates()
    target.x, target.y = MissionUT.getSector(x, y, 2, 5, false, false, false, false)

    if not target.x or not target.y then return end
    return target
end

function createStartMail()
    local mail = Mail()
    mission.data.custom.targetCoords = findEmptySector()
    mail.text = Format("Hi there,\n\nI see you found the torpedo launchers. Torpedoes are fantastic weapons with great range that can possibly deal a lot of damage.\n\nMeet me in sector (%1%:%2%) and I'll show you how to get the hang of it. After learning how to use them, you can have some of my old ones.\n\nGreetings,\n%3%"%_T, mission.data.custom.targetCoords.x, mission.data.custom.targetCoords.y, getAdventurerName())
    mail.header = "Torpedo Instructions /* Mail Subject */"%_T
    mail.sender = Format("%s, the Adventurer"%_T % {name = getAdventurerName()})
    mail.id = "Tutorial_Torpedoes"
    return mail
end

function createAdventurer()
    if onClient() then return end

    local adventShip = AdventurerGuide.spawnMissionAdventurer(Player())
    if not adventShip then
        adventShip = Sector():getEntitiesByScript("data/scripts/entity/story/missionadventurer.lua")
    end
    adventShip.invincible = true
    MissionUT.deleteOnPlayersLeft(adventShip)
    mission.data.custom.adventurerId = adventShip.id.string
    adventShip:invokeFunction("story/missionadventurer.lua", "setInteractingScript", "player/missions/tutorials/torpedoestutorial.lua")
--    sync()
end

function createWreckage()
    if mission.data.custom.wreckage then return end -- make sure there's no duplicates
    local generator = SectorGenerator(mission.data.location.x, mission.data.location.y)
    local faction = Galaxy():getNearestFaction(mission.data.location.x, mission.data.location.y)
    local wreckage = generator:createWreckage(faction, nil, 0) -- breaks = 0, so that there's only one object created
    mission.data.custom.wreckage = wreckage.id.string
end

function checkAdventurerCreated()
    if onServer() then return false end

    return Entity(mission.data.custom.adventurerId) ~= nil
end

function onStartFirstDialog()
    local dialog = {}
    dialog.text = "Hi there, thank you for coming! I'll explain to you how to use torpedoes.\nI've brought this wreckage for target practice."%_t
    dialog.answers = {{answer = "Okay, let's do it."%_t}}
    dialog.onEnd = "onEndFirstDialog"

    local entity = Entity(mission.data.custom.adventurerId)
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, true, dialog)
end

function onEndFirstDialog()
    if onClient() then
        invokeServerFunction("onEndFirstDialog")
        return
    end

    -- check torpedo Storage
    if checkTorpedoStorage() then
        setPhase(5)
    else
        if mission.currentPhase == mission.phases[3] then nextPhase() end
    end
end
callable(nil, "onEndFirstDialog")

function buildTorpedoStorageDialog()
    local dialog = {}
    dialog.text = "Let's start with building a Torpedo Storage that is big enough for our test torpedoes. The overall storage size should be at least 9. Remember that Torpedo Storage needs a certain minimum size for a torpedo to fit in."%_t
    dialog.answers = {{answer = "Okay."%_t}}

    local entity = Entity(mission.data.custom.adventurerId)
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end

function equipTorpedoDialog()
    local dialog = {}
    dialog.text = "Here is your first test torpedo. To equip it, you first have to load the torpedo into a Torpedo Shaft. You can then set it as active in the ship overview.\n\nI suggest you just go ahead and try to shoot the wreckage as soon as you've done that."%_t
    dialog.answers = {{answer = "Okay."%_t}}

    local entity = Sector():getEntitiesByScript("story/missionadventurer.lua")
    if not entity then return end
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)

end

function onPreRenderHud()
    local player = Player()
    if not player then return end
    if player.state == PlayerStateType.BuildCraft or player.state == PlayerStateType.BuildTurret then return end

    local renderer = UIRenderer()
    local entity = Entity(mission.data.custom.wreckage)
    if not entity then return end

    renderer:renderEntityTargeter(entity, ColorRGB(1, 1, 1));
    renderer:renderEntityArrow(entity, 30, 10, 250, ColorRGB(1, 1, 1));

    renderer:display()
end

function checkTorpedoStorage()
    local player = Player()
    local craft = player.craft
    if not craft then return false end
    local plan = Plan(craft.id)
    if not plan then return false end

    local torpedoStorage = plan:getBlocksByType(BlockType.TorpedoStorage)
    if not torpedoStorage then
        return false
    end

    local stats = plan:getStats()
    if not stats then return false end
    if stats.torpedoSpace < 8 then
        return false
    end

    return true
end

function givePlayerTorpedo()
    if onClient() then invokeServerFunction("givePlayerTorpedo") return end
    if playerHasTorpedo() then return end

    local player = Player()
    local craft = player.craft
    if not craft then return end

    local torpedoLauncher = TorpedoLauncher(craft.id)
    if not torpedoLauncher then player:sendChatMessage("The Adventurer"%_T, ChatMessageType.Information, "Your torpedo launcher has been destroyed."%_T) return end
    local x = mission.data.location.x
    local y = mission.data.location.y
    local torpedo = TorpedoGenerator():generate(x, y, 0, Rarity(RarityType.Uncommon), 1, 1)
    torpedoLauncher:addTorpedo(torpedo)
end
callable(nil, "givePlayerTorpedo")

function onTorpedoHit(objectIndex, shooterIndex, location)
    local wreckage = Entity(mission.data.custom.wreckage)
    if wreckage then wreckage:unregisterCallback("onTorpedoHit", "onTorpedoHit") end

    local craft = Player().craft
    if not craft then return end

    craft:unregisterCallback("onTorpedoLaunched", "onWreckageTorpedoLaunched")
    mission.data.custom.torpedoHit = true
    createPirate()
    mission.phases[7].timers[1].time = 5
    mission.data.custom.torpedoesLaunched = 0
end

function onWreckageTorpedoLaunched()
    mission.data.description[5].fulfilled = true

    if onClient() then return end -- don't run this on Client, we want timer to be server only

    -- player only gets one torpedo at a time from adventurer
    mission.data.custom.torpedoesLaunched = mission.data.custom.torpedoesLaunched + 1
    if mission.data.custom.torpedoesLaunched > 1 then return end

    -- reset timer
    mission.phases[7].timers[2].passed = 0
    mission.phases[7].timers[2].stopped = false
    mission.phases[7].timers[2].time = 15
end

function onMissedWreckage()
    if onServer() then
        mission.data.custom.torpedoesLaunched = 0
        if mission.data.custom.torpedoHit then return end -- if we hit the wreckage, but it still called this function we have to return
        invokeClientFunction(Player(), "onMissedWreckage")
    return end

    local dialog = {}
    dialog.text = "Ah, dang it. Here, have another one and try again!"%_t
    dialog.answers = {{answer = "Thanks, I will!"%_t}}
    dialog.onEnd = "onEndMissedWreckageDialog"

    local entity = Entity(mission.data.custom.adventurerId)
    if not entity then return end
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end

function onEndMissedWreckageDialog()
    if not playerHasTorpedo() then givePlayerTorpedo() end
end

function playerHasTorpedo()
    local player = Player()
    local craft = player.craft
    if not craft then return end
    local torpedoLauncher = TorpedoLauncher(craft.id)
    if not torpedoLauncher then return false end
    return (torpedoLauncher.numTorpedoes > 0)
end

function createPirate()
    local dir = normalize(vec3(getFloat(-1, 1), getFloat(-1, 1), getFloat(-1, 1)))
    local up = vec3(0, 1, 0)
    local pos = dir * 1000

    local generator = AsyncPirateGenerator(nil, onPirateCreated)

    generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos))
end

function onPirateCreated(pirate)
    mission.data.custom.pirateId = pirate.id.string
    ShipAI(pirate.id):setPassive()
    pirate.invincible = true
    ShipUtility.addCIWSEquipment(pirate)
end

function onSpawnPirate()
    if onServer() then invokeClientFunction(Player(), "onSpawnPirate") return end

    local dialog = {}
    dialog.text = "Uh oh, there's a pirate! Here, take this torpedo and shoot him down!"%_t
    dialog.onEnd = "onSpawnPirateEnd"

    local entity = Entity(mission.data.custom.adventurerId)
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end

function onSpawnPirateEnd()
    if onClient() then invokeServerFunction("onSpawnPirateEnd") return end

    if not playerHasTorpedo() then givePlayerTorpedo() end
    if not mission.data.custom.pirateId or not ShipAI(mission.data.custom.pirateId) then return end

    ShipAI(mission.data.custom.pirateId):setAggressive()
    mission.data.custom.pirateSetAggressive = true
end
callable(nil, "onSpawnPirateEnd")

function onPirateTorpedoLaunched(entityId, torpedoId)
    mission.data.custom.torpedoLaunched = true
end

function onPirateJump()
    Sector():deleteEntityJumped(Entity(mission.data.custom.pirateId))
    nextPhase()
end

function onFinalDialogEnd()

    if onClient() then
        givePlayerReward()
        invokeServerFunction("onFinalDialogEnd")
        return
    end

    Player():setValue("tutorial_torpedoes_accomplished", true) -- we set this here, so that players can't farm this mission
    mission.phases[10].timers[1].time = 3
end
callable(nil, "onFinalDialogEnd")

function givePlayerReward()
    if onClient() then invokeServerFunction("givePlayerReward") return end
    local player = Player()
    local craft = Player().craft
    if not craft then return end
    local torpedoLauncher = TorpedoLauncher(craft.id)
    local x = mission.data.location.x
    local y = mission.data.location.y

    local generator = TorpedoGenerator()
    local torpedo = generator:generate(x, y, 0, Rarity(RarityType.Uncommon), 1, 9)
    local torpedo2 = generator:generate(x, y, 0, Rarity(RarityType.Uncommon), 2, 5)
    local torpedo3 = generator:generate(x, y, 0, Rarity(RarityType.Uncommon), 4, 1)
    torpedoLauncher:addTorpedo(torpedo)
    torpedoLauncher:addTorpedo(torpedo2)
    torpedoLauncher:addTorpedo(torpedo3)
end
callable(nil, "givePlayerReward")

function showAdventurerChatter()
    Player():sendChatMessage(Entity(mission.data.custom.adventurerId), ChatMessageType.Chatter, "Nice, this one has potential. And another good deed done."%_T)
    Entity(mission.data.custom.adventurerId):addScript("data/scripts/entity/utility/delayeddelete.lua", random():getFloat(10, 20))
    accomplish()
end
