package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("stringutility")
include("callable")
include("structuredmission")

-- mission data
mission.data.brief = "Reach the Center"%_T
mission.data.title = "Reach the Center"%_T
mission.data.icon = "data/textures/icons/story-mission.png"
mission.data.priority = 10
mission.data.description = {}
mission.data.description[1] = "Ever since the Event, Xsotan have swarmed the galaxy. Nobody has been able to find out where exactly the Xsotan come from or what they are. According to reports, the center of the galaxy has the highest Xsotan activity."%_T
mission.data.description[2] = {text = "Reach the center of the galaxy and find out where the Xsotan come from"%_T, bulletPoint = true, fulfilled = false}

-- phases
mission.phases[1] = {}
mission.phases[1].onBeginServer = function()
    mission.data.location = {x = 0, y = 0}
    nextPhase()
end

mission.phases[2]  = {}
mission.phases[2].updateServer = function()
    local guardian = Sector():getEntitiesByScript("wormholeguardian.lua")
    if guardian then
        mission.data.custom.guardianId = guardian.id.string
        nextPhase()
    end
end
mission.phases[2].onTargetLocationEntered = function()
    mission.data.description[2].fulfilled = true
    mission.data.description[3] = {text = "Defeat the Wormhole Guardian"%_T, bulletPoint = true, fulfilled = false}
end
mission.phases[2].showUpdateOnEnd = true

mission.phases[3] = {}
mission.phases[3].onBeginServer = function()
   mission.phases[3].destructionChecks[1].id = mission.data.custom.guardianId
end
mission.phases[3].destructionChecks = {}
mission.phases[3].destructionChecks[1] =
    {
        callback = function(entity) onGuardianDestroyed() end
    }

function onGuardianDestroyed()
    Player():setValue("tutorial_reachcenter_accomplished", true)
    accomplish()
end


