package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"
package.path = package.path .. ";data/scripts/entity/?.lua"

include("utility")
include("stringutility")
include("callable")
include("structuredmission")
include("defaultscripts")
include("randomext")
MissionUT = include("missionutility")
local Adventurer = include("story/missionadventurer")
local AdventurerGuide = include("story/adventurerguide")
local ShipGenerator = include("shipgenerator")

-- mission.tracing = true

-- data
mission.data.title = "Fleet Commands"%_T
mission.data.brief = "Fleet Commands"%_T
mission.data.icon = "data/textures/icons/graduate-cap.png"
mission.data.priority = 5
mission.data.description = {}
mission.data.location = {}

-- custom data
mission.data.custom.adventurerId = nil
mission.data.custom.shipId = nil
mission.data.custom.usedStrategy = false
mission.data.custom.thirdDialogStarted = false
mission.data.custom.tmpCoords = {}

-- phases
mission.globalPhase = {}
mission.globalPhase.updateServer = function()
    if mission.data.custom.shipId then
        local player = Player()
        if player:getShipDestroyed(mission.data.custom.shipName) then
            player:removeDestroyedShipInfo(mission.data.custom.shipName)
            onLadyDestroyed()
        end
    end
end
mission.globalPhase.onTargetLocationEntered = function()
    if onServer() then return end
    if mission.data.description[2] then mission.data.description[2].fulfilled = true end

    -- only create adventurer in first sector
    if not mission.data.custom.tmpCoords then
        createAdventurer()
    end
end
mission.globalPhase.onSectorLeft = function()
    if mission.data.description[2] then mission.data.description[2].fulfilled = false end
end
mission.globalPhase.onAbandon = function()
    local entity = Sector():getEntitiesByScript("data/scripts/entity/story/missionadventurer.lua")
    if entity then Sector():deleteEntityJumped(entity) end
end

-- Phase 1: Player comes into sector => spawn Adventurer and set descriptions
mission.phases[1] = {}
mission.phases[1].onBegin = function()

    if onServer() then
        mission.data.description[1] = {text = "Learn how to command your own fleet. Your friend, ${name} the Adventurer, has some good tips for you!"%_T, arguments = {name = getAdventurerName()}}
        mission.data.location.x, mission.data.location.y = Sector():getCoordinates()
        mission.data.description[2] = {text = "Meet the Adventurer in sector (${xCoord}:${yCoord})"%_T, arguments = {xCoord = mission.data.location.x, yCoord = mission.data.location.y}, bulletPoint = true, fulfilled = true}

        createAdventurer()
    end

    nextPhase()
end
mission.phases[1].noBossEncountersTargetSector = true
mission.phases[1].noPlayerEventsTargetSector = true

-- Phase 2: Wait until Adventurer is finished spawning - start first dialog
mission.phases[2] = {}
mission.phases[2].triggers = {}
mission.phases[2].triggers[1] =
    {
        condition = function() return checkAdventurerCreated() end,
        callback = function () return startFirstDialog() end
    }

-- Phase 3: Create ship and set mission not repeatable (this is only reversed if ship is destroyed during runtime of mission)
mission.phases[3] = {}
mission.phases[3].onBeginServer = function()
    playerSetValue(true)
    createShip()
    nextPhase()
end
mission.phases[3].noBossEncountersTargetSector = true
mission.phases[3].noPlayerEventsTargetSector = true

-- Phase 4: Ask player to use Strategy Mode and check if he does
mission.phases[4] = {}
mission.phases[4].onBeginClient = function()
    startSecondDialog()
end
mission.phases[4].updateClient = function()
    if not mission.data.custom.usedStrategy and Player().state == PlayerStateType.Strategy then
        onStrategyModeOpened()
    end
end
mission.phases[4].noBossEncountersTargetSector = true
mission.phases[4].noPlayerEventsTargetSector = true

-- Phase 5: Check if ship came close enough => go to next phase
mission.phases[5] = {}
mission.phases[5].onBeginServer = function()
    mission.phases[5].distanceChecks[1].id = mission.data.custom.shipId
end
mission.phases[5].distanceChecks = {}
mission.phases[5].distanceChecks[1] =
    {
        distance = 200,
        onLower = function() onShipCloseEnough() end
    }
mission.phases[5].noBossEncountersTargetSector = true
mission.phases[5].noPlayerEventsTargetSector = true
mission.phases[5].onRestore = function()
   mission.phases[5].distanceChecks[1].id = mission.data.custom.shipId
end

-- Phase 6: Explain Map Commands and set new target location for Lady to jump to
--          Wait for Lady to reach target location
mission.phases[6] = {}
mission.phases[6].onBeginClient = function()
    startThirdDialog()
end
mission.phases[6].onBeginServer = function()
    mission.data.description[3].fulfilled = true
    mission.data.custom.tmpCoords.x = mission.data.location.x
    mission.data.custom.tmpCoords.y = mission.data.location.y
    mission.data.location.x, mission.data.location.y = getTargetLocation()
    if not mission.data.location then setPhase(6) return end -- in case we find no empty sector the phase should try again

    mission.data.description[4] = {text = "Use the galaxy map to have Lady Adventurous jump to (${xCoord}:${yCoord}) and return back"%_T, arguments = {xCoord = mission.data.location.x, yCoord = mission.data.location.y}, bulletPoint = true, fulfilled = false}
end
mission.phases[6].updateServer = function()
    local current = Player().craftIndex
    if tostring(mission.data.custom.shipId) ~= tostring(current) then
        -- player is not allowed to fly lady himself
        local shipPos = {}
        shipPos.x, shipPos.y = Player():getShipPosition(mission.data.custom.shipName)

        if  shipPos.x == mission.data.location.x and shipPos.y == mission.data.location.y then
            nextPhase()
        end
    end
end
mission.phases[6].noBossEncountersTargetSector = true
mission.phases[6].noPlayerEventsTargetSector = true

-- Phase 7: Check if Lady arrives back home, set target location back to sector mission started in
mission.phases[7] = {}
mission.phases[7].onBeginServer = function()
    mission.data.location.x = mission.data.custom.tmpCoords.x
    mission.data.location.y = mission.data.custom.tmpCoords.y
    mission.data.custom.tmpCoords = nil
    mission.data.description[4] = {text = "Use the galaxy map to have Lady Adventurous return back to (${xCoord}:${yCoord})"%_T, arguments = {xCoord = mission.data.location.x, yCoord = mission.data.location.y}, bulletPoint = true, fulfilled = false}
end
mission.phases[7].updateServer = function()
    local current = Player().craftIndex
    if tostring(mission.data.custom.shipId) ~= tostring(current) then
        -- player is not allowed to fly lady himself
        local shipPos = {}
        shipPos.x, shipPos.y = Player():getShipPosition(mission.data.custom.shipName)

        if shipPos.x == mission.data.location.x and shipPos.y == mission.data.location.y then
            nextPhase()
        end
    end
end
mission.phases[7].noBossEncountersTargetSector = true
mission.phases[7].noPlayerEventsTargetSector = true

-- Phase 8: Recheck that Adventurer is still here and finish up with a dialog (or a mail if player went elsewhere)
mission.phases[8] = {}
mission.phases[8].onBegin = function()
    if onClient() then
        local adventurerHere = checkAdventurerCreated()
        if adventurerHere then
            startLastDialog()
        else
            sendLastDialogMail()
            finishUp()
        end
    end
end
mission.phases[8].timers = {}
mission.phases[8].timers[1] = {callback = function() finishUp() end}
mission.phases[8].showUpdateOnBegin = true

-- helper phases for spawning Adventurer and waiting until he is finished spawning
mission.phases[9] = {}
mission.phases[9].onBeginServer = function()
    createAdventurer()
    nextPhase()
end

mission.phases[10] = {}
mission.phases[10].triggers = {}
mission.phases[10].triggers[1] =
{
    condition = function() return checkAdventurerCreated() end,
    callback = function () return onAdventurerCreated() end
}

-- helper functions
function getAdventurerName()
    if onClient() then invokeServerFunction("getAdventurerName") return end
    local player = Player()
    local faction = Galaxy():getNearestFaction(player:getHomeSectorCoordinates())
    local language = faction:getLanguage()
    language.seed = Server().seed
    return language:getName()
end
callable(nil, "getAdventurerName")

function getTargetLocation(x, y, radius)
    if onClient() then invokeServerFunction("getTargetLocation") return end
    local x, y = Sector():getCoordinates()
    local radiusMax = radius or 2
    local coords = {}
    coords.x, coords.y = MissionUT.getSector(x, y, 1, radiusMax, false, false, false, false)

    if (coords.y < y) then -- sector has to be at least at same y, so that it isn't hidden by map command icons
        -- try again, widen radius to increase chance we find one
        getTargetLocation(x, y, radiusMax + 1)
    end
    return coords.x, coords.y
end
callable(nil, "getTargetLocation")

function createAdventurer()
    if onClient() then invokeServerFunction("createAdventurer") return end

    local adventShip = AdventurerGuide.spawnMissionAdventurer(Player())
    if not adventShip then
        adventShip = Sector():getEntitiesByScript("data/scripts/entity/story/missionadventurer.lua")
    end
    adventShip.invincible = true
    MissionUT.bindToMission(adventShip)
    mission.data.custom.adventurerId = adventShip.id.string
    adventShip:invokeFunction("story/missionadventurer.lua", "setInteractingScript", "player/missions/tutorials/fleetcommandstutorial.lua")
    sync()
end
callable(nil, "createAdventurer")

function checkAdventurerCreated()
    if onServer() then invokeClientFunction(Player(), "checkAdventurerCreated") return end

    if not mission.data.custom.adventurerId then return false end
    return Entity(mission.data.custom.adventurerId) ~= nil
end

function startFirstDialog()

    if onServer() then
        invokeClientFunction(Player(), "startFirstDialog")
    return end

    local dialog = {}
    dialog.text = "Hi there!\n\nI see that you're starting to venture out! As soon as you start to do that, a second ship can come in very handy.\n\nIn order to command another ship, you need a captain on it.\n\nFor training purposes I'll lend you one of my ships that already has a captain. Please don't damage it!"%_t
    dialog.answers = {{answer = "Okay, let's do it."%_t}}
    dialog.onEnd = "onEndFirstDialog"

    local entity = Entity(mission.data.custom.adventurerId)
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, true, dialog)
end

function onEndFirstDialog()
    if onClient() then
        invokeServerFunction("onEndFirstDialog")
        return
    end

    setPhase(3)
    mission.data.description[3] = {text = "Use Strategy Mode to move Lady Adventurous closer to you"%_T, bulletPoint = true, fulfilled = false}
    sync()
end
callable(nil, "onEndFirstDialog")

function playerSetValue(value)
    if onClient() then invokeServerFunction("playerSetValue") return end
    Player():setValue("tutorial_fleetcommands_notRepeatable", value) -- at this point the player gets something, so he shouldn't be able to repeat the mission after abandoning
end
callable(nil, "playerSetValue")

function createShip()
    if onClient() then invokeServerFunction("createShip") return end
    if mission.data.custom.shipId and Player():ownsShip(mission.data.custom.shipId.name) then return end

    local faction = Player()
    local volume = Balancing_GetSectorShipVolume(faction:getHomeSectorCoordinates())/3

    local translation = random():getDirection() * 1000
    local position = MatrixLookUpPosition(-translation, vec3(0, 1, 0), translation)

    local ship = ShipGenerator.createShip(faction, position, volume)
    mission.data.custom.shipId = ship.id.string
    ship.title = "Lady Adventurous"%_T
    ship:addCrew(1, CrewMan(CrewProfessionType.Captain))
    ship:registerCallback("onBlockPlanChanged", "onBlockPlanChanged")

    ship.name = "Lady"%_T
    mission.data.custom.shipName = ship.name
end
callable(nil, "createShip")

function startSecondDialog()
    if onServer() then invokeClientFunction(Player(), "startSecondDialog") return end

    local dialog = {}
    dialog.text = string.format("There, now open Strategy Mode with [%s] and order Lady Adventurous to fly closer to you."%_t, tostring(GameInput():getKeyName(ControlAction.ToggleStrategyMode)))
    dialog.answers = {{answer = "Okay, I can do that."%_t}}

    local entity = Entity(mission.data.custom.adventurerId)
    if not entity then return end
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end

function onStrategyModeOpened()
    if onClient() then invokeServerFunction("onStrategyModeOpened") end

    mission.data.custom.usedStrategy = true
    nextPhase()
end
callable(nil, "onStrategyModeOpened")

function onShipCloseEnough()
    nextPhase()
end

function startThirdDialog()
    if mission.data.custom.thirdDialogStarted then return end
    if onServer() then
        mission.data.custom.thirdDialogStarted = true
        invokeClientFunction(Player(), "startThirdDialog")
    return end

    local dialog = {}
    dialog.text = "Now that you know how to give orders to ships in the same sector, let's try issuing orders to ships in other sectors!\n\nThe possibilities are endless, but for now just let Lady Adventurous jump to the marked sector and immediately return again.\n\nRemember, you can enchain commands by holding Shift.\n\nKeep in mind that other ships and stations delay the hyperspace recharge.\n\nIf they are hostile, they even may try to disturb your recharge, which will result in a longer recharge time."%_t
    dialog.answers = {{answer = "Okay."%_t}}

    local entity = Entity(mission.data.custom.adventurerId)
    if not entity then return end
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end

function startLastDialog()
    if onServer() then invokeClientFunction(Player(), "startLastDialog") return end

    local dialog = {}
    dialog.text = "Ah there's our Lady. Now you know how to command your fleet. You can keep Lady Adventurous and her crew.\n\nI hope she can show you just how useful a fleet can be in this vast galaxy!\n\nI'm off to look for a way to cross the Great Barrier! See you!"%_t
    dialog.answers = {{answer = "Thank you. Good luck!"%_t}}
    dialog.onEnd = "finishUp"

    local entity = Sector():getEntitiesByScript("story/missionadventurer.lua")
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end

function sendLastDialogMail()
    if onClient() then invokeServerFunction("sendLastDialogMail") return end
    local mail = Mail()
    mail.text = Format("Hi there,\n\nThe crew of Lady Adventurous told me that everything went just fine. Very well done!\n\nYou can keep Lady Adventurous and her crew. I hope she can show you just how useful a fleet can be in this vast galaxy!\n\nI'm off to look for a way to cross the Great Barrier!\n\nHope to see you soon!\n${name}"%_T % {name = getAdventurerName()})
    mail.header = "Fleet Commands: Nice job! /* Mail Subject */"%_T
    mail.sender = Format("${name}, the Adventurer"%_T % {name = getAdventurerName()})
    mail.id = "Tutorial_Fleetcommands"
    Player():addMail(mail)
end
callable(nil, "sendLastDialogMail")

function finishUp()
    if onClient() then invokeServerFunction("finishUp") return end

    local entity = Entity(mission.data.custom.adventurerId)
    if entity then
        Sector():deleteEntityJumped(entity)
    end
    Player():setValue("tutorial_fleetcommands_accomplished", true)
    accomplish()
end
callable(nil, "finishUp")

function onLadyDestroyed()
    if onServer() then
        local adventurerHere = Sector():getEntitiesByScript("story/missionadventurer.lua")
        if not adventurerHere then sendDestroyedMail() return end
        invokeClientFunction(Player(), "onLadyDestroyed")
    return end

    local dialog = {}
    dialog.text = string.format("Hey, I said don't damage my ship! A bit of damage, okay, but destroying it? Not with me. I'm out of here."%_t)
    dialog.answers = {{answer = "Oops."%_t}}
    dialog.onEnd = "onFinishedDestroyedDialog"

    local entity = Sector():getEntitiesByScript("story/missionadventurer.lua")
    if not entity then return end
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, false, dialog)
end

function onFinishedDestroyedDialog()
    if onClient() then
        invokeServerFunction("onFinishedDestroyedDialog")
        return
    end

    local entity = Entity(mission.data.custom.adventurerId)
    if entity then
        Sector():deleteEntityJumped(entity)
    end
    playerSetValue(false) -- now that lady is destroyed, player should get the chance to repeat the mission
    fail()
end
callable(nil, "onFinishedDestroyedDialog")

function sendDestroyedMail()
    if onClient() then invokeServerFunction("sendDestroyedMail") return end
    local mail = Mail()
    mail.text = Format("Hey, I said don't damage my ship! A bit of damage, okay, but destroying it? Not with me. I'm heading out.\n%s"%_T, getAdventurerName())
    mail.header = "???/* Mail Subject */"%_T
    mail.sender = Format("%s, the Adventurer"%_T, getAdventurerName())
    mail.id = "Tutorial_Fleetcommands_Destroyed"
    Player():addMail(mail)
    onFinishedDestroyedDialog() -- clean up
end
callable(nil, "sendDestroyedMail")
