package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include ("structuredmission")
include ("callable")

local AdventurerGuide = include ("story/adventurerguide")

-- mission.tracing = true

-- data
mission.data.brief = "Find Avorion"%_T
mission.data.title = "Find Avorion"%_T
mission.data.icon = "data/textures/icons/story-mission.png"
mission.data.priority = 10
mission.data.description = {}
mission.data.description[1] = "Ever since the 'Event' there are rumors about a new element. This new element is said to have way better energy properties and is perfect for building space ships. This new element 'Avorion' is only found on the inside of the Barrier."%_T
mission.data.description[2] = {text = "Find a sector with Avorion asteroids"%_T, bulletPoint = true, fulfilled = false}

-- custom
mission.data.custom.reSpawnCounter = 1

-- phases
mission.phases[1] = {}
mission.phases[1].onSectorEntered = function()
    if onServer() then checkAvorionFound() end
end
mission.phases[1].timers = {}
mission.phases[1].timers[1] = {callback = function() onFoundAvorion() end}

mission.phases[2] = {}
mission.phases[2].onBeginServer = function()
    createAdventurer()
    nextPhase()
end

mission.phases[3] = {}
mission.phases[3].triggers = {}
mission.phases[3].triggers[1] =
{
    condition = function() return checkAdventurerCreated() end,
    callback = function () return onStartDialog() end
}

mission.phases[4] = {}
mission.phases[4].onSectorLeft = function()
    -- player left instead of talking to adventurer
    setPhase(1)
end

mission.phases[5] = {}
mission.phases[5].onBeginServer = function()
    Player():setValue("tutorial_findavorion_accomplished", true)
    accomplish()
end


-- helper functions
function checkAvorionFound()
    if onClient() then invokeServerFunction("checkAvorionFound") return end

    local richAsteroids = {Sector():getEntitiesByComponent(ComponentType.MineableMaterial)}
    if not richAsteroids then return end
    if #richAsteroids < 5 then return end

    for _, roid in pairs(richAsteroids) do
        local resources = roid:getMineableResources()
        local material = roid:getMineableMaterial()
        if roid.isObviouslyMineable and resources~= nil and resources > 0 and material.value == MaterialType.Avorion then

            if mission.data.custom.reSpawnCounter == 1 then
                -- reset timer
                mission.phases[1].timers[1].passed = 0
                mission.phases[1].timers[1].stopped = false
                mission.phases[1].timers[1].time = 5
                mission.data.custom.reSpawnCounter = 5
            end
            mission.data.custom.reSpawnCounter = mission.data.custom.reSpawnCounter - 1
            return
        end
    end
end
callable(nil, "checkAvorionFound")

function onFoundAvorion()
    nextPhase()
end

function createAdventurer()
    if onClient() then return end

    local adventShip = AdventurerGuide.spawnMissionAdventurer(Player())
    if not adventShip then
        adventShip = Sector():getEntitiesByScript("data/scripts/entity/story/missionadventurer.lua")
    end
    adventShip.invincible = true
    MissionUT.deleteOnPlayersLeft(adventShip)
    mission.data.custom.adventurerId = adventShip.id.string
    adventShip:invokeFunction("story/missionadventurer.lua", "setInteractingScript", "player/missions/tutorials/findavoriontutorial.lua")
end

function checkAdventurerCreated()
    if onServer() then invokeClientFunction(Player(), "checkAdventurerCreated") end

    return Entity(mission.data.custom.adventurerId) ~= nil
end

function onStartDialog()
    if onServer() then
--        invokeClientFunction(Player(), "onStartDialog")
        return
    end

    local dialog = {}
    dialog.text = "Hey you found it, too! Avorion! We're going to get so rich!\n\nAvorion's characteristics are phenomenal. I think the Xsotan use it to jump over the Barrier instead of using the gate. People will pay so much money for it!\n\nI'm off to sell my first batch! See you later!"%_t
    dialog.answers = {{answer = "Awesome! Bye!"%_t}}
    dialog.onEnd = "onEndDialog"

    local entity = Entity(mission.data.custom.adventurerId)
    entity:invokeFunction("story/missionadventurer.lua", "setData", true, true, dialog)
end

function onEndDialog()
    if onClient() then
        invokeServerFunction("onEndDialog")
        return
    end
    Sector():deleteEntityJumped(Entity(mission.data.custom.adventurerId))
    setPhase(5)
end
callable(nil, "onEndDialog")

function onHailRejected()
    if onClient() then invokeServerFunction("onHailRejected") end
    nextPhase()
end
callable(nil, "onHailRejected")

