package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("utility")
include("stringutility")
include("callable")
include("structuredmission")
include("galaxy")
MissionUT = include("missionutility")
local SectorSpecifics = include ("sectorspecifics")
local AsyncPirateGenerator = include("asyncpirategenerator")
local SectorTurretGenerator = include ("sectorturretgenerator")

-- mission.tracing = true

mission.data.brief = "Combat Instructions"%_T
mission.data.title = "Combat Instructions"%_T
mission.data.icon = "data/textures/icons/graduate-cap.png"
mission.data.priority = 5
mission.data.description =
{
    "To help you survive in this dangerous galaxy, the Adventurer wants to teach you about ship to ship combat."%_T,
    {text = "Install Armed Turrets"%_T, bulletPoint = true, fulfilled = false}
}

mission.data.custom.goNextOne = true
mission.data.custom.coords = {}
mission.data.custom.damagedEntities = {}

mission.phases[1] = {}
mission.phases[1].onBeginServer = function()
    local player = Player()
    local mail = Mail()
    mail.text = Format("Hi there,\n\nThe galaxy is a dangerous place, and before venturing out you should know how to defend yourself.\nStep 1: Attach one or more armed turrets to your ship.\nStep 2: Find an empty sector and destroy a pirate with your turrets.\n\nGreetings,\n%1%"%_T, getAdventurerName())
    mail.header = "Combat Instructions /* Mail Subject */"%_T
    mail.sender = Format("%1%, the Adventurer"%_T, getAdventurerName())
    player:addMail(mail)
end

mission.phases[1].updateServer = function()
    -- check if player installs the armed turret
    -- update Description if so

    local player = Player()
    local craft = player.craft
    if not craft then return end
    if craft.isDrone then return end

    for _, turret in pairs({craft:getTurrets()}) do
        if turret.isArmedTurret == 1 then
            mission.data.description[2].fulfilled = true
            mission.data.description[3] = {text = "Fly to an empty sector"%_T, bulletPoint = true, fulfilled = false}
            if mission.data.custom.goNextOne then nextPhase() end
            mission.data.custom.goNextOne = false
        end
    end
end
mission.phases[1].showUpdateOnEnd = true

mission.phases[2] = {}
mission.phases[2].onSectorEntered = function(x, y)
    if onServer() then
        local specs = SectorSpecifics()
        local regular, offgrid, blocked, home = specs:determineContent(x, y, Server().seed)

        if not regular and not offgrid and not blocked and not home then
            mission.data.description[3].fulfilled = true
            mission.data.description[4] = {text = "Destroy the pirate!"%_T, bulletPoint = true, fulfilled = false}
            createPirate()
            mission.data.custom.coords = Sector():getCoordinates()
        end
    end
end
mission.phases[2].showUpdateOnEnd = true

mission.phases[3] = {}
mission.phases[3].onEntityDestroyed = function(index, lastDamageInflictor)
    if Entity(index).isShip then
        local ship = Entity(index)
        local playerDamagers = {ship:getDamageContributorPlayers()}
        printTable(playerDamagers)
        for _, playerDamager in pairs(playerDamagers) do
            if playerDamager == Player().index then
                sendReward()
                accomplish()
                return
            end
        end
    end
end


function getAdventurerName()
    local player = Player()
    local faction = Galaxy():getNearestFaction(player:getHomeSectorCoordinates())
    local language = faction:getLanguage()
    language.seed = Server().seed
    return language:getName()
end

function createPirate()
    local dir = normalize(vec3(getFloat(-1, 1), getFloat(-1, 1), getFloat(-1, 1)))
    local up = vec3(0, 1, 0)
    local pos = dir * 1000

    local generator = AsyncPirateGenerator(nil, onPirateCreated)
    generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos))
end

function onPirateCreated()
    nextPhase()
end

function sendReward()
    local player = Player()
    local mail = Mail()
    mail.header = "Combat Instructions: Well done! /* Mail Subject */"%_T
    mail.text = Format("Hi there,\n\nI see you survived your first enemy! It won't be the last one you run into. I want to give you a few of my turrets to help you out. The turrets in the attachment should help to get you a head start over any pirates you might encounter.\n\nGreetings,\n%s"%_T, getAdventurerName())
    mail.sender = Format("%s, the Adventurer"%_T, getAdventurerName())

    local x, y = Sector():getCoordinates()
    local turret = SectorTurretGenerator():generate(x, y, nil, Rarity(RarityType.Uncommon), WeaponType.ChainGun, Material(MaterialType.Iron))
    turret.coaxial = false
    mail:addTurret(turret)
    mail:addTurret(turret)
    player:addMail(mail)
    player:setValue("tutorial_fighting_accomplished", true) -- set this here, so that player can't repeat mission after receiving reward
end

function onAbandon()
    Player():setValue("tutorial_fighting_accomplished", true) -- player doesn't want to be bugged again
end
