package.path = package.path .. ";data/scripts/lib/?.lua"

include("stringutility")
include("callable")

local somethingToBeFound = false

-- if this function returns false, the script will not be listed in the interaction window,
-- even though its UI may be registered
function interactionPossible(playerIndex)

    local player = Player(playerIndex)
    local self = Entity()

    local craft = player.craft
    if craft == nil then return false end

    local dist = craft:getNearestDistance(self)

    if dist < 200 then
        return true
    end

    return false, "You're not close enough to search the object."%_t
end

function initUI()
    local entity = Entity()
    local p = Plan(entity.id)
    local block = p:getBlocksByType(BlockType.BlackBox)
    if block and #block > 0 then
        somethingToBeFound = true
    end
    ScriptUI():registerInteraction("Search"%_t, "onSearch")
end

function onSearch(entityIndex)
    local ui = ScriptUI(entityIndex)
    if not ui then return end

    if somethingToBeFound then
        ui:showDialog(foundSomethingDialog())
    else
        ui:showDialog(foundNothingDialog())
    end
end

function foundNothingDialog()
    local d0_NothingFoundHer = {}

    d0_NothingFoundHer.text = "Nothing found here."%_t
    d0_NothingFoundHer.answers = {
        {answer = "OK"%_t, onSelect = "finishScript"}
    }

    return d0_NothingFoundHer
end

function foundSomethingDialog()
    -- make dialog
    local d0_YouFoundSomeInf = {}

    d0_YouFoundSomeInf.text = "This ship looks like it has been dead for a while. There's no heat registering on your scanners, and all crew aboard is frozen stiff. The energy generator looks torn apart, it may have released toxic fumes into their air system."%_t
    d0_YouFoundSomeInf.answers = {
    {answer = "I should tell other members of their faction about my findings."%_t, onSelect = "onFoundEnd"}
    }

    return d0_YouFoundSomeInf
end

function finishScript()
    terminate()
    return
end

function onFoundEnd()
    Player():invokeFunction("player/missions/searchandrescue/searchandrescue.lua", "onFoundDialogEnd")
end

function secure()
    return somethingToBeFound
end

function restore(value)
    somethingToBeFound = value
end
