package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("callable")
include("randomext")
include("structuredmission")
local SectorSpecifics = include("sectorspecifics")
local Balancing = include("galaxy")
local MissionUtility = include("missionutility")


mission.data.brief = "Wipe out Xsotan"%_t
mission.data.title = "Wipe out Xsotan in (${location.x}:${location.y})"%_t
mission.data.description = "You were tasked to take care of a group of Xsotan that appears to have settled in sector (${location.x}:${location.y})."%_t

mission.data.reward.paymentMessage = "Earned %1% credits for wiping out a group of Xsotan."%_T
mission.data.accomplishMessage = "Thank you for taking care of them. We transferred the reward to your account."%_t
mission.data.finishMessage = "Looks like someone already took care of them. Thank you nevertheless."%_t

mission.phases[1] = {}
mission.phases[1].onTargetLocationEntered = function(x, y)
    if onClient() then
        startMission() -- wait until Client loaded in before doing any of the checks
    end
end

mission.phases[1].updateTargetLocationServer = function(timeStep)
    local count = MissionUT.countXsotan()
    mission.data.xsotanFound = mission.data.xsotanFound or count > 0

    if mission.data.xsotanFound and count == 0 then
        reward()
        accomplish()
    elseif not mission.data.xsotanFound and count == 0 then
        finish() -- extra check on that so that test cases work
    end
end

function startMission()
    if onClient() then invokeServerFunction("startMission") return end

    local count = MissionUT.countXsotan()
    if count == 0 then
        finish()
    else
        mission.data.xsotanFound = true
    end
end
callable(nil, "startMission")


mission.makeBulletin = function(station)

    -- find a sector that has xsotan
    local specs = SectorSpecifics()
    local x, y = Sector():getCoordinates()
    local giverInsideBarrier = MissionUT.checkSectorInsideBarrier(x, y)
    local coords = specs.getShuffledCoordinates(random(), x, y, 2, 15)
    local serverSeed = Server().seed
    local target = nil

    for _, coord in pairs(coords) do
        local regular, offgrid, blocked, home = specs:determineContent(coord.x, coord.y, serverSeed)

        if offgrid and not blocked and giverInsideBarrier == MissionUT.checkSectorInsideBarrier(coord.x, coord.y) then
            specs:initialize(coord.x, coord.y, serverSeed)

            if specs.generationTemplate.path == "sectors/xsotanasteroids" then
                if not Galaxy():sectorExists(coord.x, coord.y) then
                    target = coord
                    break
                end
            end
        end
    end

    if not target then return end

    local description = "A nearby sector is occupied by Xsotan. While they don't attack unless provoked, the threat still makes all of us nervous.\nWe need someone to drive them out.\n\nSector: (${x} : ${y})"%_t

    reward = 50000 * Balancing.GetSectorRichnessFactor(Sector():getCoordinates())

    local bulletin =
    {
        -- data for the bulletin board
        brief = "Wipe out Xsotan"%_T,
        description = description,
        difficulty = "Medium /*difficulty*/"%_T,
        reward = "¢${reward}"%_T,
        script = "missions/clearxsotansector.lua",
        formatArguments = {x = target.x, y = target.y, reward = createMonetaryString(reward)},
        msg = "Their location is \\s(%1%:%2%)."%_T,
        giverTitle = station.title,
        giverTitleArgs = station:getTitleArguments(),
        onAccept = [[
            local self, player = ...
            player:sendChatMessage(Entity(self.arguments[1].giver), 0, self.msg, self.formatArguments.x, self.formatArguments.y)
        ]],

        -- data that's important for our own mission
        arguments = {{
            giver = station.index,
            location = target,
            reward = {credits = reward, relations = 4000},
        }},
    }

    return bulletin
end
