-- This is always the first script that is executed for a logged in player
-- Offline players don't have running scripts

-- Note: This script does not get attached to the Player
-- Note: This script is called BEFORE any other scripts are initialized
-- Note: When loading from Database, other scripts attached to the Player are available through Player():hasScript() etc.
-- Note: When adding scripts to the player from here with addScript() or addScriptOnce(),
--       the added scripts will NOT get initialized immediately,
--       their initialization order is not defined,
--       parameters passed in addition to the script name will be IGNORED and NOT passed to the script's initialize() function,
--       and the script will instead be treated as if loaded from database, with the _restoring variable set in its initialize() function
-- Note: Player scripts are initialized once the player's sector was loaded and the player is placed inside, not on log-in.

if onServer() then

local player = Player()

player:addScriptOnce("map/mapcommands.lua")
player:addScriptOnce("map/economyinfo.lua")
player:addScriptOnce("client/musiccoordinator.lua")

player:addScriptOnce("ui/playerdiplomacy.lua")
player:addScriptOnce("ui/alliancediplomacy.lua")
player:addScriptOnce("ui/sectorshipoverview.lua")
player:addScriptOnce("ui/badcargoshipproblem.lua")
player:addScriptOnce("ui/encyclopedia/encyclopedia.lua")

player:addScriptOnce("background/homesectorrelations.lua")
player:addScriptOnce("background/tutorialstarter.lua")
player:addScriptOnce("background/spymails.lua")

player:addScriptOnce("events/headhunter.lua")
player:addScriptOnce("events/eventscheduler.lua")
player:addScriptOnce("events/spawnasteroidboss.lua")
player:addScriptOnce("story/spawnrandombosses.lua")
player:addScriptOnce("story/spawnguardian.lua")
player:addScriptOnce("story/spawnadventurer.lua")

-- only in creative
if GameSettings().infiniteResources then
    player:addScriptOnce("ui/creativemodemenu.lua")
end

end
