
package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include ("galaxy")
include ("randomext")
include ("stringutility")
include ("faction")
local AsyncShipGenerator = include ("asyncshipgenerator")
local Placer = include("placer")
local SpawnUtility = include ("spawnutility")
local EventUT = include ("eventutility")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace HeadHunter
HeadHunter = {}

local threshold = 60 * 15

if onServer() then

local headhunterMessages =
{
    "This is ${player}! That's the one our client wants!"%_T,
    "Found you, ${player}. Let's shoot them down and get our money. Make it quick."%_T,
    "There they are. Alright, ${player} it's nothing personal, it's just a job."%_T,
}

local sarcasticMessages =
{
    "Oh, look who's being attacked by headhunters. What a surprise."%_T,
    "About time that you left this place."%_T,
    "Oh, too bad, someone's attacking you."%_T,
    "Now that's a nice surprise! Take them down!"%_T,
    "I really hoped that some headhunters would show up and make you leave."%_T,
    "Great! I really hoped that this would happen!"%_T,
    "Ha! I think I'm just going to sit back and watch the show."%_T,
    "Too bad nobody will help you here."%_T,
    "It's your own fault for staying around when you're not welcome."%_T,
}

function HeadHunter.getFaction()
    local name = "The Galactic Headhunters Guild"%_T

    local galaxy = Galaxy()
    local faction = galaxy:findFaction(name)
    if faction == nil then
        faction = galaxy:createFaction(name, 0, 0)
        faction.initialRelations = 0
        faction.initialRelationsToPlayer = 0
        faction.staticRelationsToPlayers = true

        SetFactionTrait(faction, "aggressive"%_T, "peaceful"%_T, 0.6)
        SetFactionTrait(faction, "careful"%_T, "brave"%_T, 0.75)
        SetFactionTrait(faction, "greedy"%_T, "generous"%_T, 0.75)
        SetFactionTrait(faction, "opportunistic"%_T, "honorable"%_T, 1.0)
    end

    faction.initialRelationsToPlayer = 0
    faction.staticRelationsToPlayers = true
    faction.homeSectorUnknown = true

    -- set home sector to wherever it's needed to avoid head hunters being completely over the top
    local x, y = Sector():getCoordinates()
    faction:setHomeSectorCoordinates(x, y)

    return faction
end


function HeadHunter.initialize()
end

function HeadHunter.getUpdateInterval()
    return threshold
end

function HeadHunter.update(timeStep)

    local sector = Sector()
    local x, y = sector:getCoordinates()
    local hx, hy = Player():getHomeSectorCoordinates()

    -- no attacks in home sector
    if x == hx and y == hy then
        threshold = 60 * 20 -- try again after some minutes
        return false -- no need to return from udpate() functions usually, but this is for a unit test
    end

    if not EventUT.attackEventAllowed() then
        threshold = 60 * 20 -- try again after some minutes
        return
    end

    -- find a hopefully evil faction that the player knows already
    local faction = HeadHunter.findNearbyEnemyFaction()

    if faction == nil then
        threshold = 60 * 10 -- try again after some minutes
        return false -- no need to return from udpate() functions usually, but this is for a unit test
    end

    -- create the head hunters
    HeadHunter.createEnemies(faction)

    threshold = 60 * 45

    return true -- no need to return from udpate() functions usually, but this is for a unit test
end

function HeadHunter.findNearbyEnemyFaction()

    -- find a hopefully evil faction that the player knows already
    local player = Player().craftFaction
    if not player then return end

    local x, y = Sector():getCoordinates()

    local locations =
    {
        {x = x, y = y},
        {x = x + math.random(-7, 7), y = y + math.random(-7, 7)},
        {x = x + math.random(-7, 7), y = y + math.random(-7, 7)},
        {x = x + math.random(-7, 7), y = y + math.random(-7, 7)},
        {x = x + math.random(-7, 7), y = y + math.random(-7, 7)},
    }

    local galaxy = Galaxy()
    local faction = nil
    for i, coords in pairs(locations) do

        local f = galaxy:getControllingFaction(coords.x, coords.y)

        if f and galaxy:isMapFaction(f.index) and player:knowsFaction(f.index) then
            local relation = player:getRelations(f.index)

            if relation < -80000 then
                faction = f
                break
            end
        end
    end

    if not faction then
        for i, coords in pairs(locations) do
            local f = Galaxy():getLocalFaction(coords.x, coords.y)

            if f and galaxy:isMapFaction(f.index) and player:knowsFaction(f.index) then
                local relation = player:getRelations(f.index)

                if relation < -80000 then
                    faction = f
                    break
                end
            end
        end
    end

    if faction then
        -- no head hunters from start ally
        local startAlly = player:getValue("start_ally")
        if startAlly and faction.index == startAlly then return end
    end

    return faction
end

function HeadHunter.createEnemies(faction)

    local onFinished = function(ships)
        local player = Player().craftFaction

        for _, ship in pairs(ships) do
            local ai = ShipAI(ship)
            ai:setAggressive()
            ai:registerEnemyFaction(player.index)
            ai:registerFriendFaction(faction.index)

            ship:setValue("secret_contractor", faction.index)
            ship:addScriptOnce("deleteonplayersleft.lua")
            ship:setValue("is_persecutor", 1)

            if string.match(ship.title, "Persecutor") then
                ship.title = "Head Hunter"%_T
            end
        end

        Placer.resolveIntersections(ships)

        -- add enemy buffs
        SpawnUtility.addEnemyBuffs(ships)

        player:sendChatMessage(ships[1], ChatMessageType.Chatter, randomEntry(headhunterMessages) % {player = player.name})
        deferredCallback(3, "sarcasticRemark")
    end

    -- create the head hunters
    local dir = normalize(vec3(getFloat(-1, 1), getFloat(-1, 1), getFloat(-1, 1)))
    local up = vec3(0, 1, 0)
    local right = normalize(cross(dir, up))
    local pos = dir * 1500

    local headhuntersFaction = HeadHunter.getFaction()

    local generator = AsyncShipGenerator(HeadHunter, onFinished)
    generator:startBatch()

    local volume = Balancing_GetSectorShipVolume(Sector():getCoordinates())

    generator:createPersecutorShip(headhuntersFaction, MatrixLookUpPosition(dir, up, pos), volume * 4)
    generator:createPersecutorShip(headhuntersFaction, MatrixLookUpPosition(dir, up, pos), volume * 4)
    generator:createBlockerShip(headhuntersFaction, MatrixLookUpPosition(dir, up, pos), volume * 2)

    generator:endBatch()

    local player = Player().craftFaction
    local galaxy = Galaxy()
    galaxy:setFactionRelations(headhuntersFaction, player, 0, false, false)
    galaxy:setFactionRelationStatus(headhuntersFaction, player, RelationStatus.Neutral, false, false)

end

function HeadHunter.sarcasticRemark()

    local sector = Sector()
    local x, y = sector:getCoordinates()
    local faction = Galaxy():getControllingFaction(x, y)
    if not faction then return end

    local player = Player().craftFaction

    local ships = {sector:getEntitiesByType(EntityType.Ship)}
    for _, ship in pairs(ships) do
        if player:getRelations(ship.factionIndex) <= -80000 then
            player:sendChatMessage(ship, ChatMessageType.Chatter, randomEntry(sarcasticMessages))
            return
        end
    end
end

end
