
package.path = package.path .. ";data/scripts/lib/?.lua"
include("utility")
include("stringutility")
local AdventurerGuide = include("story/adventurerguide")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace TutorialStarter
TutorialStarter = {}

if onServer() then

function TutorialStarter.initialize()
    local player = Player()
    player:registerCallback("onItemAdded", "onItemAdded")
    player:registerCallback("onShipChanged", "onShipChanged")
    player:registerCallback("onSectorEntered", "onSectorEntered")

    local craft = player.craft
    if not craft then return end
    craft:registerCallback("onPlanModifiedByBuilding", "onPlanModifiedByBuilding")
end


function TutorialStarter.onItemAdded(index, amount, amountBefore)

    local player = Player()
    if not player:getValue("met_adventurer") then return end
    if player:getValue("tutorial_rmining_accomplished") then return end

    local item = player:getInventory():find(index)

    if item and item.itemType == InventoryItemType.Turret then
        if item.stoneRawEfficiency > 0 then
            player:addScriptOnce("data/scripts/player/missions/tutorials/rminingtutorial.lua")
        end
    end
end

function TutorialStarter.onPlanModifiedByBuilding(objectIndex)

    local player = Player()
    if not player:getValue("met_adventurer") then return end

    local craft = player.craft
    if not craft then return end
    local plan = Plan(craft)
    if not plan then return end

    if not player:getValue("tutorial_torpedoes_accomplished") and plan:getNumBlocks(BlockType.TorpedoLauncher) > 0 then
        player:addScriptOnce("data/scripts/player/missions/tutorials/torpedoestutorial.lua")
    end

    if not player:getValue("tutorial_fighters_accomplished") and plan:getNumBlocks(BlockType.Hangar) > 0 then
        player:addScriptOnce("data/scripts/player/missions/tutorials/fightertutorial.lua")
    end
end

function TutorialStarter.onShipChanged(playerIndex, craftId)
    local craft = Entity(craftId)
    if not craft then return end
    craft:registerCallback("onPlanModifiedByBuilding", "onPlanModifiedByBuilding")
end

function TutorialStarter.onSectorEntered(playerIndex, x, y, sectorChangeType)

    local player = Player()
    if not player:getValue("met_adventurer") then return end

    local playerPlaytime = player.playtime

    -- barrier tutorial - spawns if player has barrier in jump range
    if player:getValue("tutorial_barrier_accomplished") then goto continue end
    if player:hasScript("player/missions/tutorials/barriertutorial.lua") then goto continue end
    if TutorialStarter.checkDistance(x, y) and AdventurerGuide.canSpawn() then
        player:addScriptOnce("data/scripts/player/missions/tutorials/barriertutorial.lua")
    end
    ::continue::

    -- found station tutorial
    if not player:getValue("tutorial_foundstation_accomplished") and player.money >= 4 * 1000 * 1000 then
        local stations = {Sector():getEntitiesByType(EntityType.Station)}
        local shipyardPresent = 0
        for _, station in pairs(stations) do
             if station:hasScript("data/scripts/entity/merchants/shipyard.lua") then
             shipyardPresent = shipyardPresent + 1
        end
        end
        if shipyardPresent > 0 and player:getValue("tutorial_fleetcommands_accomplished") and AdventurerGuide.canSpawn() then
            player:addScriptOnce("data/scripts/player/missions/tutorials/foundstationtutorial.lua")
        end
    end


    local homeX, homeY = player:getHomeSectorCoordinates()
    local distanceSquare = ((homeX - x) * (homeX - x)) + ((homeY - y) * (homeY - y))
    local distance = math.sqrt(distanceSquare)

    -- fighting tutorial
    if distance > 5 and not player:getValue("tutorial_fighting_accomplished") and playerPlaytime > 30 * 60 then
        player:addScriptOnce("data/scripts/player/missions/tutorials/fightingtutorial.lua")
    end

    -- trading tutorial
    if distance > 25 and not player:getValue("tutorial_trading_accomplished") and playerPlaytime > 60 * 60 then
        player:addScriptOnce("data/scripts/player/missions/tutorials/tradetutorial.lua")
    end

    -- fleet commands tutorial
    if player:getValue("tutorial_fleetcommands_notRepeatable") then return end
    if player:getValue("tutorial_fleetcommands_notRepeatable") == false then
        local value = player:getValue("tutorial_fleetcommands_timeout")
        if value and value < 9 then
            value = value + 1
            player:setValue("tutorial_fleetcommands_timeout", value)
        elseif value and value == 9 then
            player:setValue("tutorial_fleetcommands_notRepeatable", nil)
            value = value + 1
            player:setValue("tutorial_fleetcommands_timeout", value)
        else
            player:setValue("tutorial_fleetcommands_timeout", 1)
        end
    return end

    if distance > 40 and AdventurerGuide.canSpawn() then
        player:addScriptOnce("data/scripts/player/missions/tutorials/fleetcommandstutorial.lua")
    end
end

function TutorialStarter.checkDistance(x, y)
    local player = Player()
    if not player.craft then return false end
    local distReach = player.craft.hyperspaceJumpReach
    local distBarrier = math.sqrt((x*x)+(y*y)) - 150

    if distBarrier < 0 then return false end
    if distReach < distBarrier then return false end
    return true
end

end
