
package.path = package.path .. ";data/scripts/lib/?.lua"
include("stringutility")

-- Don't remove or alter the following comment, it tells the game the namespace this script lives in. If you remove it, the script will break.
-- namespace SpyMails
SpyMails = {}

if onServer() then

SpyMails.lastMailTimeByFaction = {}

function SpyMails.secure()
    local times = {}
    for factionIndex, mailTime in pairs(SpyMails.lastMailTimeByFaction) do
        table.insert(times, {factionIndex = factionIndex, mailTime = mailTime})
    end

    return
    {
        mailTimes = times
    }
end

function SpyMails.restore(data)
    SpyMails.lastMailTimeByFaction = {}
    for _, times in pairs(data.mailTimes) do
        SpyMails.lastMailTimeByFaction[times.factionIndex] = times.mailTime
    end
end

function SpyMails.getUpdateInterval()
    return 5 * 60
end

function SpyMails.initialize()
--    local player = Player()
--    local server = Server()

--    local currentTime = server.unpausedRuntime

--    for key, value in pairs(player:getValues()) do
--        if string.starts(key, "spy_timestamp_") then
--            local remainingTime = value - currentTime

--            if remainingTime >= 0 then
--                print(key .. " -> " .. remainingTime .. " (" .. createReadableTimeString(remainingTime) .. ")")

--                local factionIndex = tonumber(string.sub(key, 15))
--                if factionIndex then
--                    table.insert(SpyMails.factions, factionIndex)

--                    SpyMails.generateMessageBody(factionIndex, value)
--                end
--            else
--                -- clean up inactive spies
--                player:setValue(key, nil)
--            end
--        end
--    end
end

function SpyMails.update()
    local player = Player()
    local currentTime = Server().unpausedRuntime

    for factionIndex, mailTime in pairs(SpyMails.lastMailTimeByFaction) do
        local key = "spy_timestamp_" .. tostring(factionIndex)
        local timestamp = player:getValue(key) or 0

        local remainingTime = timestamp - currentTime

        if remainingTime < 0 then
            SpyMails.sendTerminationMail(factionIndex)

            -- clean up
            SpyMails.lastMailTimeByFaction[factionIndex] = nil
            player:setValue(key, nil)

        elseif currentTime - mailTime >= 60 * 60 then
            -- send periodic mail
            SpyMails.sendUpdateMail(factionIndex, timestamp)
        end
    end
end

function SpyMails.onSpyHired(factionIndex, timestamp)
    SpyMails.sendUpdateMail(factionIndex, timestamp)
end

function SpyMails.sendUpdateMail(factionIndex, timestamp)
    local faction = Faction(factionIndex)
    if not faction then return end

    local currentTime = Server().unpausedRuntime
    local remainingTime = timestamp - currentTime

    local oldMailTimestamp = SpyMails.lastMailTimeByFaction[factionIndex]
    if oldMailTimestamp and currentTime - oldMailTimestamp < 30 * 60 then
        -- another mail was sent recently
        return
    end

    SpyMails.lastMailTimeByFaction[factionIndex] = currentTime

    local player = Player()

    -- faction name
    -- size (sectors, stations)
    -- military capacity
    -- deployed military
    -- reconstructing stations

    local militaryShips = faction:getValue("military_ships")
    local maxMilitaryShips = faction:getValue("max_military_ships")

    local construction = faction:getValue("construction")
    local maxConstruction = faction:getValue("max_construction")

    local numStations = faction:getValue("num_stations")

    local message
    local arguments = {}
    local time, tbl = createDigitalTimeString(remainingTime)
    local timeUnit = "Seconds"%_t
    if tbl.hours > 0 then
        timeUnit = "Hours"%_t
    elseif tbl.minutes > 0 then
        timeUnit = "Minutes"%_t
    end


    if anynils(militaryShips, maxMilitaryShips, construction, maxConstruction, numStations) then
        message = "To whom it may concern,\n\nWe received your orders. Surveillance of faction '%1%' will be established soon. The information will be displayed in your Diplomacy overview.\n\nSurveillance will continue for: %2% %3%\n\nRegards"%_T
        arguments = {
            --faction.unformattedName,
            faction.name,
            time,
            timeUnit
        }
    else
        message = "To whom it may concern,\n\nSurveillance of faction '%1%' is in place.\nOur sources say they have %2% stations, %3% military ships on call and %4% station construction capacity.\nThe information can also be viewed from your Diplomacy overview.\n\nTime remaining: %5% %6%\n\nRegards"%_T
        arguments = {
--            faction.unformattedName,
            faction.name,
            numStations,
            militaryShips,
            construction,
            time,
            timeUnit
        }
    end

    local mail = Mail()
    mail.sender = "Hidden Sender"%_T
    mail.receiver = player.id
--    mail.header = Format("Surveillance Report of Faction '%1%'"%_T, faction.unformattedName)
    mail.header = Format("Surveillance Report, '%1%'"%_T, faction.name)
    mail.text = Format(message, unpack(arguments))

    player:addMail(mail)
end

function SpyMails.sendTerminationMail(factionIndex)
    local faction = Faction(factionIndex)
    if not faction then return end

    local player = Player()

    local militaryShips = faction:getValue("military_ships")
    local maxMilitaryShips = faction:getValue("max_military_ships")

    local construction = faction:getValue("construction")
    local maxConstruction = faction:getValue("max_construction")

    local numStations = faction:getValue("num_stations")

    if anynils(militaryShips, maxMilitaryShips, construction, maxConstruction, numStations) then
        message = "To whom it may concern,\n\nOur surveillance of faction '%1%' is now concluded. To contact us again, visit any trusted Smuggler Hideout.\n\nRegards"%_T
        arguments = {
            --faction.unformattedName
            faction.name
        }
    else
        message = "To whom it may concern,\n\nOur surveillance of faction '%1%' is now concluded.\nAt the time of writing, they had %2% stations, %3% military ships on call and %4% construction capacity.\n\nRegards"%_T
        arguments = {
--            faction.unformattedName,
            faction.name,
            numStations,
            militaryShips,
            construction
        }
    end

    local mail = Mail()
    mail.sender = "Hidden Sender"%_T
    mail.receiver = player.id
    mail.header = Format("Surveillance Termination Notice, '%1%'"%_T, faction.name)
    mail.text = Format(message, unpack(arguments))

    player:addMail(mail)
end

end
