package.path = package.path .. ";data/scripts/lib/?.lua"

include("stringutility")
include("utility")

WeaponType = {}
WeaponTypes = {}
WeaponTypes.armedTypes = {}
WeaponTypes.nameByType = {}

function WeaponTypes.getRandom(rand)
    return rand:getInt(WeaponType.ChainGun, WeaponType.AntiFighter)
end

function WeaponTypes.getArmed()
    return unpack(WeaponTypes.armedTypes)
end

function WeaponTypes.addType(id, displayName, armed)
    WeaponType[id] = tablelength(WeaponType)
    WeaponTypes.nameByType[WeaponType[id]] = displayName

    if armed then table.insert(WeaponTypes.armedTypes, WeaponType[id]) end
end

local armed = true
local unarmed = false

WeaponTypes.addType("ChainGun",             "Chaingun /* Weapon Type */"%_t,                armed)
WeaponTypes.addType("PointDefenseChainGun", "Point Defense Chaingun /* Weapon Type */"%_t,  armed)
WeaponTypes.addType("PointDefenseLaser",    "Point Defense Laser /* Weapon Type */"%_t,     armed)
WeaponTypes.addType("Laser",                "Laser /* Weapon Type */"%_t,                   armed)
WeaponTypes.addType("MiningLaser",          "Mining Laser /* Weapon Type */"%_t,            unarmed) -- "MiningLaser" is explicitly used in C++ code and must be available
WeaponTypes.addType("RawMiningLaser",       "Raw Mining Laser /* Weapon Type */"%_t,        unarmed)
WeaponTypes.addType("SalvagingLaser",       "Salvaging Laser /* Weapon Type */"%_t,         unarmed)
WeaponTypes.addType("RawSalvagingLaser",    "Raw Salvaging Laser /* Weapon Type */"%_t,     unarmed)
WeaponTypes.addType("PlasmaGun",            "Plasma /* Weapon Type */"%_t,                  armed)
WeaponTypes.addType("RocketLauncher",       "Launcher /* Weapon Type */"%_t,                armed)
WeaponTypes.addType("Cannon",               "Cannon /* Weapon Type */"%_t,                  armed)
WeaponTypes.addType("RailGun",              "Railgun /* Weapon Type */"%_t,                 armed)
WeaponTypes.addType("RepairBeam",           "Repair /* Weapon Type */"%_t,                  unarmed)
WeaponTypes.addType("Bolter",               "Bolter /* Weapon Type */"%_t,                  armed)
WeaponTypes.addType("LightningGun",         "Lightning Gun /* Weapon Type */"%_t,           armed)
WeaponTypes.addType("TeslaGun",             "Tesla Gun /* Weapon Type */"%_t,               armed)
WeaponTypes.addType("ForceGun",             "Force Gun /* Weapon Type */"%_t,               unarmed)
WeaponTypes.addType("PulseCannon",          "Pulse Cannon /* Weapon Type */"%_t,            armed)
WeaponTypes.addType("AntiFighter",          "Anti Fighter /* Weapon Type */"%_t,            armed)

