package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"
package.path = package.path .. ";data/scripts/systems/?.lua"

include("randomext")
local AsyncPirateGenerator = include("asyncpirategenerator")
local Xsotan = include("story/xsotan")
local SectorTurretGenerator = include("sectorturretgenerator")

local WaveUtility = {}
WaveUtility.__index = WaveUtility

local waves = {}

local lvl1 = 1
local lvl2 = 2
local lvl3 = 3
local lvl4 = 4
local lvl5 = 5
local lvl6 = 6
local lvl7 = 7

WaveUtility.data = {}
WaveUtility.data.startingWave = nil
WaveUtility.data.numWaves = nil
WaveUtility.data.waveStrength = nil
WaveUtility.data.waveSize = nil
WaveUtility.data.waveStep = nil

-- waves should be taken from the middle of the table the two rows/columns on the edge are a buffer
-- optimal range for average wave strength is between waves 7 and 12 from column 2 to 5
waves[1] =  {lvl1,  lvl2,  lvl1,  lvl2,  lvl2,  lvl3,  lvl2,  lvl3}
waves[2] =  {lvl2,  lvl1,  lvl2,  lvl2,  lvl3,  lvl2,  lvl3,  lvl3}
waves[3] =  {lvl1,  lvl2,  lvl2,  lvl3,  lvl2,  lvl3,  lvl3,  lvl4}
waves[4] =  {lvl2,  lvl2,  lvl3,  lvl2,  lvl3,  lvl3,  lvl4,  lvl3}
waves[5] =  {lvl2,  lvl3,  lvl2,  lvl3,  lvl3,  lvl4,  lvl3,  lvl4}
waves[6] =  {lvl3,  lvl2,  lvl3,  lvl3,  lvl4,  lvl3,  lvl4,  lvl4}
waves[7] =  {lvl2,  lvl3,  lvl3,  lvl4,  lvl3,  lvl4,  lvl4,  lvl5}
waves[8] =  {lvl3,  lvl3,  lvl4,  lvl3,  lvl4,  lvl4,  lvl5,  lvl4}
waves[9] =  {lvl3,  lvl4,  lvl3,  lvl4,  lvl4,  lvl5,  lvl4,  lvl5}
waves[10] = {lvl4,  lvl3,  lvl4,  lvl4,  lvl5,  lvl4,  lvl5,  lvl5}
waves[11] = {lvl3,  lvl4,  lvl4,  lvl5,  lvl4,  lvl5,  lvl5,  lvl6}
waves[12] = {lvl4,  lvl4,  lvl5,  lvl4,  lvl5,  lvl5,  lvl6,  lvl5}
waves[13] = {lvl4,  lvl5,  lvl4,  lvl5,  lvl5,  lvl6,  lvl5,  lvl6}
waves[14] = {lvl5,  lvl4,  lvl5,  lvl5,  lvl6,  lvl5,  lvl6,  lvl6}
waves[15] = {lvl4,  lvl5,  lvl5,  lvl6,  lvl5,  lvl6,  lvl6,  lvl7}
waves[16] = {lvl5,  lvl5,  lvl6,  lvl5,  lvl6,  lvl6,  lvl7,  lvl6}
waves[17] = {lvl5,  lvl6,  lvl5,  lvl6,  lvl6,  lvl7,  lvl6,  lvl7}
waves[18] = {lvl6,  lvl5,  lvl6,  lvl6,  lvl7,  lvl6,  lvl7,  lvl7}
waves[19] = {lvl5,  lvl6,  lvl6,  lvl7,  lvl6,  lvl7,  lvl7,  lvl7}

function WaveUtility.getWaves(startingWave, numWaves, waveStrength, waveSize, waveStep)
    x, y = Sector():getCoordinates()
    local distToCenter = math.sqrt(x * x + y * y)

    WaveUtility.data.startingWave = startingWave or round(lerp(distToCenter, 0, 500, 9, 1))
    if distToCenter >= 400 then
        WaveUtility.data.numWaves = numWaves or 2
    elseif distToCenter >= 300 then
        WaveUtility.data.numWaves = numWaves or 3
    else
        WaveUtility.data.numWaves = numWaves or 2
    end
    WaveUtility.data.waveStrength = waveStrength or round(lerp(distToCenter, 0, 500,  5, 1))
    WaveUtility.data.waveSize = waveSize or 4
    WaveUtility.data.waveStep = waveStep or 1

    --change startingWave according number of players with one player as default
    local playerDifficulty = Sector().numPlayers - 1
    if playerDifficulty > 3 then
        playerDifficulty = 4
    end

    if (WaveUtility.data.startingWave + WaveUtility.data.numWaves - 1) > #waves then print("WaveUtility: Requested ".. (WaveUtility.data.startingWave + WaveUtility.data.numWaves - 1).." waves, but table only contains " .. #waves.." waves.") return end
    if (WaveUtility.data.waveStrength + WaveUtility.data.waveSize - 1) > #waves[WaveUtility.data.startingWave + WaveUtility.data.numWaves - 1] then print("WaveUtility: Requested ".. (WaveUtility.data.waveStrength + WaveUtility.data.waveSize - 1).." wave width, but table only has width of " .. #waves[WaveUtility.data.startingWave + WaveUtility.data.numWaves - 1] ..".") return end

    local result = {}

    for i = WaveUtility.data.startingWave, (WaveUtility.data.startingWave + (WaveUtility.data.numWaves * WaveUtility.data.waveStep) - 1), WaveUtility.data.waveStep do
        local wave = {}
        for j = WaveUtility.data.waveStrength, (WaveUtility.data.waveStrength + WaveUtility.data.waveSize - 1) do
            table.insert(wave, waves[i][j])
        end
        table.insert(result, wave)
    end

    return result
end

function WaveUtility.createPirateWave(wave, callback)
    local dir = normalize(vec3(getFloat(-1, 1), getFloat(-1, 1), getFloat(-1, 1)))
    local up = vec3(0, 1, 0)
    local right = normalize(cross(dir, up))
    local pos = dir * 1000
    local distance = 150

    local generator = AsyncPirateGenerator(nil, callback)
    generator:startBatch()

    local counter = 0

    for _, level in pairs(wave) do
        if level == 1 then
            generator:createScaledOutlaw(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
        elseif level == 2 then
            generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
        elseif level == 3 then
            generator:createScaledPirate(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
        elseif level == 4 then
            if random():getFloat(0, 1) >= 0.25 then
                generator:createScaledMarauder(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
            else
                generator:createScaledDisruptor(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
            end
        elseif level == 5 then
            generator:createScaledRaider(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
        elseif level == 6 then
            generator:createScaledRavager(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
        elseif level == 7 then
            generator:createScaledBoss(MatrixLookUpPosition(-dir, up, pos + right * distance * counter))
        else
            print("WaveUtility: Couldn't find level")
        end
        counter = counter + 1
    end

    generator:endBatch()
end

function WaveUtility.createPirateBossWave(callback)
    local bossWave = {}
    -- skips one wave to make the bossWave stronger then the expected wave in normal order would be
    wave = WaveUtility.data.startingWave + (WaveUtility.data.numWaves * WaveUtility.data.waveStep) + WaveUtility.data.waveStep + 1

    for i = WaveUtility.data.waveStrength, (WaveUtility.data.waveStrength + WaveUtility.data.waveSize - 1) do
        table.insert(bossWave, waves[wave][i])
    end

     WaveUtility.createPirateWave(bossWave, callback)
end

function WaveUtility.playerVicinityCheck(entity, minDistance)
    if not valid(entity) then return false end

    local playerShips = {}
    for _, player in pairs({Sector():getPlayers()}) do
        table.insert(playerShips, player.craft)
    end
    for _, playerShip in pairs(playerShips) do
        local dist = playerShip:getNearestDistance(entity)
        if dist <= minDistance then
            initialEnemies = false
            return true
        end
    end
end

function WaveUtility.getWaveMember()
    for _, ship in pairs({Sector():getEntitiesByType(EntityType.Ship)}) do
        if ship:getValue("is_wave") == 1 then
            return ship
        end
    end
end

function WaveUtility.onDamaged(objectIndex, amount, inflictor, damageType)
    local entity = Entity(inflictor)
    if valid(entity) and entity.playerOwned then
        startEncounter()
    end
end

function WaveUtility.getNumEnemies()
    local enemies = {Sector():getEntitiesByType(EntityType.Ship)}
    local numEnemies = 0
    for _, enemy in pairs(enemies) do
        if enemy:getValue("is_wave") == 1 then
            numEnemies = numEnemies + 1
        end
    end

   return numEnemies
end

function WaveUtility.generateTurrets(amount)
    local turrets = {}
    if not amount then amount = 1 end

    for i = 1, amount do
        local weaponTypes = {}
        weaponTypes[WeaponType.Laser] = 1
        weaponTypes[WeaponType.PlasmaGun] = 1
        weaponTypes[WeaponType.RocketLauncher] = 1
        weaponTypes[WeaponType.Cannon] = 1
        weaponTypes[WeaponType.RailGun] = 1
        weaponTypes[WeaponType.Bolter] = 1
        weaponTypes[WeaponType.LightningGun] = 1
        weaponTypes[WeaponType.PulseCannon] = 1

        local rarities = {}
        rarities[RarityType.Exceptional] = 3
        rarities[RarityType.Exotic] = 5
        rarities[RarityType.Legendary] = 2



        local probabilities = Balancing_GetMaterialProbability(Sector():getCoordinates())
        local materials = {}
        materials[0] = probabilities[0]
        materials[1] = probabilities[1]
        materials[2] = probabilities[2]
        materials[3] = probabilities[3]
        materials[4] = probabilities[4]
        materials[5] = probabilities[5]
        materials[6] = probabilities[6]

        local x, y = Sector():getCoordinates()

        local rarity = selectByWeight(random(), rarities)
        local material = selectByWeight(random(), materials)
        local weaponType = selectByWeight(random(), weaponTypes)

        local turret = InventoryTurret(SectorTurretGenerator():generate(x, y, 0, Rarity(rarity), weaponType, Material(material)))

        table.insert(turrets, turret)
    end

    return turrets
end

return WaveUtility
