package.path = package.path .. ";data/scripts/lib/?.lua"
include ("randomext")
include ("stringutility")
include ("relations")
SectorTurretGenerator = include ("sectorturretgenerator")
UpgradeGenerator = include ("upgradegenerator")

local Rewards = {}

local messages1 =
{
    "Thank you."%_T,
    "Thank you so much."%_T,
    "We thank you."%_T,
    "Thank you for helping us."%_T,
}

local messages2 =
{
    "You have our endless gratitude."%_T,
    "We have transferred a reward to your account."%_T,
    "We have a reward for you."%_T,
    "Please take this as a sign of our gratitude."%_T,
}

function Rewards.standard(player, faction, msg, money, reputation, turret, system)

    msg = msg or messages1[random():getInt(1, #messages1)] .. " " .. messages2[random():getInt(1, #messages2)]

    -- give payment to players who participated
    player:sendChatMessage(faction.name, 0, msg)
    player:receive("Received a reward of %1% Credits."%_T, money)
    changeRelations(player, faction, reputation, nil)

    local x, y = Sector():getCoordinates()
    local object

    if system and random():getFloat() < 0.5 then
        object = UpgradeGenerator():generateSectorSystem(x, y, Rarity(RarityType.Uncommon))
    elseif turret then
        object = InventoryTurret(SectorTurretGenerator():generate(x, y))
    end

    if object then player:getInventory():addOrDrop(object) end

end

return Rewards
