package.path = package.path .. ";data/scripts/lib/?.lua"
include ("stringutility")
include ("utility")

function countReconstructionTokens(faction, shipName, factionIndex)

    factionIndex = factionIndex or faction.index

    local items = faction:getInventory():getItemsByType(InventoryItemType.VanillaItem)
    for idx, slot in pairs(items) do
        local amount = slot.amount
        local item = slot.item

        -- we assume they're stackable, so we return here
        if item:getValue("subtype") == "ReconstructionToken"
                and item:getValue("ship") == shipName
                and item:getValue("faction") == factionIndex then
            return amount, item, idx
        end
    end

    return 0, nil
end

function removeReconstructionTokens(faction, shipName, factionIndex)

    factionIndex = factionIndex or faction.index

    local items = faction:getInventory():getItemsByType(InventoryItemType.VanillaItem)
    for idx, slot in pairs(items) do
        local amount = slot.amount
        local item = slot.item

        -- we assume they're stackable, so we return here
        if item:getValue("subtype") == "ReconstructionToken"
                and item:getValue("ship") == shipName
                and item:getValue("faction") == factionIndex then

            faction:getInventory():removeAll(idx)
        end
    end

    return 0, nil
end

function createReconstructionToken(craft)
    local token = VanillaInventoryItem()
    token.name = "Ship Reconstruction Token"%_t
    token.price = 10 * 1000

    local rarity = Rarity(RarityType.Exotic)
    token.rarity = rarity
    token:setValue("subtype", "ReconstructionToken")
    token:setValue("ship", craft.name)
    token:setValue("faction", craft.factionIndex)
    token.icon = "data/textures/icons/reconstruction-token.png"
    token.iconColor = rarity.color
    token.stackable = true
    token.boundFaction = craft.factionIndex
    token.tradeable = false
    token.droppable = false

    local tooltip = Tooltip()
    tooltip.icon = token.icon

    local title = token.name

    local headLineSize = 25
    local headLineFontSize = 15
    local line = TooltipLine(headLineSize, headLineFontSize)
    line.ctext = title
    line.ccolor = token.rarity.color
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Reconstructs a destroyed ship."%_t
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Ship"%_t
    line.rtext = "'" .. craft.name .. "'"
    line.icon = "data/textures/icons/round-star.png"
    line.iconColor = ColorRGB(0.3, 1, 1)
    line.lcolor = ColorRGB(0.3, 1, 1)
    line.rcolor = ColorRGB(0.3, 1, 1)
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(24, 14)
    line.ltext = "Bound to a specific ship."%_t
    tooltip:addLine(line)

    local line = TooltipLine(24, 14)
    line.ltext = "Consumable at a Repair Dock."%_t
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Use at a Repair Dock to fully"%_t
    tooltip:addLine(line)

    local line = TooltipLine(18, 14)
    line.ltext = "reconstruct the bound ship."%_t
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Not Restored: Cargo, Fighters"%_t
    line.lcolor = ColorRGB(1, 1, 0.3)
    tooltip:addLine(line)


    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "A crystal that has all information"%_t
    line.lcolor = ColorRGB(0.4, 0.4, 0.4)
    tooltip:addLine(line)

    local line = TooltipLine(18, 14)
    line.ltext = "about a ship imprinted into it."%_t
    line.lcolor = ColorRGB(0.4, 0.4, 0.4)
    tooltip:addLine(line)


    token:setTooltip(tooltip)

    return token
end
