package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("randomext")
AsyncShipGenerator = include("asyncshipgenerator")
local SectorSpecifics = include ("sectorspecifics")
include("galaxy")

local MissionUT = {}

-- sector utility
function MissionUT.countPirates()
    local num = 0
    for _, entity in pairs({Sector():getEntitiesByType(EntityType.Ship)}) do
        if entity:getValue("is_pirate") == 1 then
            num = num + 1
        end
    end

    return num
end

function MissionUT.getPirates()
    local result = {}
    for _, entity in pairs({Sector():getEntitiesByType(EntityType.Ship)}) do
        if entity:getValue("is_pirate") == 1 then
            table.insert(result, entity)
        end
    end

    return result
end

function MissionUT.getPirateIdStrings()
    local result = {}
    for _, entity in pairs({Sector():getEntitiesByType(EntityType.Ship)}) do
        if entity:getValue("is_pirate") == 1 then
            table.insert(result, entity.id.string)
        end
    end

    return result
end

function MissionUT.countXsotan()
    local num = 0
    for _, entity in pairs({Sector():getEntitiesByType(EntityType.Ship)}) do
        if entity:getValue("is_xsotan") == 1 then
            num = num + 1
        end
    end

    return num
end

function MissionUT.getXsotan()
    local result = {}
    for _, entity in pairs({Sector():getEntitiesByType(EntityType.Ship)}) do
        if entity:getValue("is_xsotan") == 1 then
            table.insert(result, entity)
        end
    end

    return result
end

function MissionUT.getXsotanIdStrings()
    local result = {}
    for _, entity in pairs({Sector():getEntitiesByType(EntityType.Ship)}) do
        if entity:getValue("is_xsotan") == 1 then
            table.insert(result, entity.id.string)
        end
    end

    return result
end

-- entity utility
function MissionUT.deleteOnPlayersLeft(entity)
    entity:addScriptOnce("data/scripts/entity/deleteonplayersleft.lua")
end

-- binds an entity's lifetime to the currently executed mission
-- once the mission is over, the added script will make sure that the entity gets deleted
function MissionUT.bindToMission(entity)
    local player = Player()
    if not player then return end

    entity:addScriptOnce("data/scripts/entity/deleteonmissionover.lua", scriptPath(), player.index)
end

-- map & faction utility
function MissionUT.getNeighboringFactions(faction, d, numTries)
    if type(faction) == "number" then faction = Faction(faction) end
    d = d or 125

    local x, y = faction:getHomeSectorCoordinates()
    local homeSectors = Galaxy():getMapHomeSectors(x, y, d)
    homeSectors[faction.index] = nil

    local result = {}
    for idx, coords in pairs(homeSectors) do
        table.insert(result, Faction(idx))
    end

    return result
end

function MissionUT.getSector(centerX, centerY, minDist, maxDist, isRegular, isOffgrid, isBlocked, isHome)
    local specs = SectorSpecifics()
    local coords = specs.getShuffledCoordinates(random(), centerX, centerY, minDist, maxDist)
    local x, y

    for _, coord in pairs(coords) do

        local regular, offgrid, blocked, home = specs:determineContent(coord.x, coord.y, Server().seed)

        if (isRegular == nil or (regular == isRegular)) and
                (isOffgrid == nil or (offgrid == isOffgrid)) and
                (isBlocked == nil or (blocked == isBlocked)) and
                (isHome == nil or (home == isHome)) then
            x = coord.x
            y = coord.y
            break
        end
    end

    return x, y
end

-- objective creation
function MissionUT.createFreighter(faction, position, onFinished)

    position = position or Matrix()
    if type(faction) == "number" then
        faction = Faction(faction)
    end

    local sector = Sector()
    if not faction then
        local x, y = sector:getCoordinates()
        faction = Galaxy():getNearestFaction(x, y)
    end

    local generator = AsyncShipGenerator(nil, onFinished)
    generator:createFreighterShip(faction, position)

end

function MissionUT.checkSectorInsideBarrier(x, y)
    local distance2 = (x * x) + (y * y)
    if distance2 < (Balancing_GetBlockRingMax() * Balancing_GetBlockRingMax()) then return true
    else return false end
end

function MissionUT.detectFoundArtifacts(player)

    local inventory = player:getInventory()
    local upgrades = inventory:getItemsByType(InventoryItemType.SystemUpgrade)
    local count = {}

    for _, u in pairs(upgrades) do
        local upgrade = u.item
        if upgrade.rarity == Rarity(RarityType.Legendary) then
            if upgrade.script == "data/scripts/systems/teleporterkey1.lua" then
                count[1] = true
            elseif upgrade.script == "data/scripts/systems/teleporterkey2.lua" then
                count[2] = true
            elseif upgrade.script == "data/scripts/systems/teleporterkey3.lua" then
                count[3] = true
            elseif upgrade.script == "data/scripts/systems/teleporterkey4.lua" then
                count[4] = true
            elseif upgrade.script == "data/scripts/systems/teleporterkey5.lua" then
                count[5] = true
            elseif upgrade.script == "data/scripts/systems/teleporterkey6.lua" then
                count[6] = true
            elseif upgrade.script == "data/scripts/systems/teleporterkey7.lua" then
                count[7] = true
            elseif upgrade.script == "data/scripts/systems/teleporterkey8.lua" then
                count[8] = true
            end
        end
    end

    local shipNames = {player:getShipNames()}
    for _, name in pairs(shipNames) do
        for system, _ in pairs(player:getShipSystems(name)) do
            if system.script == "data/scripts/systems/teleporterkey1.lua" then
                count[1] = true
            elseif system.script == "data/scripts/systems/teleporterkey2.lua" then
                count[2] = true
            elseif system.script == "data/scripts/systems/teleporterkey3.lua" then
                count[3] = true
            elseif system.script == "data/scripts/systems/teleporterkey4.lua" then
                count[4] = true
            elseif system.script == "data/scripts/systems/teleporterkey5.lua" then
                count[5] = true
            elseif system.script == "data/scripts/systems/teleporterkey6.lua" then
                count[6] = true
            elseif system.script == "data/scripts/systems/teleporterkey7.lua" then
                count[7] = true
            elseif system.script == "data/scripts/systems/teleporterkey8.lua" then
                count[8] = true
            end
        end
    end

    return count
end

return MissionUT
