package.path = package.path .. ";data/scripts/lib/?.lua"

local PlanGenerator = include ("plangenerator")
local WeaponGenerator = include ("weapongenerator")
include ("galaxy")
include ("randomext")
include ("weapontype")
include ("utility")

local FighterGenerator =  {}

function FighterGenerator.generateFighter(rand, type, dps, tech, material, rarity, factionIndex)
    if type == nil then
        type = WeaponTypes.getRandom(rand)
    end

    local fighter = FighterGenerator.generateUnarmedFighter(rand, material, factionIndex)
    FighterGenerator.addWeapons(rand, type, dps, rarity, fighter, tech, material)

    return fighter
end

function FighterGenerator.addWeapons(rand, type, dps, rarity, fighter, tech, material)
    if type ~= WeaponType.AntiFighter then
        if type == WeaponType.ForceGun then
            dps = dps / 10
        end
        fighter:addWeapon(WeaponGenerator.generateWeapon(rand, type, dps, tech, material, rarity))
    end

    -- adjust fire rate of fighters so they don't slow down the simulation too much
    local weapons = {fighter:getWeapons()}
    fighter:clearWeapons()

    for _, weapon in pairs(weapons) do
        if weapon.isProjectile and weapon.fireRate > 2 then
            local old  = weapon.fireRate
            weapon.fireRate = rand:getFloat(1, 2)
            weapon.damage = weapon.damage * old / weapon.fireRate
        end

        fighter:addWeapon(weapon)
    end

    fighter:updateStaticStats()
end

function FighterGenerator.generateUnarmedFighter(rand, material, factionIndex)
    factionIndex = factionIndex or rand:getInt()

    local fighter = FighterTemplate()

    local plan = PlanGenerator.makeFighterPlan(factionIndex, rand:createSeed(), material)

    local diameter = rand:getFloat(fighter.minFighterDiameter, fighter.maxFighterDiameter)

    local scale = diameter + lerp(diameter, fighter.minFighterDiameter, fighter.maxFighterDiameter, 0, 1.5)
    scale = scale / (plan.radius * 2)

    plan:scale(vec3(scale, scale, scale))

    fighter.plan = plan

    -- set crew
    fighter.crew = 1
    fighter.durability = rand:getFloat(5, 25) * material.strengthFactor
    fighter.turningSpeed = rand:getFloat(1, 2.5)
    fighter.maxVelocity = rand:getFloat(15, 60)
    fighter.diameter = diameter

    if rand:test(0.2) then
        fighter.shield = rand:getFloat(5, 25) * material.strengthFactor
    end

    return fighter
end


return FighterGenerator
