
FactionEconomyUtility = {}

function FactionEconomyUtility.makeKey(x, y)
    return "faction_economy_sector_contents_" .. tostring(x) .. "_" .. tostring(y)
end

function FactionEconomyUtility.getMilitaryShips(faction)
    local eradicatedFactions = getGlobal("eradicated_factions") or {}
    if eradicatedFactions[faction.index] == true then return 0 end

    return faction:getValue("military_ships") or 40
end

function FactionEconomyUtility.getMaxMilitaryShips(faction)
    local eradicatedFactions = getGlobal("eradicated_factions") or {}
    if eradicatedFactions[faction.index] == true then return 0 end

    return faction:getValue("max_military_ships") or 40
end

function FactionEconomyUtility.setMilitaryShips(faction, amount)
    local eradicatedFactions = getGlobal("eradicated_factions") or {}
    if eradicatedFactions[faction.index] == true then amount = 0 end

    faction:setValue("military_ships", amount)
end

-- returns the number of spawned ships
function FactionEconomyUtility.trySpawnMilitaryShips(faction, numShips)
    numShips = numShips or 1

    local militaryShips = math.max(0, FactionEconomyUtility.getMilitaryShips(faction))
    numShips = math.min(numShips, militaryShips)
    if numShips == 0 then return 0 end

    FactionEconomyUtility.setMilitaryShips(faction, militaryShips - numShips)
    return numShips
end

function FactionEconomyUtility.despawnMilitaryShips(faction, numShips)
    numShips = numShips or 1

    local militaryShips = FactionEconomyUtility.getMilitaryShips(faction)
    local maxMilitaryShips = FactionEconomyUtility.getMaxMilitaryShips(faction)
    if militaryShips == maxMilitaryShips then return end

    militaryShips = militaryShips + numShips
    if militaryShips > maxMilitaryShips then
        militaryShips = maxMilitaryShips
    end

    FactionEconomyUtility.setMilitaryShips(faction, militaryShips)
end


function FactionEconomyUtility.getConstruction(faction)
    local eradicatedFactions = getGlobal("eradicated_factions") or {}
    if eradicatedFactions[faction.index] == true then return 0 end

    return faction:getValue("construction") or 3
end

function FactionEconomyUtility.getMaxConstruction(faction)
    local eradicatedFactions = getGlobal("eradicated_factions") or {}
    if eradicatedFactions[faction.index] == true then return 0 end

    return faction:getValue("max_construction") or 3
end

function FactionEconomyUtility.setConstruction(faction, amount)
    local eradicatedFactions = getGlobal("eradicated_factions") or {}
    if eradicatedFactions[faction.index] == true then return 0 end

    faction:setValue("construction", amount)
end

function FactionEconomyUtility.trySpawnConstructionSite(faction)
    local construction = math.max(0, FactionEconomyUtility.getConstruction(faction))
    if construction == 0 then return 0 end

    FactionEconomyUtility.setConstruction(faction, construction - 1)
    return 1
end


function FactionEconomyUtility.setFactionEradicated(faction)
    local eradicatedFactions = getGlobal("eradicated_factions") or {}
    if eradicatedFactions[faction.index] == true then
        print("faction " .. faction.name .. " is already eradicated")
        return
    end

    print("set faction " .. faction.name .. " eradicated")

    eradicatedFactions[faction.index] = true
    setGlobal("eradicated_factions", eradicatedFactions)

    -- send chat message
    local server = Server()
    server:broadcastChatMessage("Server", ChatMessageType.Normal, "Faction %1% was eradicated"%_T, faction.baseName)

    -- send mail
    local mail = Mail()
    mail.sender = "The Adventurer"%_T
    mail.header = Format("Faction '%1%' Eradicated"%_T, faction.baseName)
    mail.text = Format("I just heard the news that %1% is no more."%_T, faction.baseName)

    for _, player in pairs({server:getPlayers()}) do
        mail.receiver = player.id
        player:addMail(mail)
    end
end

return FactionEconomyUtility
