

local EventUT = {}

function EventUT.attackEventAllowed()
    local sector = Sector()

    if sector:getValue("neutral_zone") then
        -- print ("No attack events in neutral zones.")
        return false
    end

    local players = {sector:getPlayers()}
    if #players == 0 then
        -- print ("No attack events in sectors without players")
        return false
    end

    for _, player in pairs(players) do
        local hx, hy = player:getHomeSectorCoordinates()
        if hx == x and hy == y and player.playtime < 30 * 60 then
            -- print ("Player's playtime is below 30 minutes (%is), cancelling pirate attack.", player.playtime)
            return false
        end
    end

    if sector:getEntitiesByScriptValue("no_attack_events") then
        -- print ("an entity prevented an attack")
        return false
    end

    return true
end

return EventUT
