
package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include ("utility")
include ("faction")
include ("productions")
include ("stationextensions")
include ("callable")
include ("relations")
include ("reconstructiontoken")
include("randomext")
local SectorSpecifics = include ("sectorspecifics")
local SectorGenerator = include ("SectorGenerator")
local AsteroidFieldGenerator = include ("asteroidfieldgenerator")
local ShipUtility = include ("shiputility")
local SpawnUtility = include ("spawnutility")
local SectorTurretGenerator = include ("sectorturretgenerator")
local UpgradeGenerator = include ("upgradegenerator")
local PirateGenerator = include ("pirategenerator")
local Rewards = include ("rewards")
local Scientist = include ("story/scientist")
local The4 = include ("story/the4")
local Smuggler = include ("story/smuggler")
local Placer = include ("placer")
local Xsotan = include ("story/xsotan")
local AdventurerGuide = include("story/adventurerguide")
local OperationExodus = include("story/operationexodus")
local AsyncPirateGenerator = include("asyncpirategenerator")
local AsyncShipGenerator = include("asyncshipgenerator")
local FighterGenerator = include("fightergenerator")
local TorpedoGenerator = include("torpedogenerator")
local Scientist = include ("story/scientist")
local SectorFighterGenerator = include("sectorfightergenerator")
local AsteroidShieldBoss = include("data/scripts/player/events/spawnasteroidboss")
local JumperBoss = include("data/scripts/player/events/spawnjumperboss.lua")
local LaserBoss = include("data/scripts/player/events/spawnlaserboss.lua")
local BigAI = include("data/scripts/player/events/spawnbigai")
local BigAICorrupted = include("data/scripts/player/events/spawnbigaicorrupted")
include("weapontype")
include("turretbalancinganalysis")


local window
local scriptsWindow
local scriptList
local scripts
local addScriptButton
local removeScriptButton
local templateButtons
local factoryButtons

local WeaponTypes =
{
    {type = WeaponType.ChainGun, name = "Chain Guns"},
    {type = WeaponType.PointDefenseChainGun, name = "PDCs"},
    {type = WeaponType.PointDefenseLaser, name = "PDLs"},
    {type = WeaponType.Laser, name = "Lasers"},
    {type = WeaponType.MiningLaser, name = "Mining Lasers"},
    {type = WeaponType.RawMiningLaser, name = "Raw Mining Lasers"},
    {type = WeaponType.SalvagingLaser, name = "Salvage Lasers"},
    {type = WeaponType.RawSalvagingLaser, name = "Raw Salvage Lasers"},
    {type = WeaponType.PlasmaGun, name = "Plasma Guns"},
    {type = WeaponType.RocketLauncher, name = "Rocket Launchers"},
    {type = WeaponType.Cannon, name = "Cannons"},
    {type = WeaponType.RailGun, name = "Railguns"},
    {type = WeaponType.RepairBeam, name = "Repair Beams"},
    {type = WeaponType.Bolter, name = "Bolters"},
    {type = WeaponType.LightningGun, name = "Lightning Guns"},
    {type = WeaponType.TeslaGun, name = "Tesla Guns"},
    {type = WeaponType.ForceGun, name = "Force Guns"},
    {type = WeaponType.PulseCannon, name = "Pulse Cannons"},
    {type = WeaponType.AntiFighter, name = "Anti-Fighter Cannons"},
}

local numButtons = 0
function ButtonRect(w, h, p)

    local width = w or 280
    local height = h or 35
    local padding = p or 10

    local space = math.floor((window.size.y - 60) / (height + padding))

    local row = math.floor(numButtons % space)
    local col = math.floor(numButtons / space)

    local lower = vec2((width + padding) * col, (height + padding) * row)
    local upper = lower + vec2(width, height)

    numButtons = numButtons + 1

    return Rect(lower, upper)
end

function interactionPossible(player)
    return true, ""
end

function initialize()

end

function onShowWindow()
    scriptsWindow:hide()
    valuesWindow:hide()
end

function onCloseWindow()
    scriptsWindow:hide()
    valuesWindow:hide()
end

function initUI()

    local res = getResolution()
    local size = vec2(1200, 650)

    local menu = ScriptUI()
    window = menu:createWindow(Rect(res * 0.5 - size * 0.5, res * 0.5 + size * 0.5))

    window.caption = "Debug"
    window.showCloseButton = 1
    window.moveable = 1
    menu:registerWindow(window, "~dev");

    -- create a tabbed window inside the main window
    local tabbedWindow = window:createTabbedWindow(Rect(vec2(10, 10), size - 10))

    local tab = tabbedWindow:createTab("Entity", "data/textures/icons/ship.png", "Ship Commands")
    numButtons = 0
    tab:createButton(ButtonRect(), "GoTo", "onGoToButtonPressed")
    tab:createButton(ButtonRect(), "Entity Scripts", "onEntityScriptsButtonPressed")
    tab:createButton(ButtonRect(), "Entity Values", "onEntityValuesButtonPressed")
    tab:createButton(ButtonRect(), "Faction Values", "onFactionValuesButtonPressed")
    tab:createButton(ButtonRect(), "Spawn Ship", "onCreateShipsButtonPressed")
    tab:createButton(ButtonRect(), "Spawn Ship Copy", "onCreateShipCopyButtonPressed")
    tab:createButton(ButtonRect(), "Fly", "onFlyButtonPressed")
    tab:createButton(ButtonRect(), "Own", "onOwnButtonPressed")
    tab:createButton(ButtonRect(), "Own Alliance", "onOwnAllianceButtonPressed")
    tab:createButton(ButtonRect(), "Own Locals", "onOwnLocalsButtonPressed")
    tab:createButton(ButtonRect(), "Destroy", "onDestroyButtonPressed")
    tab:createButton(ButtonRect(), "Delete", "onDeleteButtonPressed")
    tab:createButton(ButtonRect(), "Toggle Invincible", "onInvincibleButtonPressed")
    tab:createButton(ButtonRect(), "Toggle Shield Invincible", "onShieldInvincibleButtonPressed")
    tab:createButton(ButtonRect(), "Insta-Board", "onInstaBoardButtonPressed")

    tab:createButton(ButtonRect(), "War", "onWarPressed")
    tab:createButton(ButtonRect(), "Ceasefire", "onCeasefirePressed")
    tab:createButton(ButtonRect(), "Neutral", "onNeutralPressed")
    tab:createButton(ButtonRect(), "Ally", "onAllyPressed")
    tab:createButton(ButtonRect(), "Like", "onLikePressed")
    tab:createButton(ButtonRect(), "Dislike", "onDislikePressed")
    tab:createButton(ButtonRect(), "Damage", "onDamagePressed")
    tab:createButton(ButtonRect(), "Title", "onTitlePressed")
    tab:createButton(ButtonRect(), "Faction Index", "onFactionIndexPressed")
    tab:createButton(ButtonRect(), "Speech Bubble", "onSpeechBubbleButtonPressed")
    tab:createButton(ButtonRect(), "Speech Bubble Spam", "onSpeechBubbleSpamButtonPressed")
    tab:createButton(ButtonRect(), "Speech Bubble Dialog", "onSpeechBubbleDialogButtonPressed")


    local tab = tabbedWindow:createTab("Entity", "data/textures/icons/fighter.png", "Equipment Commands")
    numButtons = 0

    tab:createButton(ButtonRect(), "Add Crew", "onAddCrewButtonPressed")
    tab:createButton(ButtonRect(), "Clear Crew", "onClearCrewButtonPressed")
    tab:createButton(ButtonRect(), "Clear Cargo", "onClearCargoButtonPressed")

    tab:createButton(ButtonRect(), "Add Pilots", "onAddPilotsPressed")
    tab:createButton(ButtonRect(), "Add Security", "onAddSecurityPressed")
    tab:createButton(ButtonRect(), "Add Boarders", "onAddBoardersPressed")

    tab:createButton(ButtonRect(), "Armed Fighters", "onAddArmedFightersButtonPressed")
    tab:createButton(ButtonRect(), "Repair Fighters", "onAddRepairFightersButtonPressed")
    tab:createButton(ButtonRect(), "Mining Fighters", "onAddMiningFightersButtonPressed")
    tab:createButton(ButtonRect(), "Raw Mining Fighters", "onAddRawMiningFightersButtonPressed")
    tab:createButton(ButtonRect(), "Salvaging Fighters", "onAddSalvagingFightersButtonPressed")
    tab:createButton(ButtonRect(), "Raw Salvaging Fighters", "onAddRawSalvagingFightersButtonPressed")
    tab:createButton(ButtonRect(), "Cargo Shuttles", "onAddCargoShuttlesButtonPressed")
    tab:createButton(ButtonRect(), "Crew Shuttles", "onAddCrewShuttlesButtonPressed")
    tab:createButton(ButtonRect(), "Clear Hangar", "onClearHangarButtonPressed")

    tab:createButton(ButtonRect(), "Add Torpedoes", "onAddTorpedoesButtonPressed")
    tab:createButton(ButtonRect(), "Clear Torpedoes", "onClearTorpedoesButtonPressed")

    tab:createButton(ButtonRect(), "Start Fighter", "onStartFighterButtonPressed")

    tab:createButton(ButtonRect(), "Default Shield", "onAddResiDefaultButtonPressed")
    tab:createButton(ButtonRect(), "Add Physical Resistance", "onAddResiPhysicalButtonPressed")
    tab:createButton(ButtonRect(), "Add Plasma Resistance", "onAddResiPlasmaButtonPressed")
    tab:createButton(ButtonRect(), "Add Electric Resistance", "onAddResiElectricButtonPressed")
    tab:createButton(ButtonRect(), "Add AntiMatter Resistance", "onAddResiAntiMatterButtonPressed")

    tab:createButton(ButtonRect(), "Reset Weakness", "onResetWeaknessButtonPressed")
    tab:createButton(ButtonRect(), "Add Energy Weakness", "onAddEnergyWeaknessButtonPressed")
    tab:createButton(ButtonRect(), "Add Plasma Weakness", "onAddPlasmaWeaknessButtonPressed")
    tab:createButton(ButtonRect(), "Add Electric Weakness", "onAddElectricWeaknessButtonPressed")
    tab:createButton(ButtonRect(), "Add AntiMatter Weakness", "onAddAntiMatterWeaknessButtonPressed")

    local tab = tabbedWindow:createTab("", "data/textures/icons/player.png", "Player Commands")
    numButtons = 0
    tab:createButton(ButtonRect(), "Player Scripts", "onPlayerScriptsButtonPressed")
    tab:createButton(ButtonRect(), "Player Values", "onPlayerValuesButtonPressed")
    tab:createButton(ButtonRect(), "Cleanup Map", "onClearUnknownSectorsButtonPressed")
    tab:createButton(ButtonRect(), "Disable Events", "onDisableEventsButtonPressed")
    tab:createButton(ButtonRect(), "Clear Inventory", "onClearInventoryButtonPressed")
    tab:createButton(ButtonRect(), "Reset Money", "onResetMoneyButtonPressed")
    tab:createButton(ButtonRect(), "Guns Guns Guns", "onGunsButtonPressed")
    tab:createButton(ButtonRect(), "CoAx Guns Guns Guns", "onCoaxialGunsButtonPressed")
    tab:createButton(ButtonRect(), "Gimme Systems", "onSystemsButtonPressed")
    tab:createButton(ButtonRect(), "Energy Suppressor", "onEnergySuppressorButtonPressed")
    tab:createButton(ButtonRect(), "Chat Greetings", "onLanguageGreetingsButtonPressed")



    local tab = tabbedWindow:createTab("Turrets", "data/textures/icons/turret.png", "Turrets")
    numButtons = 0
    tab:createButton(ButtonRect(), "Clear Inventory", "onClearInventoryButtonPressed")

    for _, wp in pairs(WeaponTypes) do
        local button = tab:createButton(ButtonRect(), wp.name, "onGiveWeaponsButtonPressed")
        wp.buttonIndex = button.index
    end



    local tab = tabbedWindow:createTab("Upgrades", "data/textures/icons/circuitry.png", "Upgrades")
    numButtons = 0

    tab:createButton(ButtonRect(), "Clear Inventory", "onClearInventoryButtonPressed")
    tab:createButton(ButtonRect(), "Mission Upgrades", "onKeysButtonPressed")
    tab:createButton(ButtonRect(), "Reconstruction Token", "onReconstructionTokenButtonPressed")
    tab:createButton(ButtonRect(), "Empty Reconstruction Token", "onEmptyReconstructionTokenButtonPressed")
    tab:createButton(ButtonRect(), "Reinforcements Transmitter", "onReinforcementsCallerItemButtonPressed")
    tab:createButton(ButtonRect(), "Merchant Caller", "onMerchantCallerItemButtonPressed")
    tab:createButton(ButtonRect(), "Jumper Caller", "onJumperCallerItemButtonPressed")
    tab:createButton(ButtonRect(), "AI Map", "onAIMapItemButtonPressed")
    tab:createButton(ButtonRect(), "Corrupted AI Map", "onCorruptedAIMapItemButtonPressed")

    systemButtons = {}
    for script, _ in pairs(UpgradeGenerator().scripts) do
        local name = script:split("/")[4]:split(".")[1]
        local button = tab:createButton(ButtonRect(), name, "onSystemUpgradeButtonPressed")
        table.insert(systemButtons, {button = button, script = script});
    end

    local tab = tabbedWindow:createTab("Sector", "data/textures/icons/sector.png", "Sector Commands")
    numButtons = 0
    tab:createButton(ButtonRect(), "Sector Scripts", "onSectorScriptsButtonPressed")
    tab:createButton(ButtonRect(), "Sector Values", "onSectorValuesButtonPressed")
    tab:createButton(ButtonRect(), "Server Values", "onServerValuesButtonPressed")
    tab:createButton(ButtonRect(), "Clear Sector", "onClearButtonPressed")
    tab:createButton(ButtonRect(), "Clear Fighters", "onClearFightersButtonPressed")
    tab:createButton(ButtonRect(), "Clear Torpedos", "onClearTorpedosButtonPressed")
    tab:createButton(ButtonRect(), "Infect Asteroids", "onInfectAsteroidsButtonPressed")
    tab:createButton(ButtonRect(), "Align", "onAlignButtonPressed")
    tab:createButton(ButtonRect(), "Condense Entities", "onCondenseSectorButtonPressed")
    tab:createButton(ButtonRect(), "Resolve Intersections", "onResolveIntersectionsButtonPressed")
    tab:createButton(ButtonRect(), "Respawn Asteroids", "onRespawnAsteroidsButtonPressed")
    tab:createButton(ButtonRect(), "Touch all Objects", "onTouchAllObjectsButtonPressed")
    tab:createButton(ButtonRect(), "Touch all Objects [Client]", "onTouchAllObjectsOnClientButtonPressed")
    tab:createButton(ButtonRect(), "Custom Sector Name", "onCustomSectorNameButtonPressed")


    local tab = tabbedWindow:createTab("Spawn", "data/textures/icons/slow-blob.png", "Spawn")
    numButtons = 0
    tab:createButton(ButtonRect(), "Infected Asteroid", "onCreateInfectedAsteroidPressed")
    tab:createButton(ButtonRect(), "Big Infected Asteroid", "onCreateBigInfectedAsteroidPressed")
    tab:createButton(ButtonRect(), "Claimable Wreckage", "onCreateClaimableWreckagePressed")
    tab:createButton(ButtonRect(), "Claimable Asteroid", "onCreateOwnableAsteroidPressed")
    tab:createButton(ButtonRect(), "Adventurer", "onCreateAdventurerPressed")
    tab:createButton(ButtonRect(), "Travelling Merchant", "onCreateMerchantPressed")
    tab:createButton(ButtonRect(), "Wreckage", "onCreateWreckagePressed")
    tab:createButton(ButtonRect(), "Big Asteroid", "onCreateBigAsteroidButtonPressed")
    tab:createButton(ButtonRect(), "Asteroid Field", "onCreateAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Empty Asteroid Field", "onCreateEmptyAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Rich Asteroid Field", "onCreateRichAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Asteroid Field With Tinies", "onCreateAsteroidFieldWithTinyAsteroidsButtonPressed")
    tab:createButton(ButtonRect(), "Spiral Asteroid Field", "onCreateSpiralAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Ring Asteroid Field", "onCreateRingAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Forest Asteroid Field", "onCreateForestAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Ball Asteroid Field", "onCreateBallAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Iron Asteroid Field", "onCreateIronAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Titanium Asteroid Field", "onCreateTitaniumAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Naonite Asteroid Field", "onCreateNaoniteAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Trinium Asteroid Field", "onCreateTriniumAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Xanion Asteroid Field", "onCreateXanionAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Ogonite Asteroid Field", "onCreateOgoniteAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Avorion Asteroid Field", "onCreateAvorionAsteroidFieldButtonPressed")
    tab:createButton(ButtonRect(), "Container Field", "onCreateContainerFieldButtonPressed")
    tab:createButton(ButtonRect(), "Resource Asteroid", "onCreateResourceAsteroidButtonPressed")
    tab:createButton(ButtonRect(), "Pirate", "onCreatePirateButtonPressed")
    tab:createButton(ButtonRect(), "Military Ship", "onSpawnMilitaryShipButtonPressed")
    tab:createButton(ButtonRect(), "Carrier", "onSpawnCarrierButtonPressed")
    tab:createButton(ButtonRect(), "Flagship", "onSpawnFlagshipButtonPressed")
    tab:createButton(ButtonRect(), "Persecutor", "onSpawnPersecutorButtonPressed")
    tab:createButton(ButtonRect(), "Blocker", "onSpawnBlockerButtonPressed")
    tab:createButton(ButtonRect(), "Disruptor", "onSpawnDisruptorButtonPressed")
    tab:createButton(ButtonRect(), "CIWS", "onSpawnCIWSButtonPressed")
    tab:createButton(ButtonRect(), "Torpedoboat", "onSpawnTorpedoBoatButtonPressed")
    tab:createButton(ButtonRect(), "Trader", "onSpawnTraderButtonPressed")
    tab:createButton(ButtonRect(), "Freighter", "onSpawnFreighterButtonPressed")
    tab:createButton(ButtonRect(), "Miner", "onSpawnMinerButtonPressed")
    tab:createButton(ButtonRect(), "Xsotan Squad", "onSpawnXsotanSquadButtonPressed")
    tab:createButton(ButtonRect(), "Xsotan Carrier", "onSpawnXsotanCarrierButtonPressed")
    tab:createButton(ButtonRect(), "Quantum Xsotan", "onSpawnQuantumXsotanButtonPressed")
    tab:createButton(ButtonRect(), "Xsotan Summoner", "onSpawnXsotanSummonerButtonPressed")
    tab:createButton(ButtonRect(), "Defenders", "onSpawnDefendersButtonPressed")
    tab:createButton(ButtonRect(), "Battle", "onSpawnBattleButtonPressed")
    tab:createButton(ButtonRect(), "Deferred Battle", "onSpawnDeferredBattleButtonPressed")
    tab:createButton(ButtonRect(), "Fleet", "onSpawnFleetButtonPressed")
    tab:createButton(ButtonRect(), "Raiders", "onPersecutorsButtonPressed")
    tab:createButton(ButtonRect(), "Crew Transport", "onCrewTransportButtonPressed")
    tab:createButton(ButtonRect(), "Beacon", "onCreateBeaconButtonPressed")
    tab:createButton(ButtonRect(), "Stash", "onCreateStashButtonPressed")
    tab:createButton(ButtonRect(), "Distri Group", "onCreateDistriButtonPressed")

    local tab = tabbedWindow:createTab("Spawn Stations", "data/textures/icons/station.png", "Spawn Station")
    numButtons = 0
    tab:createButton(ButtonRect(), "Resistance Outpost", "onCreateResistanceOutpostPressed")
    tab:createButton(ButtonRect(), "Smuggler's Market", "onCreateSmugglersMarketPressed")
    tab:createButton(ButtonRect(), "Headquarters", "onCreateHeadQuartersPressed")
    tab:createButton(ButtonRect(), "Research Station", "onCreateResearchStationPressed")
    tab:createButton(ButtonRect(), "Consumer", "onCreateConsumerButtonPressed")
    tab:createButton(ButtonRect(), "Shipyard", "onCreateShipyardButtonPressed")
    tab:createButton(ButtonRect(), "Repair Dock", "onCreateRepairDockButtonPressed")
    tab:createButton(ButtonRect(), "Equipment Dock", "onCreateEquipmentDockButtonPressed")
    tab:createButton(ButtonRect(), "Turret Merchant", "onCreateTurretMerchantButtonPressed")
    tab:createButton(ButtonRect(), "Turret Factory", "onCreateTurretFactoryButtonPressed")
    tab:createButton(ButtonRect(), "Turret Factory Supplier", "onCreateTurretFactorySupplierButtonPressed")
    tab:createButton(ButtonRect(), "Fighter Merchant", "onCreateFighterMerchantButtonPressed")
    tab:createButton(ButtonRect(), "Fighter Factory", "onCreateFighterFactoryButtonPressed")
    tab:createButton(ButtonRect(), "Torpedo Merchant", "onCreateTorpedoMerchantButtonPressed")
    tab:createButton(ButtonRect(), "Trading Post", "onCreateTradingPostButtonPressed")
    tab:createButton(ButtonRect(), "Planetary Trading Post", "onCreatePlanetaryTradingPostButtonPressed")
    tab:createButton(ButtonRect(), "Resource Depot", "onCreateResourceDepotButtonPressed")
    tab:createButton(ButtonRect(), "Scrapyard", "onCreateScrapyardButtonPressed")
    tab:createButton(ButtonRect(), "Military Outpost", "onCreateMilitaryOutpostPressed")


    local tab = tabbedWindow:createTab("Factory Spawn", "data/textures/icons/cog.png", "Spawn Factory")
    numButtons = 0

    factoryButtons = {}
    for i, production in pairs(productions) do
        local button = tab:createButton(ButtonRect(190, 20, 3), getTranslatedFactoryName(production, ""), "onGenerateFactoryButtonPressed")
        table.insert(factoryButtons, {button = button, production = production});
        button.maxTextSize = 10
    end

    local tab = tabbedWindow:createTab("Generate Sectors", "data/textures/icons/gears.png", "Generator Scripts")
    numButtons = 0

    local specs = SectorSpecifics(0, 0, Seed());
    specs:addTemplates()
    specs:addTemplate("startsector")

    templateButtons = {}
    for i, template in pairs(specs.templates) do
        local parts = template.path:split("/")
        local button = tab:createButton(ButtonRect(), parts[2], "onGenerateTemplateButtonPressed")
        table.insert(templateButtons, {button = button, template = template});
    end

    local tab = tabbedWindow:createTab("Music", "data/textures/icons/g-clef.png", "Music")
    numButtons = 0

    tab:createButton(ButtonRect(), "Stop Music", "onCancelMusicButtonPressed")

    local specs = SectorSpecifics(0, 0, Seed());
    specs:addTemplates()

    musicButtons = {}
    for i, template in pairs(specs.templates) do
        local parts = template.path:split("/")
        local button = tab:createButton(ButtonRect(), parts[2], "onSectorMusicButtonPressed")
        table.insert(musicButtons, {button = button, template = template});
    end

    local tab = tabbedWindow:createTab("Missions", "data/textures/icons/treasure-map.png", "Missions")
    numButtons = 0
    tab:createButton(ButtonRect(), "Distress Call", "onDistressCallButtonPressed")
    tab:createButton(ButtonRect(), "Fake Distress Call", "onFakeDistressCallButtonPressed")
    tab:createButton(ButtonRect(), "Pirate Attack", "onPirateAttackButtonPressed")
    tab:createButton(ButtonRect(), "Trader Attacked by Pirates", "onTraderAttackedByPiratesButtonPressed")
    tab:createButton(ButtonRect(), "Xsotan Attack", "onAlienAttackButtonPressed")
    tab:createButton(ButtonRect(), "Xsotan Swarm", "onXsotanSwarmButtonPressed")
    tab:createButton(ButtonRect(), "Cancel Xsotan Swarm", "onXsotanSwarmEndButtonPressed")
    tab:createButton(ButtonRect(), "Headhunter Attack", "onHeadhunterAttackButtonPressed")
    tab:createButton(ButtonRect(), "Search and Rescue Call", "onSearchAndRescueButtonPressed")
    tab:createButton(ButtonRect(), "Progress Brakers", "onProgressBrakersButtonPressed")
    tab:createButton(ButtonRect(), "Smuggler Retaliation", "onSmugglerRetaliationButtonPressed")
    tab:createButton(ButtonRect(), "Exodus Beacon", "onExodusBeaconButtonPressed")
    tab:createButton(ButtonRect(), "Exodus Corner Points", "onExodusPointsButtonPressed")
    tab:createButton(ButtonRect(), "Exodus Final Beacon", "onExodusFinalBeaconButtonPressed")
    tab:createButton(ButtonRect(), "Research Satellite", "onResearchSatelliteButtonPressed")
    tab:createButton(ButtonRect(), "Pirate Delivery", "onPirateDeliveryPressed")
    tab:createButton(ButtonRect(), "Boss: Swoks", "onSpawnSwoksButtonPressed")
    tab:createButton(ButtonRect(), "Boss: The AI", "onSpawnTheAIButtonPressed")
    tab:createButton(ButtonRect(), "Boss: BigAI", "onSpawnBigAIButtonPressed")
    tab:createButton(ButtonRect(), "Boss: Corrupted AI", "onSpawnBigAICorruptedButtonPressed")
    tab:createButton(ButtonRect(), "Boss: Smuggler", "onSpawnSmugglerButtonPressed")
    tab:createButton(ButtonRect(), "Boss: Scientist", "onSpawnScientistButtonPressed")
    tab:createButton(ButtonRect(), "Boss: The 4", "onSpawnThe4ButtonPressed")
    tab:createButton(ButtonRect(), "Boss: Guardian", "onSpawnGuardianButtonPressed")
    tab:createButton(ButtonRect(), "Boss: LaserBoss", "onSpawnLaserBossButtonPressed")
    tab:createButton(ButtonRect(), "Boss: AsteroidShield", "onAsteroidShieldBossPressed")
    tab:createButton(ButtonRect(), "Boss: Jumper", "onJumperBossPressed")


    local tab = tabbedWindow:createTab("Tutorials", "data/textures/icons/graduate-cap.png", "Tutorials")
    numButtons = 0
    tab:createButton(ButtonRect(), "R-Mining", "onRMiningButtonPressed")
    tab:createButton(ButtonRect(), "Torpedoes", "onTorpedoesButtonPressed")
    tab:createButton(ButtonRect(), "Fighter", "onFighterButtonPressed")
    tab:createButton(ButtonRect(), "FleetCommands", "onOrdersButtonPressed")
    tab:createButton(ButtonRect(), "Found Station", "onStationTutorialButtonPressed")
    tab:createButton(ButtonRect(), "Find Avorion", "onFindAvorionButtonPressed")
    tab:createButton(ButtonRect(), "Barrier", "onBarrierButtonPressed")
    tab:createButton(ButtonRect(), "Reach Center", "onReachCenterButtonPressed")
    tab:createButton(ButtonRect(), "Boarding", "onBoardingTutorialButtonPressed")
    tab:createButton(ButtonRect(), "Fighting", "onFightingTutorialButtonPressed")
    tab:createButton(ButtonRect(), "Trading", "onTradingTutorialButtonPressed")

    local tab = tabbedWindow:createTab("Waveencounters", "data/textures/icons/firing-ship.png", "Wave Encounters")
    numButtons = 0
    tab:createButton(ButtonRect(), "Fake Stash", "onFakeStashWavesPressed")
    tab:createButton(ButtonRect(), "Hidden Treasure", "onHiddenTreasurePressed")
    tab:createButton(ButtonRect(), "Mothership", "onMothershipWavesPressed")
    tab:createButton(ButtonRect(), "Ambush Preperation", "onAmbushPreperationPressed")
    tab:createButton(ButtonRect(), "Pirateasteroid", "onPirateAsteroidWavesPressed")
    tab:createButton(ButtonRect(), "Pirate Initiation", "onPirateInitiationPressed")
    tab:createButton(ButtonRect(), "Pirate King", "onPirateKingPressed")
    tab:createButton(ButtonRect(), "Pirate Meeting", "onPirateMeetingPressed")
    tab:createButton(ButtonRect(), "Pirateprovocation", "onPirateProvocationWavesPressed")
    tab:createButton(ButtonRect(), "Pirateshidingtreasure", "onPiratesHidingTreasurePressed")
    tab:createButton(ButtonRect(), "Piratestation", "onPiratestationWavesPressed")
    tab:createButton(ButtonRect(), "Treasure Hunt", "onTreasureHuntPressed")
    tab:createButton(ButtonRect(), "Pirate Traitor", "onPirateTraitorPressed")
    tab:createButton(ButtonRect(), "Wrackage", "onPiratesWreackagePressed")
    tab:createButton(ButtonRect(), "Trader Ambushed", "onTraderAmbushedPressed")

    local tab = tabbedWindow:createTab("Icons", "data/textures/icons/crate.png", "Cargo Commands")
    numButtons = 0
    local sortedGoods = {}
    for name, good in pairs(goods) do
        table.insert(sortedGoods, good)
    end

    stolenCargoCheckBox = tab:createCheckBox(Rect(vec2(150, 25)), "Stolen", "onStolenChecked")
    local organizer = UIOrganizer(Rect(tabbedWindow.size))

    organizer:placeElementTopRight(stolenCargoCheckBox)

    local button = tab:createButton(ButtonRect(40, 40), "C", "onClearCargoButtonPressed")
    button.tooltip = "Clear Cargo Bay"

    function goodsByName(a, b) return a.name < b.name end
    table.sort(sortedGoods, goodsByName)

    for _, good in pairs(sortedGoods) do
        local rect = ButtonRect(40, 40)

        rect.upper = rect.lower + vec2(rect.size.y, rect.size.y)

        local button = tab:createButton(rect, "", "onGoodsButtonPressed")
        button.icon = good.icon
        button.tooltip = good.name



--        local p = vec2(rect.upper.x, rect.lower.y + 5)

--        local label = tab:createLabel(p, name, 15)

    end



    local tab = tabbedWindow:createTab("Turret Analysis", "data/textures/icons/turret.png", "Turret Analysis")
    BuildTurretAnalysisUI(tab)

    local tab = tabbedWindow:createTab("Orientation", "data/textures/icons/swipe-y-right.png", "Orientation")
    numButtons = 0
    tab:createButton(ButtonRect(40), "+x", "onMoveXP")
    tab:createButton(ButtonRect(40), "+y", "onMoveYP")
    tab:createButton(ButtonRect(40), "+z", "onMoveZP")

    numButtons = 13
    tab:createButton(ButtonRect(40), "-x", "onMoveXN")
    tab:createButton(ButtonRect(40), "-y", "onMoveYN")
    tab:createButton(ButtonRect(40), "-z", "onMoveZN")

    numButtons = 13 * 3
    tab:createButton(ButtonRect(40), "-r", "onMoveRN")
    tab:createButton(ButtonRect(40), "-u", "onMoveUN")
    tab:createButton(ButtonRect(40), "-l", "onMoveLN")

    numButtons = 13 * 4
    tab:createButton(ButtonRect(40), "+r", "onMoveRP")
    tab:createButton(ButtonRect(40), "+u", "onMoveUP")
    tab:createButton(ButtonRect(40), "+l", "onMoveLP")

    numButtons = 4
    tab:createButton(ButtonRect(40), "", "onRotateXRight").icon = "data/textures/icons/swipe-x-up.png"
    tab:createButton(ButtonRect(40), "", "onRotateYRight").icon = "data/textures/icons/swipe-y-right.png"
    tab:createButton(ButtonRect(40), "", "onRotateZRight").icon = "data/textures/icons/swipe-z-right.png"

    numButtons = 4 + 14
    tab:createButton(ButtonRect(40), "R", "onResetRotation").tooltip = "Reset Rotation"

    numButtons = 4 + 26
    tab:createButton(ButtonRect(40), "", "onRotateXLeft").icon = "data/textures/icons/swipe-x-down.png"
    tab:createButton(ButtonRect(40), "", "onRotateYLeft").icon = "data/textures/icons/swipe-y-left.png"
    tab:createButton(ButtonRect(40), "", "onRotateZLeft").icon = "data/textures/icons/swipe-z-left.png"



    local tab = tabbedWindow:createTab("System", "data/textures/icons/bypass.png", "System")
    numButtons = 0
    tab:createButton(ButtonRect(), "Crash Script", "onCrashButtonPressed")
    tab:createButton(ButtonRect(), "Client Log", "onPrintClientLogButtonPressed")
    tab:createButton(ButtonRect(), "Server Log", "onPrintServerLogButtonPressed")
    tab:createButton(ButtonRect(), "Hint", "onHintButtonPressed")



    -- scripts window
    local size = vec2(800, 500)
    scriptsWindow = menu:createWindow(Rect(res * 0.5 - size * 0.5, res * 0.5 + size * 0.5))
    scriptsWindow.visible = false
    scriptsWindow.caption = "Scripts"
    scriptsWindow.showCloseButton = 1
    scriptsWindow.moveable = 1
    scriptsWindow.closeableWithEscape = 1

    local hsplit = UIHorizontalSplitter(Rect(vec2(0, 0), size), 10, 10, 0.5)
    hsplit.bottomSize = 80

    scriptList = scriptsWindow:createListBox(hsplit.top)

    local hsplit = UIHorizontalSplitter(hsplit.bottom, 10, 0, 0.5)
    hsplit.bottomSize = 35

    scriptTextBox = scriptsWindow:createTextBox(hsplit.top, "")

    local vsplit = UIVerticalSplitter(hsplit.bottom, 10, 0, 0.5)

    addScriptButton = scriptsWindow:createButton(vsplit.left, "Add", "")
    removeScriptButton = scriptsWindow:createButton(vsplit.right, "Remove", "")


    -- values window
    local size = vec2(1000, 700)
    valuesWindow = menu:createWindow(Rect(res * 0.5 - size * 0.5, res * 0.5 + size * 0.5))
    valuesWindow.visible = false
    valuesWindow.caption = "Values"
    valuesWindow.showCloseButton = 1
    valuesWindow.moveable = 1
    valuesWindow.closeableWithEscape = 1

    valuesLines = {}

    local horizontal = 2
    local vertical = 19

    local vsplit = UIVerticalMultiSplitter(Rect(size), 5, 0, horizontal - 1)


    local previous = nil
    for x = 1, horizontal do
        local hsplit = UIHorizontalMultiSplitter(vsplit:partition(x - 1), 5, 10, vertical - 1)

        for y = 1, vertical do
            local vsplit = UIVerticalSplitter(hsplit:partition(y - 1), 5, 0, 0.5)

            local vsplit2 = UIVerticalSplitter(vsplit.right, 5, 0, 0.5)
            local vsplit3 = UIVerticalSplitter(vsplit2.right, 5, 0, 0.5)


            local key = valuesWindow:createTextBox(vsplit.left, "")
            local value = valuesWindow:createTextBox(vsplit2.left, "")

            local set = valuesWindow:createButton(vsplit3.left, "set", "onSetValuePressed")
            local delete = valuesWindow:createButton(vsplit3.right, "X", "onDeleteValuePressed")

            key.tabTarget = value

            if previous then previous.tabTarget = key end
            previous = value

            table.insert(valuesLines, {key = key, value = value, set = set, delete = delete})
        end
    end

end

--[[
function updateClient()
    if not docks then
        syncDocks()
    else
        for _, dock in pairs(docks) do
            dock = Entity().position:transformCoord(dock)
            drawDebugSphere(Sphere(dock, 1), ColorRGB(1, 1, 0))
        end
    end

    local ownDocks = {Entity():getDockingPositions()}
    for _, dock in pairs(ownDocks) do
        dock = Entity().position:transformCoord(dock)
        --drawDebugSphere(Sphere(dock, 3), ColorRGB(1, 0, 0))
    end

end
--]]

function syncDocks(docks_in)
    if onClient() then
        if docks_in then
            docks = docks_in
        else
            invokeServerFunction("syncDocks")
        end
    else
        local docks = {Entity():getDockingPositions()}
        invokeClientFunction(Player(callingPlayer), "syncDocks", docks)
    end
end

function onGenerateFactoryButtonPressed(arg)
    if onClient() then
        local button = arg
        for _, p in pairs(factoryButtons) do
            if button.index == p.button.index then
                invokeServerFunction("onGenerateFactoryButtonPressed", p.production)
                break
            end
        end

        return
    end
    local production = arg
    print (production.index)
    print (production.results[1].name)

    if Entity().isStation then
        Entity():removeScript("merchants/factory.lua")
        Entity():addScript("data/scripts/entity/merchants/factory.lua", production.results[1].name)
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction)
    station.position = Matrix()
    station:addScript("data/scripts/entity/merchants/factory.lua", production.results[1].name)

    Placer.resolveIntersections()
end

local function make_set(array)
    array = array or {}
    local set = {}

    for _, element in pairs(array) do
        set[element] = true
    end

    return set
end

function onCancelMusicButtonPressed(arg)
    Music():setAmbientTrackLists({}, {})
end

function onSectorMusicButtonPressed(arg)
    local button = arg
    for _, p in pairs(musicButtons) do
        if button.index == p.button.index then

            local good, neutral, bad = p.template.musicTracks()

            local chosen = good or {}
            local primary = make_set(chosen.primary)
            local secondary = make_set(chosen.secondary)

            -- actually set the tracks for playing
            local ptracks = {}
            local stracks = {}

            for id, _ in pairs(primary) do
                table.insert(ptracks, Tracks[id].path)
            end

            for id, _ in pairs(secondary) do
                table.insert(stracks, Tracks[id].path)
            end

            Music():setAmbientTrackLists(ptracks, stracks)
            Music():setAmbientTrackLists(ptracks, {})
            break
        end
    end
end

function onGenerateTemplateButtonPressed(arg)

    if onClient() then
        local button = arg
        for _, p in pairs(templateButtons) do
            if button.index == p.button.index then
                invokeServerFunction("onGenerateTemplateButtonPressed", p.template.path)
                break
            end
        end

        return
    end

    print("generating sector: " .. arg)

    -- clear sector except for player's entities
    local sector = Sector()
    for _, entity in pairs({sector:getEntities()}) do

        if entity.factionIndex == nil or entity.factionIndex ~= Entity().factionIndex then
            sector:deleteEntity(entity)
        end
    end

    sector:collectGarbage()

    local specs = SectorSpecifics(0, 0, Seed());
    specs:addTemplates()
    specs:addTemplate("startsector")

    local path = arg
    for _, template in pairs(specs.templates) do
        if path == template.path then
            template.generate(Faction(), sector.seed, sector:getCoordinates())
            return
        end
    end

end

function onSmugglerRetaliationButtonPressed()

    if onClient() then
        invokeServerFunction("onSmugglerRetaliationButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:setValue("smuggler_letter", nil)

    player:removeScript("story/smugglerretaliation.lua")
    player:removeScript("story/smugglerdelivery.lua")
    player:removeScript("story/smugglerletter.lua")

    player:addScriptOnce("story/smugglerletter.lua")

end

function onExodusBeaconButtonPressed()

    if onClient() then
        invokeServerFunction("onExodusBeaconButtonPressed")
        return
    end

    OperationExodus.generateBeacon(SectorGenerator(Sector():getCoordinates()))
end

function onExodusPointsButtonPressed()
    if onClient() then
        invokeServerFunction("onExodusPointsButtonPressed")
        return
    end

    local str = "Points: "
    for _, point in pairs(OperationExodus.getCornerPoints()) do
        str = str .. "\\s(${x}, ${y})  " % point
    end

    Player(callingPlayer):sendChatMessage("", 0, str)
end

function onExodusFinalBeaconButtonPressed()
    if onClient() then
        invokeServerFunction("onExodusFinalBeaconButtonPressed")
        return
    end

    local beacon = SectorGenerator(Sector():getCoordinates()):createBeacon(nil, nil, "")
    beacon:removeScript("data/scripts/entity/beacon.lua")
    beacon:addScript("story/exodustalkbeacon.lua")
end

function onResearchSatelliteButtonPressed()
    if onClient() then
        invokeServerFunction("onResearchSatelliteButtonPressed")
        return
    end

    -- if not, create a new one
    Scientist.createSatellite(Matrix())
end

function onDistressCallButtonPressed()
    if onClient() then
        invokeServerFunction("onDistressCallButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:addScript("events/convoidistresssignal.lua", true)
end

function onFakeDistressCallButtonPressed()
    if onClient() then
        invokeServerFunction("onFakeDistressCallButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:addScript("events/fakedistresssignal.lua", true)
end

function onPirateAttackButtonPressed()
    if onClient() then
        invokeServerFunction("onPirateAttackButtonPressed")
        return
    end

    Sector():addScript("pirateattack.lua")
end

function onXsotanSwarmButtonPressed()
    if onClient() then
        invokeServerFunction("onXsotanSwarmButtonPressed")
        return
    end

    local server = Server()
    server:setValue("xsotan_swarm_active", true)
    server:setValue("xsotan_swarm_duration", 30 * 60)
    server:setValue("xsotan_swarm_time", nil)
    server:setValue("xsotan_swarm_success", nil)
    server:setValue("guardian_respawn_time", nil)


    Sector():removeScript("xsotanswarm.lua")
    Sector():addScript("xsotanswarm.lua")
end

function onXsotanSwarmEndButtonPressed()
    if onClient() then
        invokeServerFunction("onXsotanSwarmEndButtonPressed")
        return
    end

    local server = Server()
    server:setValue("xsotan_swarm_active", false)
    server:setValue("xsotan_swarm_duration", nil)
    server:setValue("xsotan_swarm_time", nil)
    server:setValue("xsotan_swarm_success", 0)
    server:setValue("guardian_respawn_time", 30 * 60)

end

function onTraderAttackedByPiratesButtonPressed()
    if onClient() then
        invokeServerFunction("onTraderAttackedByPiratesButtonPressed")
        return
    end

    Sector():addScript("traderattackedbypirates.lua")
end

function onAlienAttackButtonPressed()
    if onClient() then
        invokeServerFunction("onAlienAttackButtonPressed")
        return
    end

    Player():addScript("events/alienattack.lua")
end

function onHeadhunterAttackButtonPressed()
    if onClient() then
        invokeServerFunction("onHeadhunterAttackButtonPressed")
        return
    end

    Player():addScriptOnce("events/headhunter.lua")

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    Player():invokeFunction("events/headhunter.lua", "createEnemies", faction)

end

function onProgressBrakersButtonPressed()
    if onClient() then
        invokeServerFunction("onProgressBrakersButtonPressed")
        return
    end

    Sector():addScriptOnce("spawnpersecutors.lua")
    Sector():invokeFunction("spawnpersecutors", "update")
end

function onPersecutorsButtonPressed()
    if onClient() then
        invokeServerFunction("onPersecutorsButtonPressed")
        return
    end

    local generator = AsyncPirateGenerator()
    for i = 1, 3 do
        local dir = random():getDirection()
        local matrix = MatrixLookUpPosition(-dir, vec3(0,1,0), Entity().translationf + dir * 2000)

        generator:createRaider(matrix)
    end
end

local transportData

function onCrewTransportButtonPressed()
    if onClient() then
        invokeServerFunction("onCrewTransportButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    local playerShip = player.craft

    if not playerShip then return end

    local generator = AsyncShipGenerator(nil, finalizeCrewTransport)

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())

    local dir = random():getDirection()
    local position = MatrixLookUpPosition(-dir, random():getDirection(), dir * 3000)
    generator:createFreighterShip(faction, position)

    transportData = {}
    transportData.craft = playerShip.index
    transportData.crew = playerShip.minCrew
end

function finalizeCrewTransport(ship)
    transportData = transportData or {}

    ship:addScriptOnce("crewtransport.lua", transportData.craft or Uuid(), transportData.crew or Crew())

    transportData = nil
end


function onStolenChecked(index, checked)
end

function onAddCrewButtonPressed()
    if onClient() then
        invokeServerFunction("onAddCrewButtonPressed")
        return
    end

    local craft = Entity()

    craft.crew = craft.minCrew
    craft:addCrew(1, CrewMan(CrewProfessionType.Captain))
end

function onGoodsButtonPressed(button, stolen, amount)
    if onClient() then
        local amount = 1
        if Keyboard():keyPressed(KeyboardKey.LControl) then
            amount = 100
        end

        invokeServerFunction("onGoodsButtonPressed", button.tooltip, stolenCargoCheckBox.checked, amount)
        return
    end

    -- we're using the same argument name for both the button and the
    -- good's name, on client it's a button, on server it's a string
    local name = button

    local craft = Entity()
    local good = goods[name]:good()

    good.stolen = stolen

    for i = 1, 10 do
        craft:addCargo(good, amount)
    end
end

function onClearCargoButtonPressed()
    if onClient() then
        invokeServerFunction("onClearCargoButtonPressed")
        return
    end

    local ship = Entity()

    for cargo, amount in pairs(ship:getCargos()) do
        ship:removeCargo(cargo, amount)
    end

end

function onClearCrewButtonPressed()
    if onClient() then
        invokeServerFunction("onClearCrewButtonPressed")
        return
    end

    Entity().crew = Crew()
end

function onClearHangarButtonPressed()
    if onClient() then
        invokeServerFunction("onClearHangarButtonPressed")
        return
    end

    Hangar():clear()
end

function onClearTorpedoesButtonPressed()
    if onClient() then
        invokeServerFunction("onClearTorpedoesButtonPressed")
        return
    end

    TorpedoLauncher():clear()
end

function onStartFighterButtonPressed()
    if onClient() then
        invokeServerFunction("onStartFighterButtonPressed")
        return
    end

    local controller = FighterController()
    local fighter, error = controller:startFighter(0, nil);

    if error ~= 0 then
        print ("error starting fighter: " .. error)
        return
    end

    local station = Sector():getEntitiesByType(EntityType.Station)

    local ai = FighterAI(fighter.id)
    ai.ignoreMothershipOrders = true
    ai:setOrders(FighterOrders.FlyToLocation, station.id)

end


function onAddResiDefaultButtonPressed()

    if onClient() then
        invokeServerFunction("onAddResiDefaultButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local shield = Shield(entity.id)
    if not shield then return end

    shield:resetResistance()
end
callable(nil, "onAddResiDefaultButtonPressed")

function onAddResiPhysicalButtonPressed()

    if onClient() then
        invokeServerFunction("onAddResiPhysicalButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local shield = Shield(entity.id)
    if not shield then return end

    shield:setResistance(DamageType.Physical, 1)
end
callable(nil, "onAddResiPhysicalButtonPressed")

function onAddResiPlasmaButtonPressed()

    if onClient() then
        invokeServerFunction("onAddResiPlasmaButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local shield = Shield(entity.id)
    if not shield then return end

    shield:setResistance(DamageType.Plasma, 1)
end
callable(nil, "onAddResiPlasmaButtonPressed")


function onAddResiElectricButtonPressed()

    if onClient() then
        invokeServerFunction("onAddResiElectricButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local shield = Shield(entity.id)
    if not shield then return end

    shield:setResistance(DamageType.Electric, 1)
end
callable(nil, "onAddResiElectricButtonPressed")

function onAddResiAntiMatterButtonPressed()

    if onClient() then
        invokeServerFunction("onAddResiAntiMatterButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local shield = Shield(entity.id)
    if not shield then return end

    shield:setResistance(DamageType.AntiMatter, 1)
end
callable(nil, "onAddResiAntiMatterButtonPressed")

function onResetWeaknessButtonPressed()

    if onClient() then
        invokeServerFunction("onResetWeaknessButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local durability = Durability(entity.id)
    if not durability then return end

    durability:resetWeakness()
end
callable(nil, "onResetWeaknessButtonPressed")

function onAddEnergyWeaknessButtonPressed()

    if onClient() then
        invokeServerFunction("onAddEnergyWeaknessButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local durability = Durability(entity.id)
    if not durability then return end

    durability:setWeakness(DamageType.Energy, 1)
end
callable(nil, "onAddEnergyWeaknessButtonPressed")

function onAddPlasmaWeaknessButtonPressed()

    if onClient() then
        invokeServerFunction("onAddPlasmaWeaknessButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local durability = Durability(entity.id)
    if not durability then return end

    durability:setWeakness(DamageType.Plasma, 1)
end
callable(nil, "onAddPlasmaWeaknessButtonPressed")

function onAddElectricWeaknessButtonPressed()

    if onClient() then
        invokeServerFunction("onAddElectricWeaknessButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local durability = Durability(entity.id)
    if not durability then return end

    durability:setWeakness(DamageType.Electric, 1)
end
callable(nil, "onAddElectricWeaknessButtonPressed")

function onAddAntiMatterWeaknessButtonPressed()

    if onClient() then
        invokeServerFunction("onAddAntiMatterWeaknessButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end

    local durability = Durability(entity.id)
    if not durability then return end

    durability:setWeakness(DamageType.AntiMatter, 1)
end
callable(nil, "onAddAntiMatterWeaknessButtonPressed")

function onDestroyButtonPressed(destroyerId)
    if onClient() then
        invokeServerFunction("onDestroyButtonPressed", Player().craft.id)
        return
    end

    local craft = Entity()

    craft:destroy(destroyerId)
end

function onSpawnDefendersButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnDefendersButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local generator = AsyncShipGenerator()
    for i = -2, 2 do
        local pos = position - right * 500 + dir * i * 100
        generator:createDefender(faction, MatrixLookUpPosition(-dir, up, pos))
    end

end

local function getPositionInFrontOfPlayer()

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local pos = position + dir * 100

    return MatrixLookUpPosition(-dir, up, pos)
end

function makeDefender(craft)
    craft:addScript("ai/patrol")
end

function onSpawnMilitaryShipButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnMilitaryShipButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createMilitaryShip(faction, getPositionInFrontOfPlayer())

end

function onSpawnTorpedoBoatButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnTorpedoBoatButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createTorpedoShip(faction, getPositionInFrontOfPlayer())

end

function onSpawnCIWSButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnCIWSButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createCIWSShip(faction, getPositionInFrontOfPlayer())

end

function onSpawnDisruptorButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnDisruptorButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createDisruptorShip(faction, getPositionInFrontOfPlayer())

end

function onSpawnPersecutorButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnPersecutorButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createPersecutorShip(faction, getPositionInFrontOfPlayer())

end

function onSpawnBlockerButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnBlockerButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createBlockerShip(faction, getPositionInFrontOfPlayer())

end

function onSpawnFlagshipButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnFlagshipButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createFlagShip(faction, getPositionInFrontOfPlayer())

end

function onSpawnCarrierButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnCarrierButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local pos = position + dir * 100
    local generator = AsyncShipGenerator(nil, makeDefender)
    generator:createCarrier(faction, MatrixLookUpPosition(-dir, up, pos))

end

function onSpawnTraderButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnTraderButtonPressed")
        return
    end

    local sector = Sector()
    sector:addScriptOnce("traders.lua")

    sector:invokeFunction("traders.lua", "update", 61)

end

function onSpawnFreighterButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnFreighterButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local pos = position + dir * 100
    local generator = AsyncShipGenerator()
    generator:createFreighterShip(faction, MatrixLookUpPosition(-dir, up, pos))

end

function onSpawnMinerButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnMinerButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local pos = position + dir * 100
    local generator = AsyncShipGenerator()
    generator:createMiningShip(faction, MatrixLookUpPosition(-dir, up, pos))

end

function onSpawnXsotanSquadButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnXsotanSquadButtonPressed")
        return
    end

    local galaxy = Galaxy()

    local faction = Xsotan.getFaction()

    local player = Player()
    local others = Galaxy():getNearestFaction(Sector():getCoordinates())

    -- create the enemies
    local dir = normalize(vec3(getFloat(-1, 1), getFloat(-1, 1), getFloat(-1, 1)))
    local up = vec3(0, 1, 0)
    local right = normalize(cross(dir, up))
    local pos = dir * 1500

    local volumes = {
                {size=1, title="Xsotan Scout"%_t},
                {size=1, title="Xsotan Scout"%_t},
                {size=2, title="Xsotan Scout"%_t},
                {size=3, title="Xsotan Ship"%_t},
                {size=3, title="Xsotan Ship"%_t},
                {size=5, title="Big Xsotan Ship"%_t},
                {size=3, title="Xsotan Ship"%_t},
                {size=3, title="Xsotan Ship"%_t},
                {size=2, title="Xsotan Scout"%_t},
                {size=1, title="Xsotan Scout"%_t},
                {size=1, title="Xsotan Scout"%_t},
            }

    for _, p in pairs(volumes) do

        local enemy = Xsotan.createShip(MatrixLookUpPosition(-dir, up, pos), p.size)
        enemy.title = p.title

        local distance = enemy:getBoundingSphere().radius + 20

        pos = pos + right * distance

        enemy.translation = dvec3(pos.x, pos.y, pos.z)

        pos = pos + right * distance + 20

        -- patrol.lua takes care of setting aggressive
    end

end

function onSpawnXsotanCarrierButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnXsotanCarrierButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local pos = position + dir * 100
    Xsotan.createCarrier(MatrixLookUpPosition(-dir, up, pos))

end

function onSpawnQuantumXsotanButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnQuantumXsotanButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local pos = position + dir * 100
    Xsotan.createQuantum(MatrixLookUpPosition(right, up, pos))
end

function onSpawnXsotanSummonerButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnXsotanSummonerButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local pos = position + dir * 100
    Xsotan.createSummoner(MatrixLookUpPosition(right, up, pos))
end

function onSpawnBattleButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnBattleButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local pirates = Galaxy():getPirateFaction(Balancing_GetPirateLevel(x, y))
    local faction = Galaxy():getNearestFaction(x, y)

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local onGenerated = function(ships)
        for _, ship in pairs(ships) do
            ship:removeScript("entity/antismuggle.lua")
        end

        Placer.resolveIntersections(ships)
    end

    local generator = AsyncShipGenerator(nil, onGenerated)
    generator:startBatch()

    for i = -5, 5 do
        local pos = position + dir * 1500 + right * i * 100
        local ship
        if i >= -1 and i <= 1 then
            generator:createCarrier(pirates, MatrixLookUpPosition(-dir, up, pos))
        else
            generator:createDefender(pirates, MatrixLookUpPosition(-dir, up, pos))
        end
    end

    for i = -4, 4 do
        local pos = position + dir * 500 + right * i * 100
        local ship
        if i >= -1 and i <= 1 then
            generator:createCarrier(faction, MatrixLookUpPosition(dir, up, pos))
        else
            generator:createDefender(faction, MatrixLookUpPosition(dir, up, pos))
        end
    end

    generator:endBatch()
end

function onSpawnDeferredBattleButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnDeferredBattleButtonPressed")
        return
    end

    deferredCallback(15.0, "onSpawnBattleButtonPressed")
end


function onSpawnFleetButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnFleetButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()

    local pirates = Galaxy():getPirateFaction(Balancing_GetPirateLevel(x, y))
    local faction = Faction()

    local right = Entity().right
    local dir = Entity().look
    local up = Entity().up
    local position = Entity().translationf

    local onFinished = function(ship)
        local waypoints = {}
        for j = 0, 8 do
            local pos = position + random():getVector(-400, 400)
            table.insert(waypoints, pos)
        end

    end

    local generator = AsyncShipGenerator(nil, onFinished)
    for i = -3, 3 do
        local pos = position - right * 500 + dir * i * 100
        generator:createDefender(faction, MatrixLookUpPosition(-dir, up, pos))
    end

end

function prepareCleanUp()
    local safe =
    {
        cleanUp = cleanUp,
        initialize = initialize,
        interactionPossible = interactionPossible,
        onShowWindow = onShowWindow,
        onCloseWindow = onCloseWindow,
        initUI = initUI,
        update = update,
        updateServer = updateServer,
        updateClient = updateClient,
    }

    return safe
end

function cleanUp(safe)
    cleanUp = safe.cleanUp
    initialize = safe.initialize
    interactionPossible = safe.interactionPossible
    onShowWindow = safe.onShowWindow
    onCloseWindow = safe.onCloseWindow
    initUI = safe.initUI

    update = nil
    updateServer = nil
    updateClient = nil
    getUpdateInterval = nil
    secure = nil
    restore = nil
end

function onResolveIntersectionsButtonPressed()
    if onClient() then
        invokeServerFunction("onResolveIntersectionsButtonPressed")
        return
    end

    Placer.resolveIntersections()
end

function onCondenseSectorButtonPressed()
    if onClient() then
        invokeServerFunction("onCondenseSectorButtonPressed")
        Entity().position = Matrix()
        return
    end

    for _, entity in pairs({Sector():getEntitiesByComponent(ComponentType.Plan)}) do
        entity.position = Matrix()
    end

    Placer.resolveIntersections()
end

function onRespawnAsteroidsButtonPressed()
    if onClient() then
        invokeServerFunction("onRespawnAsteroidsButtonPressed")
        return
    end

    Sector():removeScript("background/respawnresourceasteroids.lua")
    Sector():addScriptOnce("background/respawnresourceasteroids.lua")
end

function onCustomSectorNameButtonPressed()
    if onClient() then
        invokeServerFunction("onCustomSectorNameButtonPressed")
        return
    end

    Sector().name = "Test Sector Name!"
end
callable(nil, "onCustomSectorNameButtonPressed")

function onTouchAllObjectsButtonPressed()
    if onClient() then
        invokeServerFunction("onTouchAllObjectsButtonPressed")
        return
    end

    for _, entity in pairs({Sector():getEntitiesByComponent(ComponentType.Physics)}) do
        local physics = Physics(entity.id)
        physics:applyImpulse(entity.translation, vec3(0, 1, 0), 10000)
    end

end

function onTouchAllObjectsOnClientButtonPressed()

    for _, entity in pairs({Sector():getEntitiesByComponent(ComponentType.Physics)}) do
        local physics = Physics(entity.id)
        physics:applyImpulse(entity.translation, vec3(0, 1, 0), 10000)
    end

end

function onSpawnSwoksButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnSwoksButtonPressed")
        return
    end

    local safe = prepareCleanUp()

    dofile("data/scripts/player/story/spawnrandombosses.lua")
    SpawnRandomBosses.spawnSwoks(Player(), Sector():getCoordinates())

    safe.cleanUp(safe)
end

function onSpawnTheAIButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnTheAIButtonPressed")
        return
    end

    local safe = prepareCleanUp()

    dofile("data/scripts/player/story/spawnrandombosses.lua")
    SpawnRandomBosses.spawnAI(Sector():getCoordinates())

    safe.cleanUp(safe)

end

function onSpawnBigAIButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnBigAIButtonPressed")
        return
    end

    local safe = prepareCleanUp()

--    dofile("data/scripts/entity/events/bigai.lua")
    BigAI.spawn(Sector():getCoordinates())

    safe.cleanUp(safe)

end
callable(nil, "onSpawnBigAIButtonPressed")

function onSpawnBigAICorruptedButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnBigAICorruptedButtonPressed")
        return
    end

    local safe = prepareCleanUp()

--    dofile("data/scripts/entity/events/bigai.lua")
    BigAICorrupted.spawn(Sector():getCoordinates())

    safe.cleanUp(safe)

end
callable(nil, "onSpawnBigAICorruptedButtonPressed")

function onSpawnSmugglerButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnSmugglerButtonPressed")
        return
    end

    Smuggler.spawn()
end

function onSpawnScientistButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnScientistButtonPressed")
        return
    end

    Scientist.spawn()
end

function onSpawnGuardianButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnGuardianButtonPressed")
        return
    end

    Xsotan.createGuardian()
    Placer.resolveIntersections()
end

function onSpawnLaserBossButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnLaserBossButtonPressed")
        return
    end

    LaserBoss.spawnBoss()
    Placer.resolveIntersections()
end

function onPirateDeliveryPressed()
    if onClient() then
        invokeServerFunction("onPirateDeliveryPressed")
        return
    end

    local player = Player(callingPlayer)
    player:removeScript("player/missions/piratedelivery.lua")
    player:addScript("player/missions/piratedelivery.lua")
end

function onRMiningButtonPressed()
    if onClient() then
        invokeServerFunction("onRMiningButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/rminingtutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/rminingtutorial.lua")
end

function onTorpedoesButtonPressed()
    if onClient() then
        invokeServerFunction("onTorpedoesButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/torpedoestutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/torpedoestutorial.lua")
end

function onFighterButtonPressed()
    if onClient() then
        invokeServerFunction("onFighterButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/fightertutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/fightertutorial.lua")
end

function onOrdersButtonPressed()
    if onClient() then
        invokeServerFunction("onOrdersButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/fleetcommandstutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/fleetcommandstutorial.lua")
end

function onStationTutorialButtonPressed()
    if onClient() then
        invokeServerFunction("onStationTutorialButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/foundstationtutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/foundstationtutorial.lua")
end

function onReachCenterButtonPressed()
    if onClient() then
        invokeServerFunction("onReachCenterButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/reachcentertutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/reachcentertutorial.lua")
end

function onBoardingTutorialButtonPressed()
    if onClient() then
        invokeServerFunction("onBoardingTutorialButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/boardingtutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/boardingtutorial.lua")
end
callable(nil, "onBoardingTutorialButtonPressed")

function onFightingTutorialButtonPressed()
    if onClient() then
        invokeServerFunction("onFightingTutorialButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/fightingtutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/fightingtutorial.lua")
end
callable(nil, "onFightingTutorialButtonPressed")

function onTradingTutorialButtonPressed()
    if onClient() then
        invokeServerFunction("onTradingTutorialButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/tradetutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/tradetutorial.lua")
end
callable(nil, "onTradingTutorialButtonPressed")

function onAsteroidShieldBossPressed()
    if onClient() then
        invokeServerFunction("onAsteroidShieldBossPressed")
        return
    end

    AsteroidShieldBoss.createBoss()
end

function onJumperBossPressed()
    if onClient() then
        invokeServerFunction("onJumperBossPressed")
        return
    end

    JumperBoss.spawnBoss()
end

function onFakeStashWavesPressed()
    if onClient() then
        invokeServerFunction("onFakeStashWavesPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/fakestashwaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/fakestashwaves.lua")
end

function onHiddenTreasurePressed()
    if onClient() then
        invokeServerFunction("onHiddenTreasurePressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/hiddentreasurewaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/hiddentreasurewaves.lua")
end

function onMothershipWavesPressed()
    if onClient() then
        invokeServerFunction("onMothershipWavesPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/mothershipwaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/mothershipwaves.lua")
end

function onAmbushPreperationPressed()
    if onClient() then
        invokeServerFunction("onAmbushPreperationPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/pirateambushpreparation.lua")
    Sector():addScript("data/scripts/events/waveencounters/pirateambushpreparation.lua")
end

function onPirateAsteroidWavesPressed()
    if onClient() then
        invokeServerFunction("onPirateAsteroidWavesPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/pirateasteroidwaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/pirateasteroidwaves.lua")
end

function onPirateInitiationPressed()
    if onClient() then
        invokeServerFunction("onPirateInitiationPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/pirateinitiation.lua")
    Sector():addScript("data/scripts/events/waveencounters/pirateinitiation.lua")
end

function onPirateKingPressed()
    if onClient() then
        invokeServerFunction("onPirateKingPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/pirateking.lua")
    Sector():addScript("data/scripts/events/waveencounters/pirateking.lua")
end

function onPirateMeetingPressed()
    if onClient() then
        invokeServerFunction("onPirateMeetingPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/piratemeeting.lua")
    Sector():addScript("data/scripts/events/waveencounters/piratemeeting.lua")
end

function onPirateProvocationWavesPressed()
    if onClient() then
        invokeServerFunction("onPirateProvocationWavesPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/pirateprovocation.lua")
    Sector():addScript("data/scripts/events/waveencounters/pirateprovocation.lua")
end

function onPiratesHidingTreasurePressed()
    if onClient() then
        invokeServerFunction("onPiratesHidingTreasurePressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/pirateshidingtreasures.lua")
    Sector():addScript("data/scripts/events/waveencounters/pirateshidingtreasures.lua")
end

function onPiratestationWavesPressed()
    if onClient() then
        invokeServerFunction("onPiratestationWavesPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/piratestationwaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/piratestationwaves.lua")
end

function onTreasureHuntPressed()
    if onClient() then
        invokeServerFunction("onTreasureHuntPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/piratestreasurehunt.lua")
    Sector():addScript("data/scripts/events/waveencounters/piratestreasurehunt.lua")
end

function onPirateTraitorPressed()
    if onClient() then
        invokeServerFunction("onPirateTraitorPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/piratetraitorwaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/piratetraitorwaves.lua")
end

function onPiratesWreackagePressed()
    if onClient() then
        invokeServerFunction("onPiratesWreackagePressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/piratewreckagewaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/piratewreckagewaves.lua")
end

function onTraderAmbushedPressed()
    if onClient() then
        invokeServerFunction("onTraderAmbushedPressed")
        return
    end

    Sector():removeScript("data/scripts/events/waveencounters/tradersambushedwaves.lua")
    Sector():addScript("data/scripts/events/waveencounters/tradersambushedwaves.lua")
end

function onFindAvorionButtonPressed()
    if onClient() then
        invokeServerFunction("onFindAvorionButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/findavoriontutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/findavoriontutorial.lua")
end

function onBarrierButtonPressed()
    if onClient() then
        invokeServerFunction("onBarrierButtonPressed")
        return
    end
    Player(callingPlayer):removeScript("data/scripts/player/missions/tutorials/barriertutorial.lua")
    Player(callingPlayer):addScript("data/scripts/player/missions/tutorials/barriertutorial.lua")
end

function onSearchAndRescueButtonPressed()
    if onClient() then
        invokeServerFunction("onSearchAndRescueButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:addScript("missions/searchandrescue/searchandrescue.lua")
end

function onSpawnThe4ButtonPressed()
    if onClient() then
        invokeServerFunction("onSpawnThe4ButtonPressed")
        return
    end

    The4.spawn(Sector():getCoordinates())
end

function onAlignButtonPressed()
    if onClient() then
        invokeServerFunction("onAlignButtonPressed")
        return
    end

    Placer.placeNextToEachOther(vec3(0, 0, 0), vec3(1, 0, 0), vec3(0, 1, 0), Sector():getEntitiesByComponent(ComponentType.Plan))
    Placer.resolveIntersections()
end

function onEntityScriptsButtonPressed()
    scriptList:clear()
    scripts = {}
    scriptsWindow:show()


    addScriptButton.onPressedFunction = "addEntityScript"
    removeScriptButton.onPressedFunction = "removeEntityScript"

    invokeServerFunction("sendEntityScripts", Player().index)
end

function addEntityScript(name)
    if onClient() then
        invokeServerFunction("addEntityScript", scriptTextBox.text)
        invokeServerFunction("sendEntityScripts", Player().index)
        return
    end

    print("add script " .. name )

    Entity():addScript(name)

end

function removeEntityScript(script)

    if onClient() then

        local entry = tonumber(scripts[scriptList.selected])
        if entry ~= nil then
            invokeServerFunction("removeEntityScript", entry)
            invokeServerFunction("sendEntityScripts", Player().index)
        end

        return
    end

    print("remove script " .. script)

    Entity():removeScript(tonumber(script))

    print("remove script done ")
end

function sendEntityScripts(playerIndex)
    invokeClientFunction(Player(playerIndex), "receiveScripts", Entity():getScripts())
end



function onSectorScriptsButtonPressed()
    scriptList:clear()
    scripts = {}
    scriptsWindow:show()

    addScriptButton.onPressedFunction = "addSectorScript"
    removeScriptButton.onPressedFunction = "removeSectorScript"

    invokeServerFunction("sendSectorScripts", Player().index)
end

function addSectorScript(name)

    if onClient() then
        invokeServerFunction("addSectorScript", scriptTextBox.text)
        invokeServerFunction("sendSectorScripts", Player().index)
        return
    end

    print("add sector script " .. name )

    Sector():addScript(name)

end

function removeSectorScript(script)

    if onClient() then

        local entry = tonumber(scripts[scriptList.selected])
        if entry ~= nil then
            invokeServerFunction("removeSectorScript", entry)
            invokeServerFunction("sendSectorScripts", Player().index)
        end

        return
    end

    print("remove script " .. script )

    Sector():removeScript(tonumber(script))

end

function sendSectorScripts(playerIndex)
    invokeClientFunction(Player(playerIndex), "receiveScripts", Sector():getScripts())
end


function onPlayerScriptsButtonPressed()
    scriptList:clear()
    scripts = {}
    scriptsWindow:show()

    addScriptButton.onPressedFunction = "addPlayerScript"
    removeScriptButton.onPressedFunction = "removePlayerScript"

    invokeServerFunction("sendPlayerScripts")
end

function addPlayerScript(name)

    if onClient() then
        invokeServerFunction("addPlayerScript", scriptTextBox.text)
        invokeServerFunction("sendPlayerScripts")
        return
    end

    print("adding player script " .. name )

    Player(callingPlayer):addScript(name)

end

function removePlayerScript(script)

    if onClient() then

        local entry = tonumber(scripts[scriptList.selected])
        if entry ~= nil then
            invokeServerFunction("removePlayerScript", entry)
            invokeServerFunction("sendPlayerScripts")
        end

        return
    end

    print("removing player script " .. script )

    Player(callingPlayer):removeScript(tonumber(script))

end

function sendPlayerScripts()
    invokeClientFunction(Player(callingPlayer), "receiveScripts", Player(callingPlayer):getScripts())
end





function receiveScripts(scripts_in)

    scriptList:clear()
    scripts = {}

    local c = 0
    for i, name in pairs(scripts_in) do
        scriptList:addEntry(string.format("[%i] %s", i, name))

        scripts[c] = i
        c = c + 1
    end
end

function syncValues(valueType_in, values_in)
    if onClient() then
        if not values_in then
            invokeServerFunction("syncValues", valueType_in)
        else
            valueType = valueType_in
            values = values_in

            fillValues()
        end
    else
        local values

        if valueType_in == 0 then
            values = Entity():getValues()
        elseif valueType_in == 1 then
            values = Sector():getValues()
        elseif valueType_in == 2 then
            values = Faction():getValues()
        elseif valueType_in == 3 then
            values = Player(callingPlayer):getValues()
        elseif valueType_in == 4 then
            values = Server():getValues()
        end

        invokeClientFunction(Player(callingPlayer), "syncValues", valueType_in, values)
    end
end

function setValue(tp, key, value)

    if tp == 0 then
        values = Entity():setValue(key, value)
    elseif tp == 1 then
        values = Sector():setValue(key, value)
    elseif tp == 2 then
        values = Faction():setValue(key, value)
    elseif tp == 3 then
        values = Player(callingPlayer):setValue(key, value)
    elseif tp == 4 then
        values = Server():setValue(key, value)
    end

    syncValues(tp)
end

function onEntityValuesButtonPressed()
    syncValues(0)
    valuesWindow:show()
end

function onSectorValuesButtonPressed()
    syncValues(1)
    valuesWindow:show()
end

function onFactionValuesButtonPressed()
    syncValues(2)
    valuesWindow:show()
end

function onPlayerValuesButtonPressed()
    syncValues(3)
    valuesWindow:show()
end

function onServerValuesButtonPressed()
    syncValues(4)
    valuesWindow:show()
end

function fillValues()
    for _, line in pairs(valuesLines) do
        line.key.text = ""
        line.value.text = ""
    end

    local sorted = {}

    for k, v in pairs(values) do
        table.insert(sorted, {k=k, v=v})
    end

    function comp(a, b) return a.k < b.k end
    table.sort(sorted, comp)


    local c = 1
    for _, p in pairs(sorted) do
        local line = valuesLines[c]

        line.key.text = p.k
        line.value.text = tostring(p.v)

        c = c + 1
    end

end

function onSetValuePressed(button)
    for _, line in pairs(valuesLines) do
        if line.set.index == button.index then
            local str = line.value.text
            local number = tonumber(str)

            if number then
                invokeServerFunction("setValue", valueType, line.key.text, number)
            elseif str == "true" then
                invokeServerFunction("setValue", valueType, line.key.text, true)
            elseif str == "false" then
                invokeServerFunction("setValue", valueType, line.key.text, false)
            else
                invokeServerFunction("setValue", valueType, line.key.text, str)
            end
        end
    end
end

function onDeleteValuePressed(button)
    for _, line in pairs(valuesLines) do
        if line.delete.index == button.index then
            invokeServerFunction("setValue", valueType, line.key.text, nil)
        end
    end
end


function onGiveWeaponsButtonPressed(arg)
    if onClient() then
        local button = arg
        for _, wp in pairs(WeaponTypes) do
            if wp.buttonIndex == button.index then
                invokeServerFunction("onGiveWeaponsButtonPressed", wp.type)
                break
            end
        end
        return
    end

    local player = Faction()
    local x, y = Sector():getCoordinates()
    local dps, tech = Balancing_GetSectorWeaponDPS(x, y)
    local weaponType = arg

    rarityCounter = (rarityCounter or 0) + 1
    if rarityCounter > 5 then rarityCounter = -1 end

    local turret = SectorTurretGenerator():generate(x, y, 0, Rarity(rarityCounter), weaponType)
    for j = 1, 20 do
        player:getInventory():addOrDrop(InventoryTurret(turret))
    end
end

function onQuestRewardButtonPressed(arg)
    if onClient() then
        invokeServerFunction("onQuestRewardButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())

    Rewards.standard(player, faction, nil, 12345, 500, true, true)
end

function onLanguageGreetingsButtonPressed(arg)
    displayChatMessage("Hallo", "Boxelware", 0)
    displayChatMessage("Hi", "Boxelware", 0)
    displayChatMessage("Привет", "Boxelware", 0)
    displayChatMessage("你好", "Boxelware", 0)
    displayChatMessage("Bonjour", "Boxelware", 0)
    displayChatMessage("こんにちは", "Boxelware", 0)
    displayChatMessage("Merhaba", "Boxelware", 0)
    displayChatMessage("Witam", "Boxelware", 0)
    displayChatMessage("Hola", "Boxelware", 0)
    displayChatMessage("Ciao", "Boxelware", 0)
    displayChatMessage("Olá", "Boxelware", 0)

end

function onKeysButtonPressed(arg)
    if onClient() then
        invokeServerFunction("onKeysButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey1.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey2.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey3.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey4.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey5.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey6.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey7.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/teleporterkey8.lua", Rarity(RarityType.Legendary), Seed(0)))

    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/wormholeopener.lua", Rarity(RarityType.Exotic), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/wormholeopener.lua", Rarity(RarityType.Exotic), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/wormholeopener.lua", Rarity(RarityType.Exotic), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/wormholeopener.lua", Rarity(RarityType.Exotic), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/wormholeopener.lua", Rarity(RarityType.Exotic), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/wormholeopener.lua", Rarity(RarityType.Legendary), Seed(0)))
    player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/smugglerblocker.lua", Rarity(RarityType.Exotic), Seed(0)))

    for i = 0, 3 do
        player:getInventory():addOrDrop(SystemUpgradeTemplate("data/scripts/systems/enginebooster.lua", Rarity(RarityType.Legendary), Seed(0)))
    end

end

function onReconstructionTokenButtonPressed()
    if onClient() then
        invokeServerFunction("onReconstructionTokenButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    local craft = player.craft
    if not craft then return end

    player:getInventory():addOrDrop(createReconstructionToken(craft))
end
callable(nil, "onReconstructionTokenButtonPressed")

function onEmptyReconstructionTokenButtonPressed()
    if onClient() then
        invokeServerFunction("onEmptyReconstructionTokenButtonPressed")
        return
    end

    local player = Player(callingPlayer)

    player:getInventory():addOrDrop(UsableInventoryItem("unbrandedreconstructiontoken.lua", Rarity(RarityType.Legendary)))
end
callable(nil, "onEmptyReconstructionTokenButtonPressed")

function onMerchantCallerItemButtonPressed()
    if onClient() then
        invokeServerFunction("onMerchantCallerItemButtonPressed")
        return
    end

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local player = Player(callingPlayer)

    player:getInventory():addOrDrop(UsableInventoryItem("equipmentmerchantcaller.lua", Rarity(RarityType.Exotic), faction.index))
end
callable(nil, "onMerchantCallerItemButtonPressed")

function onJumperCallerItemButtonPressed()
    if onClient() then
        invokeServerFunction("onJumperCallerItemButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:getInventory():addOrDrop(UsableInventoryItem("jumperbosscaller.lua", Rarity(RarityType.Legendary)))
end
callable(nil, "onJumperCallerItemButtonPressed")

function onAIMapItemButtonPressed()
    if onClient() then
        invokeServerFunction("onAIMapItemButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:getInventory():addOrDrop(UsableInventoryItem("aimap.lua", Rarity(RarityType.Legendary)))
end
callable(nil, "onAIMapItemButtonPressed")

function onCorruptedAIMapItemButtonPressed()
    if onClient() then
        invokeServerFunction("onCorruptedAIMapItemButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    player:getInventory():addOrDrop(UsableInventoryItem("corruptedaimap.lua", Rarity(RarityType.Legendary)))
end
callable(nil, "onCorruptedAIMapItemButtonPressed")


function onReinforcementsCallerItemButtonPressed()
    if onClient() then
        invokeServerFunction("onReinforcementsCallerItemButtonPressed")
        return
    end

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local player = Player(callingPlayer)

    player:getInventory():addOrDrop(UsableInventoryItem("reinforcementstransmitter.lua", Rarity(RarityType.Exotic), faction.index))
end
callable(nil, "onReinforcementsCallerItemButtonPressed")

function onDisableEventsButtonPressed(arg)

    if onClient() then
        invokeServerFunction("onDisableEventsButtonPressed")
        return
    end

    Player(callingPlayer):removeScript("events/eventscheduler.lua")
    Player(callingPlayer):removeScript("events/headhunter.lua")
    Player(callingPlayer):removeScript("events/alienattack.lua")

    Sector():removeScript("eventscheduler.lua")
    Sector():removeScript("pirateattack.lua")
end

function onClearUnknownSectorsButtonPressed(arg)

    if onClient() then
        invokeServerFunction("onClearUnknownSectorsButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    local yes = 0
    local no = 0

    for _, view in pairs({player:getKnownSectors()}) do
        local x, y = view:getCoordinates()
        if not view.visited then
            player:removeKnownSector(x, y)
            no = no + 1
        else
            yes = yes + 1
        end
    end

    print ("visited: %i", yes)
    print ("not visited: %i", no)

end
callable(nil, "onClearUnknownSectorsButtonPressed")

function onMoveXP()
    if onClient() then invokeServerFunction("onMoveXP") end

    local t = Entity().translation
    t.x = t.x + 10
    Entity().translation = t
end
callable(nil, "onMoveXP")

function onMoveYP()
    if onClient() then invokeServerFunction("onMoveYP") end

    local t = Entity().translation
    t.y = t.y + 10
    Entity().translation = t
end
callable(nil, "onMoveYP")

function onMoveZP()
    if onClient() then invokeServerFunction("onMoveZP") end

    local t = Entity().translation
    t.z = t.z + 10
    Entity().translation = t
end
callable(nil, "onMoveZP")

function onMoveXN()
    if onClient() then invokeServerFunction("onMoveXN") end

    local t = Entity().translation
    t.x = t.x - 10
    Entity().translation = t
end
callable(nil, "onMoveXN")

function onMoveYN()
    if onClient() then invokeServerFunction("onMoveYN") end

    local t = Entity().translation
    t.y = t.y - 10
    Entity().translation = t
end
callable(nil, "onMoveYN")

function onMoveZN()
    if onClient() then invokeServerFunction("onMoveZN") end

    local t = Entity().translation
    t.z = t.z - 10
    Entity().translation = t
end
callable(nil, "onMoveZN")



function onMoveRP()
    if onClient() then invokeServerFunction("onMoveRP") end

    local p = Entity().position
    local t = Entity().translationf
    t = t + (normalize(p.right) * 10)
    Entity().translation = dvec3(t.x, t.y, t.z)
end
callable(nil, "onMoveRP")

function onMoveRN()
    if onClient() then invokeServerFunction("onMoveRN") end

    local p = Entity().position
    local t = Entity().translationf
    t = t - (normalize(p.right) * 10)
    Entity().translation = dvec3(t.x, t.y, t.z)
end
callable(nil, "onMoveRN")

function onMoveUP()
    if onClient() then invokeServerFunction("onMoveUP") end

    local p = Entity().position
    local t = Entity().translationf
    t = t + (normalize(p.up) * 10)
    Entity().translation = dvec3(t.x, t.y, t.z)
end
callable(nil, "onMoveUP")

function onMoveLP()
    if onClient() then invokeServerFunction("onMoveLP") end

    local p = Entity().position
    local t = Entity().translationf
    t = t + (normalize(p.look) * 10)
    Entity().translation = dvec3(t.x, t.y, t.z)
end
callable(nil, "onMoveLP")


function onMoveUN()
    if onClient() then invokeServerFunction("onMoveUN") end

    local p = Entity().position
    local t = Entity().translationf
    t = t - (normalize(p.up) * 10)
    Entity().translation = dvec3(t.x, t.y, t.z)
end
callable(nil, "onMoveUN")

function onMoveLN()
    if onClient() then invokeServerFunction("onMoveLN") end

    local p = Entity().position
    local t = Entity().translationf
    t = t - (normalize(p.look) * 10)
    Entity().translation = dvec3(t.x, t.y, t.z)
end
callable(nil, "onMoveLN")

function rotate(dx, dy, dz)
    local p = Entity().position
    local x = (Entity():getValue("dbg_angle_x") or 0) + dx
    local y = (Entity():getValue("dbg_angle_y") or 0) + dy
    local z = (Entity():getValue("dbg_angle_z") or 0) + dz
    Entity():setValue("dbg_angle_x", x)
    Entity():setValue("dbg_angle_y", y)
    Entity():setValue("dbg_angle_z", z)

    local p2 = MatrixYawPitchRoll(x / 180 * math.pi, y / 180 * math.pi, z / 180 * math.pi)
    p2.position = p.position

    Entity().position = p2
end

function onRotateXLeft()
    if onClient() then
        invokeServerFunction("onRotateXLeft")
    end

    rotate(5, 0, 0)
end
callable(nil, "onRotateXLeft")

function onRotateXRight()
    if onClient() then
        invokeServerFunction("onRotateXRight")
    end

    rotate(-5, 0, 0)
end
callable(nil, "onRotateXRight")

function onRotateYLeft()
    if onClient() then
        invokeServerFunction("onRotateYLeft")
    end

    rotate(0, 5, 0)
end
callable(nil, "onRotateYLeft")

function onRotateYRight()
    if onClient() then
        invokeServerFunction("onRotateYRight")
    end

    rotate(0, -5, 0)
end
callable(nil, "onRotateYRight")

function onRotateZLeft()
    if onClient() then
        invokeServerFunction("onRotateZLeft")
    end

    rotate(0, 0, 5)
end
callable(nil, "onRotateZLeft")

function onRotateZRight()
    if onClient() then
        invokeServerFunction("onRotateZRight")
    end

    rotate(0, 0, -5)
end
callable(nil, "onRotateZRight")

function onResetRotation()
    if onClient() then
        invokeServerFunction("onRotateZRight")
    end

    Entity():setValue("dbg_angle_x", 0)
    Entity():setValue("dbg_angle_y", 0)
    Entity():setValue("dbg_angle_z", 0)

    local p = Entity().position
    local p2 = MatrixYawPitchRoll(0, 0, 0)
    p2.position = p.position
    Entity().position = p2
end
callable(nil, "onRotateZRight")


function onCrashButtonPressed(arg)

    if onClient() then
        invokeServerFunction("onCrashButtonPressed")

        local player = nil
        player:removeScript("events/eventscheduler.lua")
        return
    end

    local player = nil
    player:removeScript("events/eventscheduler.lua")
end

function onPrintClientLogButtonPressed(arg)
    print("Client Log: ")

    print(DebugInfo():getStartingLog())
    print("\n...\n")
    print(DebugInfo():getEndingLog())
end

function onHintButtonPressed(arg)
    Hud():displayHint("Debug text of a custom script hint!", Entity())
end

function onPrintServerLogButtonPressed(arg)
    if onClient() then
        invokeServerFunction("onPrintServerLogButtonPressed", Player().index)
        return
    end

    print(DebugInfo():getStartingLog())
    print("\n...\n")
    print(DebugInfo():getEndingLog())
end

function onFlyButtonPressed(arg)

    if onClient() then
        invokeServerFunction("onFlyButtonPressed", Player().index)
        return
    end

    local player = Player(arg)
    player.craft = Entity()
end

function onOwnButtonPressed(arg)

    if onClient() then
        invokeServerFunction("onOwnButtonPressed", Player().index)
        return
    end

    Entity().factionIndex = arg
end

function onOwnAllianceButtonPressed(arg)

    if onClient() then
        local allianceIndex = Player().allianceIndex

        if allianceIndex then
            invokeServerFunction("onOwnAllianceButtonPressed", allianceIndex)
        end

        return
    end

    Entity().factionIndex = arg
end

function onOwnLocalsButtonPressed()
    if onClient() then
        invokeServerFunction("onOwnLocalsButtonPressed", allianceIndex)
        return
    end

    local x, y = Sector():getCoordinates()
    local faction = Galaxy():getNearestFaction(x, y)

    Entity().factionIndex = faction.index
end
callable(nil, "onOwnLocalsButtonPressed")

function onCreateShipsButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateShipsButtonPressed")
        return
    end

    local faction = Faction()
    local this = Entity()

    local position = this.position
    local p = this.right * (this:getBoundingBox().size.x + 50.0)
    position.pos = position.pos + vec3(p.x, p.y, p.z)

    local finished = function(ship) ship:addScript("data/scripts/entity/stationfounder.lua") end
    local generator = AsyncShipGenerator(nil, finished)

    generator:createMilitaryShip(faction, position)

end

function onCreateShipCopyButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateShipCopyButtonPressed")
        return
    end

    local faction = Faction()
    local this = Entity()

    local position = this.position
    local p = this.right * (this:getBoundingBox().size.x + 50.0)
    position.pos = position.pos + vec3(p.x, p.y, p.z)

    Sector():copyEntity(this, position)

end

function onCreateBeaconButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateBeaconButtonPressed")
        return
    end

    local faction = Faction()
    local this = Entity()

    local position = this.position
    local p = this.right * (this:getBoundingBox().size.x + 50.0)
    position.pos = position.pos + vec3(p.x, p.y, p.z)

    SectorGenerator(Sector():getCoordinates()):createBeacon(position, nil, "This is the ${text}", {text = "Beacon Text"})

end

function onCreateStashButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateStashButtonPressed")
        return
    end

    local faction = Faction()
    local this = Entity()

    local position = this.position
    local p = this.right * (this:getBoundingBox().size.x + 50.0)
    position.pos = position.pos + vec3(p.x, p.y, p.z)

    SectorGenerator(Sector():getCoordinates()):createStash(position, "This is the ${text}", {text = "Beacon Text"})

end

function onCreateDistriButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateDistriButtonPressed")
        return
    end

    local dir = normalize(vec3(getFloat(-1, 1), getFloat(-1, 1), getFloat(-1, 1)))
    local up = vec3(0, 1, 0)
    local right = normalize(cross(dir, up))
    local pos = dir * 1000
    local distance = 50

    local generator = AsyncPirateGenerator(nil, onPiratesGenerated)
    generator:startBatch()

    if attackType == 1 then
        reward = 2.0

        generator:createScaledRaider(MatrixLookUpPosition(-dir, up, pos))
        generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos + right * distance))
        generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos + right * -distance))

    elseif attackType == 2 then
        reward = 1.5

        generator:createScaledPirate(MatrixLookUpPosition(-dir, up, pos))
        generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos + right * distance))
        generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos + right * -distance))

    elseif attackType == 3 then
        reward = 1.5

        generator:createScaledPirate(MatrixLookUpPosition(-dir, up, pos))
        generator:createScaledPirate(MatrixLookUpPosition(-dir, up, pos + right * distance))
        generator:createScaledPirate(MatrixLookUpPosition(-dir, up, pos + right * -distance))
    else
        reward = 1.0

        generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos))
        generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos + right * distance))
        generator:createScaledBandit(MatrixLookUpPosition(-dir, up, pos + right * -distance))
        generator:createScaledOutlaw(MatrixLookUpPosition(-dir, up, pos + right * -distance * 2.0))
        generator:createScaledOutlaw(MatrixLookUpPosition(-dir, up, pos + right * distance * 2.0))
    end

    generator:endBatch()
end

function onPiratesGenerated(generated)
    SpawnUtility.addEnemyBuffs(generated)
end

function onGunsButtonPressed()
    if onClient() then
        invokeServerFunction("onGunsButtonPressed")
        return
    end

    local player = Faction()

    local weaponTypes = {}
    weaponTypes[WeaponType.ChainGun] = 1
    weaponTypes[WeaponType.PointDefenseChainGun] = 1
    weaponTypes[WeaponType.Laser] = 1
    weaponTypes[WeaponType.MiningLaser] = 1
    weaponTypes[WeaponType.RawMiningLaser] = 1
    weaponTypes[WeaponType.SalvagingLaser] = 1
    weaponTypes[WeaponType.RawSalvagingLaser] = 1
    weaponTypes[WeaponType.PlasmaGun] = 1
    weaponTypes[WeaponType.RocketLauncher] = 1
    weaponTypes[WeaponType.Cannon] = 1
    weaponTypes[WeaponType.RailGun] = 1
    weaponTypes[WeaponType.RepairBeam] = 1
    weaponTypes[WeaponType.Bolter] = 1
    weaponTypes[WeaponType.LightningGun] = 1
    weaponTypes[WeaponType.TeslaGun] = 1
    weaponTypes[WeaponType.ForceGun] = 1
    weaponTypes[WeaponType.PulseCannon] = 1
    weaponTypes[WeaponType.AntiFighter] = 1
    weaponTypes[WeaponType.PointDefenseLaser] = 1

    local x, y = Sector():getCoordinates()

    local rarities = SectorTurretGenerator():getSectorRarityDistribution(x, y)
    local sum = 0
    for _, weight in pairs(rarities) do
        sum = sum + weight
    end

    for rarity, weight in pairs(rarities) do
        print ("Likelihood for %s turret: 1 in %d", tostring(Rarity(rarity)), round(sum / weight, 1))
    end

    local materials = {}
    materials[0] = 1
    materials[1] = 1
    materials[2] = 1
    materials[3] = 1
    materials[4] = 1
    materials[5] = 1
    materials[6] = 1

    local dps, tech = Balancing_GetSectorWeaponDPS(Sector():getCoordinates())

    for i = 1, 15 do

--        local material = selectByWeight(random(), materials)
--        local weaponType = selectByWeight(random(), weaponTypes)

        for j = 1, 20 do
            local turret = SectorTurretGenerator():generate(x, y)
            player:getInventory():add(InventoryTurret(turret))
        end
    end

end

function onCoaxialGunsButtonPressed()
    if onClient() then
        invokeServerFunction("onCoaxialGunsButtonPressed")
        return
    end

    local player = Faction()

    local weaponTypes = {}
    weaponTypes[WeaponType.ChainGun] = 1
    weaponTypes[WeaponType.PointDefenseChainGun] = 1
    weaponTypes[WeaponType.Laser] = 1
    weaponTypes[WeaponType.MiningLaser] = 1
    weaponTypes[WeaponType.RawMiningLaser] = 1
    weaponTypes[WeaponType.SalvagingLaser] = 1
    weaponTypes[WeaponType.RawSalvagingLaser] = 1
    weaponTypes[WeaponType.PlasmaGun] = 1
    weaponTypes[WeaponType.RocketLauncher] = 1
    weaponTypes[WeaponType.Cannon] = 1
    weaponTypes[WeaponType.RailGun] = 1
    weaponTypes[WeaponType.RepairBeam] = 1
    weaponTypes[WeaponType.Bolter] = 1
    weaponTypes[WeaponType.LightningGun] = 1
    weaponTypes[WeaponType.TeslaGun] = 1
    weaponTypes[WeaponType.ForceGun] = 1
    weaponTypes[WeaponType.PulseCannon] = 1
    weaponTypes[WeaponType.AntiFighter] = 1
    weaponTypes[WeaponType.PointDefenseLaser] = 1

    local rarities = SectorTurretGenerator():getDefaultRarityDistribution()

    local materials = {}
    materials[0] = 1
    materials[1] = 1
    materials[2] = 1
    materials[3] = 1
    materials[4] = 1
    materials[5] = 1
    materials[6] = 1

    local dps, tech = Balancing_GetSectorWeaponDPS(Sector():getCoordinates())

    local x, y = Sector():getCoordinates()

    for i = 1, 15 do

        local rarity = selectByWeight(random(), rarities)
        local material = selectByWeight(random(), materials)
        local weaponType = selectByWeight(random(), weaponTypes)

        local turret = SectorTurretGenerator():generate(x, y, 0, Rarity(rarity), weaponType, Material(material))
        turret.coaxial = true

        for j = 1, 5 do
            player:getInventory():add(InventoryTurret(turret))
        end
    end

end

function onSystemsButtonPressed()
    if onClient() then
        invokeServerFunction("onSystemsButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    for i = 1, 15 do
        local upgrade = UpgradeGenerator():generateSectorSystem(x, y)
        Faction():getInventory():add(upgrade)
    end
end

function onSystemUpgradeButtonPressed(arg)
    if onClient() then
        local button = arg
        for _, p in pairs(systemButtons) do
            if button.index == p.button.index then
                invokeServerFunction("onSystemUpgradeButtonPressed", p.script)
                break
            end
        end
        return
    end

    rarityCounter = (rarityCounter or 0) + 1
    if rarityCounter > 5 then rarityCounter = -1 end

    local x, y = Sector():getCoordinates()
    local generator = UpgradeGenerator()

    local upgrade = SystemUpgradeTemplate(arg, Rarity(rarityCounter), generator:getUpgradeSeed(x, y, script, Rarity(rarityCounter)))
    Faction():getInventory():addOrDrop(upgrade)
end

function onEnergySuppressorButtonPressed()
    if onClient() then
        invokeServerFunction("onEnergySuppressorButtonPressed")
        return
    end

    local item = UsableInventoryItem("energysuppressor.lua", Rarity(RarityType.Exceptional))
    Faction():getInventory():addOrDrop(item)
    Faction():getInventory():addOrDrop(item)
    Faction():getInventory():addOrDrop(item)
    Faction():getInventory():addOrDrop(item)
end

function onClearInventoryButtonPressed()
    if onClient() then
        invokeServerFunction("onClearInventoryButtonPressed")
        return
    end

    Faction():getInventory():clear()

end

function onCreateWreckagePressed()
    if onClient() then
        invokeServerFunction("onCreateWreckagePressed")
        return
    end

    SectorGenerator(Sector():getCoordinates()):createWreckage(Galaxy():getNearestFaction(Sector():getCoordinates()))
end

function onCreateInfectedAsteroidPressed()
    if onClient() then
        invokeServerFunction("onCreateInfectedAsteroidPressed")
        return
    end

    local ship = Entity()
    local asteroid = SectorGenerator(0, 0):createSmallAsteroid(ship.translationf + ship.look * (ship.size.z * 0.5 + 20), 7, true, Material(MaterialType.Iron))
    Xsotan.infect(asteroid)

    Placer.resolveIntersections()
end

function onCreateBigInfectedAsteroidPressed()
    if onClient() then
        invokeServerFunction("onCreateBigInfectedAsteroidPressed")
        return
    end

    local ship = Entity()
    Xsotan.createBigInfectedAsteroid(ship.translationf + ship.look * (ship.size.z * 0.5 + 50))

    Placer.resolveIntersections()
end

function onCreateOwnableAsteroidPressed()
    if onClient() then
        invokeServerFunction("onCreateOwnableAsteroidPressed")
        return
    end

    SectorGenerator(0, 0):createClaimableAsteroid()
    Placer.resolveIntersections()
end

function onCreateClaimableWreckagePressed()
    if onClient() then
        invokeServerFunction("onCreateClaimableWreckagePressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())
    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local wreckage = generator:createWreckage(faction, nil, 0)

    -- find largest wreckage
    wreckage.title = "Abandoned Ship"%_t
    wreckage:addScript("wreckagetoship.lua")

    Placer.resolveIntersections()
end

function onCreateAdventurerPressed()
    if onClient() then
        invokeServerFunction("onCreateAdventurerPressed")
        return
    end

    AdventurerGuide.spawn1(Player(callingPlayer))
end

function onCreateMerchantPressed()
    if onClient() then
        invokeServerFunction("onCreateMerchantPressed")
        return
    end

    Player(callingPlayer):addScript("events/spawntravellingmerchant.lua")
end

function onGoToButtonPressed()

    local ship = Player().craft
    local target = ship.selectedObject

    ship.position = target.position

    Velocity(ship.index).velocity = dvec3(0, 0, 0)
    ship.desiredVelocity = 0

    if target.type == EntityType.Station then
        local pos, dir = target:getDockingPositions()

        pos = target.position:transformCoord(pos)
        dir = target.position:transformNormal(dir)

        pos = pos + dir * (ship:getBoundingSphere().radius + 10)

        local up = target.position.up

        ship.position = MatrixLookUpPosition(-dir, up, pos)
    end

end

function onCreateContainerFieldButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateContainerFieldButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())
    generator:createContainerField()

    Placer.resolveIntersections()
end

function onCreateResourceAsteroidButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateResourceAsteroidButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())
    generator:createSmallAsteroid(vec3(0, 0, 0), 1.0, true, generator:getAsteroidType())

    Placer.resolveIntersections()
end

function onCreatePirateButtonPressed()

    if onClient() then
        invokeServerFunction("onCreatePirateButtonPressed")
        return
    end

    local generator = AsyncPirateGenerator(nil, function(generated)
            Placer.resolveIntersections()
            SpawnUtility.addEnemyBuffs(generated)
        end)

    generator:startBatch()
    generator:createOutlaw()
    generator:createBandit()
    generator:createPirate()
    generator:createMarauder()
    generator:createDisruptor()
    generator:createRaider()
    generator:createRavager()
    generator:createBoss()
    generator:endBatch()

end

function onCreateTurretFactoryButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateTurretFactoryButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createTurretFactory(faction)
    station:addScript("data/scripts/entity/merchants/turretmerchant.lua")
    station.position = Matrix()

    Placer.resolveIntersections()

end

function onCreateTurretFactorySupplierButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateTurretFactorySupplierButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/turretfactorysupplier.lua")
    station.position = Matrix()

    Placer.resolveIntersections()

end
callable(nil, "onCreateTurretFactorySupplierButtonPressed")

function onCreateFighterMerchantButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateFighterMerchantButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/fightermerchant.lua")
    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateFighterFactoryButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateFighterFactoryButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createFighterFactory(faction)
    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateTorpedoMerchantButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateTorpedoMerchantButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/torpedomerchant.lua")
    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateTradingPostButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateTradingPostButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/tradingpost.lua")
    station.position = Matrix()

    Placer.resolveIntersections()

end

function onCreatePlanetaryTradingPostButtonPressed()

    if onClient() then
        invokeServerFunction("onCreatePlanetaryTradingPostButtonPressed")
        return
    end

    local x, y = Sector():getCoordinates()
    local generator = SectorGenerator(x, y)

    local faction = Galaxy():getNearestFaction(x, y)
    local station = generator:createStation(faction)
    local specs = SectorSpecifics(x, y, Server().seed)
    local planets = {specs:generatePlanets()}
    station:addScript("data/scripts/entity/merchants/planetarytradingpost.lua", planets)
    station.position = Matrix()

    Placer.resolveIntersections()

end

function onCreateSmugglersMarketPressed()

    if onClient() then
        invokeServerFunction("onCreateSmugglersMarketPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/smugglersmarket.lua")
--    station:addScript("merchants/tradingpost")
    station.position = Matrix()
    station.title = "Smuggler's Market"

    Placer.resolveIntersections()

end

function onCreateResistanceOutpostPressed()

    if onClient() then
        invokeServerFunction("onCreateResistanceOutpostPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "merchants/resistanceoutpost.lua")

    Placer.resolveIntersections()
end

function onCreateHeadQuartersPressed()

    if onClient() then
        invokeServerFunction("onCreateHeadQuartersPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/headquarters.lua")
    station.position = Matrix()

    Placer.resolveIntersections()

end

function onCreateResearchStationPressed()

    if onClient() then
        invokeServerFunction("onCreateResearchStationPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createResearchStation(faction)
    station.position = Matrix()

    Placer.resolveIntersections()

end

function onCreateShipyardButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateShipyardButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createShipyard(faction)
    station.position = Matrix()

    Placer.resolveIntersections()

end

function onCreateConsumerButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateConsumerButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())

    local station
    local consumerType = math.random(1, 3)
    if consumerType == 1 then
        station = generator:createStation(faction, "data/scripts/entity/merchants/casino.lua");
    elseif consumerType == 2 then
        station = generator:createStation(faction, "data/scripts/entity/merchants/biotope.lua");
    elseif consumerType == 3 then
        station = generator:createStation(faction, "data/scripts/entity/merchants/habitat.lua");
    end

    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateRepairDockButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateRepairDockButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createRepairDock(faction)
    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateEquipmentDockButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateEquipmentDockButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createEquipmentDock(faction)
    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateTurretMerchantButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateTurretMerchantButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/turretmerchant.lua")
    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateResourceDepotButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateResourceDepotButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction, "data/scripts/entity/merchants/resourcetrader.lua")
    station.position = Matrix()

    Placer.resolveIntersections()
end


function onResetMoneyButtonPressed()
    if onClient() then
        invokeServerFunction("onResetMoneyButtonPressed")
        return
    end

    local player = Player() or Alliance()
    if not player then return end

    if player ~= nil then
        local money = 5000000

        if player.money == money * 100 then
            money = 0

            player.money = money * 100
            player:setResources(money, money, money, money, money, money, money, money, money, money, money) -- too much, don't care

        elseif player.money == 0 then
            local x, y = Sector():getCoordinates()

            player.money = Balancing_GetSectorRichnessFactor(x, y) * 200000

            local probabilities = Balancing_GetMaterialProbability(x, y)

            for i, p in pairs(probabilities) do
                probabilities[i] = p * Balancing_GetSectorRichnessFactor(x, y) * 5000
            end

            local num = 0
            for i = NumMaterials() - 1, 0, -1 do
                probabilities[i] = probabilities[i] + num
                num = num + probabilities[i] / 2;
            end


            player:setResources(unpack(probabilities))
        else
            player.money = money * 100
            player:setResources(money, money, money, money, money, money, money, money, money, money, money) -- too much, don't care
        end

    end

end

function onWarPressed()
    if onClient() then
        invokeServerFunction("onWarPressed")
        return
    end

    local faction, ship, player = getInteractingFaction(callingPlayer)
    Galaxy():setFactionRelationStatus(faction, Faction(), RelationStatus.War, true, true)
end
callable(nil, "onWarPressed")

function onCeasefirePressed()
    if onClient() then
        invokeServerFunction("onCeasefirePressed")
        return
    end

    local faction, ship, player = getInteractingFaction(callingPlayer)
    Galaxy():setFactionRelationStatus(faction, Faction(), RelationStatus.Ceasefire, true, true)
end
callable(nil, "onCeasefirePressed")

function onNeutralPressed()
    if onClient() then
        invokeServerFunction("onNeutralPressed")
        return
    end

    local faction, ship, player = getInteractingFaction(callingPlayer)
    Galaxy():setFactionRelationStatus(faction, Faction(), RelationStatus.Neutral, true, true)
end
callable(nil, "onNeutralPressed")

function onAllyPressed()
    if onClient() then
        invokeServerFunction("onAllyPressed")
        return
    end

    local faction, ship, player = getInteractingFaction(callingPlayer)
    Galaxy():setFactionRelationStatus(faction, Faction(), RelationStatus.Allies, true, true)
end
callable(nil, "onAllyPressed")

function onLikePressed()
    if onClient() then
        invokeServerFunction("onLikePressed")
        return
    end

    local faction, ship, player = getInteractingFaction(callingPlayer)
    changeRelations(faction, Faction(), 15000)
end

function onDislikePressed()
    if onClient() then
        invokeServerFunction("onDislikePressed")
        return
    end

    local faction, ship, player = getInteractingFaction(callingPlayer)
    changeRelations(faction, Faction(), -7500)

end

function onTitlePressed()

    local str = "args: "
    for k, v in pairs(Entity():getTitleArguments()) do
        str = str .. " k: " .. k .. ", v: " .. v
    end

    print (str)
    print (Entity().title)

    if onClient() then
        invokeServerFunction("onTitlePressed")
        return
    end
end

function onFactionIndexPressed()
    print ("${factionIndex}" % Entity())
end

function applyAttackersDamage(crew, dmg, remainingDamage)

    remainingDamage = remainingDamage or 0

    -- damage is applied to crewmen in this order
    local order = {CrewProfessionType.Attacker, CrewProfessionType.Security, CrewProfessionType.None, CrewProfessionType.Engine, CrewProfessionType.Gunner, CrewProfessionType.Miner,
    CrewProfessionType.Repair, CrewProfessionType.Sergeant, CrewProfessionType.Lieutenant, CrewProfessionType.Commander, CrewProfessionType.General, CrewProfessionType.Captain, CrewProfessionType.Pilot}

    local appliedDmg = dmg + remainingDamage

    for _, profession in pairs(order) do
        local amount = crew:getMembersByProfession(profession)
        local exit = false
        local hp = getFightingStats()[profession].hp
        local killed = 0

        if amount > 0 then
            -- there are crewmen of this profession, we must damage them
            local health = hp * amount
            if appliedDmg >= health then
                -- more damage than combined health, this kills all of them
                appliedDmg = appliedDmg - health
                killed = amount

            else
                -- not enough damage to kill all of them, calculate how many were killed
                killed = math.floor(appliedDmg / hp)
                remainingDamage = appliedDmg - killed * hp
                exit = true
            end
            crew:removeByProfession(killed, profession)
        end

        if exit then break end
    end

    return remainingDamage, crew
end

function applyDefendersDamage(attacker, dmg, remainingDamage)

    remainingDamage = remainingDamage or 0

    local appliedDmg = dmg + remainingDamage

    local killed = math.floor(appliedDmg / attacker.hp)

    attacker.amount = attacker.amount - killed

    remainingDamage = appliedDmg - killed * attacker.hp

    return remainingDamage
end

function dealDamage(attacker, crew, remainingAttackerDamage, remainingDefenderDamage)

    local attackerDamage = attacker.amount * attacker.power

    local defenderDamage =  0
    for crewMan, amount in pairs(crew:getMembers()) do
        local profession = crewMan.profession
        if amount > 0 then
            local crewMemberDamage = getFightingStats()[profession.value].power or 0
            defenderDamage = defenderDamage + crewMemberDamage * amount
        end
    end
    --damage is applied after both damages are calculated
    remainingAttackerDamage, crew = applyAttackersDamage(crew, attackerDamage, remainingAttackerDamage)
    remainingDefenderDamage = applyDefendersDamage(attacker, defenderDamage, remainingDefenderDamage)

    return remainingAttackerDamage, remainingDefenderDamage, crew
end

function getShipValues()

    local ship = Entity()

    --local damage = ship.maxDurability * 0.9
    --ship:inflictDamage(damage, 0, vec3(), ship.id)

    local plan = ship:getFullPlanCopy()

    local planValue = plan:getMoneyValue()
    local resourceValue = {plan:getResourceValue()}

    for i, v in pairs (resourceValue) do
        planValue = planValue + Material(i - 1).costFactor * v * 10;
    end

    local goodsValue = 0
    --get value of cargo on board
    for good, amount in pairs(CargoBay():getCargos()) do
        local value = good.price * amount
        goodsValue = goodsValue + value
    end

    goodsValue = math.floor(goodsValue * 0.5)
    planValue = math.floor(planValue * 0.1)
    return planValue, goodsValue
end

function getBoardingValue(attacker, neededAttackers)
    local boarder = CrewProfession(CrewProfessionType.Attacker)
    local pilot = CrewProfession(CrewProfessionType.Pilot)

    local investmentAttackers = neededAttackers * boarder.price
    local priceLostAttackers = (neededAttackers - attacker.amount) * boarder.price
    local priceNeededPilots = (attacker.amount / 20) * pilot.price
    local costsAttacker = priceLostAttackers + priceNeededPilots

    local planValue, goodsValue = getShipValues()
    return investmentAttackers, costsAttacker, planValue, goodsValue
end

function getFightingStats()

    local stats = {}

    local normalCrew = {CrewProfessionType.None, CrewProfessionType.Engine, CrewProfessionType.Gunner, CrewProfessionType.Miner,
    CrewProfessionType.Repair, CrewProfessionType.Sergeant, CrewProfessionType.Lieutenant}

    for _, profession in pairs(normalCrew) do
        stats[profession] = {hp = 40, power = 1}
    end

    local nonFightingCrew = {CrewProfessionType.Pilot}
    for _, profession in pairs(nonFightingCrew) do
        stats[profession] = {hp = 0, power = 0}
    end


    local fightingOfficers = {CrewProfessionType.Commander, CrewProfessionType.General}
    for _, profession in pairs(fightingOfficers) do
        stats[profession] = {hp = 5000, power = 10}
    end

    stats[CrewProfessionType.Attacker] = {hp = 100, power = 11.25}
    stats[CrewProfessionType.Security] = {hp = 150, power = 30}
    stats[CrewProfessionType.Captain] = {hp = 10000, power = 20}

    return stats
end

function createCrew()
    local ship = Entity()
    local crew = ship.crew
    local security = math.floor(ship.crew.size * 0.15)
    local defenseWeapons = 0

    local plan = ship:getFullPlanCopy()
    local goodsValue = 0
    --get value of cargo on board
    for good, amount in pairs(CargoBay():getCargos()) do
        local value = good.price * amount
        goodsValue = goodsValue + value
    end

    if Entity().isShip then
        security = security + math.floor(goodsValue * math.random(0.000005, 0.000008))
        defenseWeapons = ship.numTurrets * 10
        if Entity().crew:getMembersByProfession(CrewProfessionType.Captain) == 0 then
            local captain = CrewMan(CrewProfessionType.Captain)
            crew:add(1, captain)
        end
    elseif Entity().isStation then
        security = security + math.floor (goodsValue * math.random(0.000013, 0.000017))
        defenseWeapons = math.floor(plan:getMoneyValue() * 0.0002)
    end
    local defenders = security + defenseWeapons
    local man = CrewMan(CrewProfessionType.Security)
    crew:add(defenders, man)

    return crew
end

function onAddPilotsPressed()
    if onClient() then
        invokeServerFunction("onAddPilotsPressed")
        return
    end

    local crew = Entity().crew
    crew:add(10, CrewMan(CrewProfessionType.Pilot, true, 1))
    Entity().crew = crew
end

function onAddSecurityPressed()
    if onClient() then
        invokeServerFunction("onAddSecurityPressed")
        return
    end

    --[[
    local crew = Entity().crew
    crew:add(15, CrewMan(CrewProfessionType.Security, true, 1))
    Entity().crew = crew
    --]]

    local ship = Entity()
    local crew = ship.crew
    local security = math.floor(ship.crew.size * 0.15)
    local defenseWeapons = 0

    local plan = ship:getFullPlanCopy()
    local goodsValue = 0
    --get value of cargo on board
    for good, amount in pairs(CargoBay():getCargos()) do
        local value = good.price * amount
        goodsValue = goodsValue + value
    end

    if Entity().isShip then
        security = security + math.floor(goodsValue * math.random(0.000005, 0.000008))
        defenseWeapons = ship.numTurrets * 10
        if Entity().crew:getMembersByProfession(CrewProfessionType.Captain) == 0 then
            local captain = CrewMan(CrewProfessionType.Captain)
            crew:add(1, captain)
        end
    elseif Entity().isStation then
        security = security + math.floor (goodsValue * math.random(0.000013, 0.000017))
        defenseWeapons = math.floor(plan:getMoneyValue() * 0.0002)
    end
    local defenders = security + defenseWeapons
    local man = CrewMan(CrewProfessionType.Security)
    crew:add(defenders, man)
    Entity().crew = crew
end

function onAddBoardersPressed()
    if onClient() then
        invokeServerFunction("onAddBoardersPressed")
        return
    end

    local crew = Entity().crew
    crew:add(15, CrewMan(CrewProfessionType.Attacker, true, 1))
    Entity().crew = crew
end

function onSpeechBubbleButtonPressed()
    if onClient() then
        invokeServerFunction("onSpeechBubbleButtonPressed")
        return
    end

    Player(callingPlayer):sendChatMessage(Entity(), ChatMessageType.Chatter, "blah blah")
end

function onSpeechBubbleSpamButtonPressed()
    if onClient() then
        invokeServerFunction("onSpeechBubbleSpamButtonPressed")
        return
    end

    Entity():addScriptOnce("data/scripts/entity/utility/radiochatter.lua", {"ha ha ha ha ha", "trolololololololo", "lalalalalalala"})

end

function onSpeechBubbleDialogButtonPressed()
    if onClient() then
        invokeServerFunction("onSpeechBubbleDialogButtonPressed")
        return
    end

    local entities = Sector():getEntitiesByType(EntityType.Ship or EntityType.Station)
    local otherIndex = nil
    if entities then
        otherIndex = nil--tostring(entities.index or nil)
    end
    local shipIndex = tostring(Entity().index)
    local lines =
        {
            {
                {id = shipIndex,    text = "Hi"},
                {id = otherIndex,   text = "Hello again"},
                {id = shipIndex,    text = "Nice meeting you, let's go for a drink some time soon, yeah?"}
            },
            {
                {id = shipIndex,    text = "In einem unbekannten Land"},
                {id = otherIndex,   text = "vor gar nicht allzulanger Zeit"},
                {id = shipIndex,    text = "war eine Biene sehr bekannt"},
                {id = otherIndex,   text = "von der sprach alles weit und breit"},
                {id = shipIndex,    text = "Und diese Biene, die ich meine nennt sich Maja"},
                {id = otherIndex,   text = "kleine, freche, schlaue Biene Maja"},
                {id = shipIndex,    text = "Maja fliegt durch ihre Welt"},
                {id = otherIndex,   text = "zeigt uns das was ihr gefällt"},
                {id = shipIndex,    text = "Wir treffen heute uns're Freundin Biene Maja"},
                {id = otherIndex,   text = "diese kleine freche Biene Maja"},
                {id = shipIndex,    text = "Maja, alle lieben Maja"},
                {id = otherIndex,   text = "Maja, Maja, Maja, erzähle uns von dir."},
                {id = shipIndex,    text = "yeah, good times, right? Good old times"},
                {id = otherIndex,   text = "yeah, good times, good times"},
            },

        }
    Entity():addScriptOnce("data/scripts/entity/utility/radiochatterdialog.lua", lines)
end


function addFighterSquad(weaponType, squadName)
    squadName = squadName or "Script Squad"

    local ship = Entity()
    local hangar = Hangar(ship.index)
    if hangar == nil then return end

    local x, y = Sector():getCoordinates()

    local squad = hangar:addSquad(squadName)

    -- fill all present squads
    local fighter = SectorFighterGenerator():generate(x, y, nil, nil, weaponType)
    hangar:setBlueprint(squad, fighter)

    for i = hangar:getSquadFighters(squad), hangar:getSquadMaxFighters(squad) - 1 do
        if hangar.freeSpace < fighter.volume then return end

        hangar:addFighter(squad, fighter)
    end

end

function onAddArmedFightersButtonPressed()
    if onClient() then
        invokeServerFunction("onAddArmedFightersButtonPressed")
        return
    end

    addFighterSquad(WeaponType.RailGun, "Railgun Squad")
end

function onAddMiningFightersButtonPressed()
    if onClient() then
        invokeServerFunction("onAddMiningFightersButtonPressed")
        return
    end

    addFighterSquad(WeaponType.MiningLaser, "Mining Squad")
end

function onAddRepairFightersButtonPressed()
    if onClient() then
        invokeServerFunction("onAddRepairFightersButtonPressed")
        return
    end

    addFighterSquad(WeaponType.RepairBeam, "Repair Squad")
end
callable(nil, "onAddRepairFightersButtonPressed")

function onAddRawMiningFightersButtonPressed()
    if onClient() then
        invokeServerFunction("onAddRawMiningFightersButtonPressed")
        return
    end

    addFighterSquad(WeaponType.RawMiningLaser, "Raw Mining Squad")
end

function onAddSalvagingFightersButtonPressed()
    if onClient() then
        invokeServerFunction("onAddSalvagingFightersButtonPressed")
        return
    end

    addFighterSquad(WeaponType.SalvagingLaser, "Salvaging Squad")
end

function onAddRawSalvagingFightersButtonPressed()
    if onClient() then
        invokeServerFunction("onAddRawSalvagingFightersButtonPressed")
        return
    end

    addFighterSquad(WeaponType.RawSalvagingLaser)
end

function onAddCargoShuttlesButtonPressed()
    if onClient() then
        invokeServerFunction("onAddCargoShuttlesButtonPressed")
        return
    end

    local ship = Entity()
    local hangar = Hangar(ship.index)
    if hangar == nil then return end

    local x, y = Sector():getCoordinates()

    local squad = hangar:addSquad("Cargo Squad")

    -- fill all present squads
    local fighter = SectorFighterGenerator():generateCargoShuttle(x, y)
    hangar:setBlueprint(squad, fighter)

    for i = hangar:getSquadFighters(squad), hangar:getSquadMaxFighters(squad) - 1 do
        if hangar.freeSpace < fighter.volume then return end

        hangar:addFighter(squad, fighter)
    end
end

function onAddCrewShuttlesButtonPressed()
    if onClient() then
        invokeServerFunction("onAddCrewShuttlesButtonPressed")
        return
    end

    local ship = Entity()
    local hangar = Hangar(ship.index)
    if hangar == nil then return end

    local x, y = Sector():getCoordinates()

    local squad = hangar:addSquad("Boarder Squad")

    local fighter = SectorFighterGenerator():generateCrewShuttle(x, y)
    hangar:setBlueprint(squad, fighter)

    for i = hangar:getSquadFighters(squad), hangar:getSquadMaxFighters(squad) - 1 do
        if hangar.freeSpace < fighter.volume then return end

        hangar:addFighter(squad, fighter)
    end
end

function onAddTorpedoesButtonPressed()
    if onClient() then
        invokeServerFunction("onAddTorpedoesButtonPressed")
        return
    end

    local ship = Entity()
    local launcher = TorpedoLauncher(ship.index)
    if launcher == nil then return end

    local x, y = Sector():getCoordinates()

    local shafts = {launcher:getShafts()}

    -- fill all present squads
    for _, shaft in pairs(shafts) do
        local torpedo = TorpedoGenerator():generate(x, y)

        for i = 1, 10 do
            launcher:addTorpedo(torpedo, shaft)
        end
    end

    for j = 1, 10 do
        local torpedo = TorpedoGenerator():generate(x, y)

        for i = 1, 5 do
            launcher:addTorpedo(torpedo)
        end
    end
end

function onDamagePressed()
    if onClient() then
        invokeServerFunction("onDamagePressed")
        return
    end

    local ship = Entity()
    if ship.shieldDurability and ship.shieldDurability > 0 then
        local damage = ship.shieldMaxDurability * 0.2
        ship:damageShield(damage, ship.translationf, Player(callingPlayer).craftIndex)
    else
        local damage = (ship.maxDurability or 0) * 0.2
        ship:inflictDamage(damage, 0, 0, 0, vec3(), Player(callingPlayer).craftIndex)
    end

end

function onInvincibleButtonPressed()
    if onClient() then
        invokeServerFunction("onInvincibleButtonPressed")
        return
    end

    local entity = Entity()

    local name = string.format("%s %s", entity.translatedTitle or "", entity.name or "")

    if entity.invincible then
        entity.invincible = false
        Player(callingPlayer):sendChatMessage("", 0, name .. " is no longer invincible")
    else
        entity.invincible = true
        Player(callingPlayer):sendChatMessage("", 0, name .. " is now invincible")
    end
end

function onShieldInvincibleButtonPressed()
    if onClient() then
        invokeServerFunction("onShieldInvincibleButtonPressed")
        return
    end

    local entity = Entity()
    if not entity then return end
    local shield = Shield(entity.id)
    if not shield then return end
    local name = string.format("%s %s", entity.translatedTitle or "", entity.name or "")

    if shield.invincible then
        shield.invincible = false
        Player(callingPlayer):sendChatMessage("", 0, name .. " shield is no longer invincible")
    else
        shield.invincible = true
        Player(callingPlayer):sendChatMessage("", 0, name .. " shield is now invincible")
    end
end

function onInstaBoardButtonPressed()
    if onClient() then
        invokeServerFunction("onInstaBoardButtonPressed")
        return
    end

    local player = Player(callingPlayer)
    local entity = Entity()

    if entity.index == player.craftIndex then return end

    local plan = Plan()
    while entity.durability > entity.maxDurability * 0.3 do
        local blocks = plan.size

        local block = plan:getNthBlock(random():getInt(0, blocks - 1))
        entity:inflictDamage(block.durability * 0.7, nil, nil, block.index, block.box.position, Uuid())
    end

    Boarding(entity):applyBoardingSuccessful(player.index)
end

function onDeleteButtonPressed()
    if onClient() then
        invokeServerFunction("onDeleteButtonPressed")
        return
    end

    local entity = Entity()
    local name = entity.name
    local type = entity.type
    local factionIndex = entity.factionIndex
    Sector():deleteEntityJumped(entity)

    -- prevent reconstruction and restoring
    if not factionIndex then return end
    if type ~= EntityType.Ship and type ~= EntityType.Station then return end

    local faction = Faction(factionIndex)
    if not faction then return end

    if faction.isPlayer then
        faction = Player(factionIndex)
    elseif faction.isAlliance then
        faction = Alliance(factionIndex)
    else
        return
    end

    faction:setShipDestroyed(name, true)
    faction:removeDestroyedShipInfo(name)

    removeReconstructionTokens(faction, name)
end

function onCreateBigAsteroidButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateBigAsteroidButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())
    local asteroid = generator:createBigAsteroid()

    Placer.resolveIntersections()
end

function onCreateAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateAsteroidFieldButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())
    local asteroid = generator:createAsteroidField()

    Placer.resolveIntersections()
end

function onCreateEmptyAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateEmptyAsteroidFieldButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())
    local asteroid = generator:createEmptyAsteroidField()

    Placer.resolveIntersections()
end

function onCreateAsteroidFieldWithTinyAsteroidsButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateAsteroidFieldWithTinyAsteroidsButtonPressed")
        return
    end

    local generator = AsteroidFieldGenerator(Sector():getCoordinates())
    local asteroid = generator:createAsteroidFieldWithTinyAsteroids(0.2)

    Placer.resolveIntersections()
end

function onCreateRichAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateRichAsteroidFieldButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())
    local asteroid = generator:createAsteroidField(0.8)

    Placer.resolveIntersections()
end

function onCreateSpiralAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateSpiralAsteroidFieldButtonPressed")
        return
    end

    local generator = AsteroidFieldGenerator(Sector():getCoordinates())
    local asteroid = generator:createSpiralAsteroidField(0.1)

    Placer.resolveIntersections()
end

function onCreateRingAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateRingAsteroidFieldButtonPressed")
        return
    end

    local generator = AsteroidFieldGenerator(Sector():getCoordinates())
    local asteroid = generator:createRingAsteroidField(0.1)

    Placer.resolveIntersections()
end

function onCreateForestAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateForestAsteroidFieldButtonPressed")
        return
    end

    local generator = AsteroidFieldGenerator(Sector():getCoordinates())
    local asteroid = generator:createForestAsteroidField(0.1)

    Placer.resolveIntersections()
end

function onCreateBallAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateBallAsteroidFieldButtonPressed")
        return
    end

    local generator = AsteroidFieldGenerator(Sector():getCoordinates())
    local asteroid = generator:createBallAsteroidField(0.1)

    Placer.resolveIntersections()
end

function spawnAsteroidField(materialtype)
    local generator = SectorGenerator(Sector():getCoordinates())
    local _, asteroids = generator:createAsteroidField(0.8)

    for _, asteroid in pairs(asteroids) do
        local plan = asteroid:getMovePlan()
        plan:setMaterial(Material(materialtype))
        asteroid:setMovePlan(plan)
    end

    Placer.resolveIntersections()
end

function onCreateIronAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateIronAsteroidFieldButtonPressed")
        return
    end

    spawnAsteroidField(MaterialType.Iron)
end
callable(nil, "onCreateIronAsteroidFieldButtonPressed")

function onCreateTitaniumAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateTitaniumAsteroidFieldButtonPressed")
        return
    end

    spawnAsteroidField(MaterialType.Titanium)
end
callable(nil, "onCreateTitaniumAsteroidFieldButtonPressed")

function onCreateNaoniteAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateNaoniteAsteroidFieldButtonPressed")
        return
    end

    spawnAsteroidField(MaterialType.Naonite)
end
callable(nil, "onCreateNaoniteAsteroidFieldButtonPressed")

function onCreateTriniumAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateTriniumAsteroidFieldButtonPressed")
        return
    end

    spawnAsteroidField(MaterialType.Trinium)
end
callable(nil, "onCreateTriniumAsteroidFieldButtonPressed")

function onCreateXanionAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateXanionAsteroidFieldButtonPressed")
        return
    end

    spawnAsteroidField(MaterialType.Xanion)
end
callable(nil, "onCreateXanionAsteroidFieldButtonPressed")

function onCreateOgoniteAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateOgoniteAsteroidFieldButtonPressed")
        return
    end

    spawnAsteroidField(MaterialType.Ogonite)
end
callable(nil, "onCreateOgoniteAsteroidFieldButtonPressed")

function onCreateAvorionAsteroidFieldButtonPressed()
    if onClient() then
        invokeServerFunction("onCreateAvorionAsteroidFieldButtonPressed")
        return
    end

    spawnAsteroidField(MaterialType.Avorion)
end
callable(nil, "onCreateAvorionAsteroidFieldButtonPressed")



function onCreateManufacturerButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateManufacturerButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction)
    station.position = Matrix()
    station:addScript("data/scripts/entity/merchants/factory.lua", "Rubber")

    Placer.resolveIntersections()
end

function onCreateFarmButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateFarmButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction)
    station.position = Matrix()
    station:addScript("data/scripts/entity/merchants/factory.lua", "Wheat")

    Placer.resolveIntersections()
end

function onCreateCollectorButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateCollectorButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction)
    station.position = Matrix()
    station:addScript("data/scripts/entity/merchants/factory.lua", "Water")

    Placer.resolveIntersections()
end

function onCreateScrapyardButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateScrapyardButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction)
    station.position = Matrix()
    station:addScript("data/scripts/entity/merchants/scrapyard.lua", "Water")

    Placer.resolveIntersections()
end

function onCreateMilitaryOutpostPressed()

    if onClient() then
        invokeServerFunction("onCreateMilitaryOutpostPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createMilitaryBase(faction)
    station.position = Matrix()

    Placer.resolveIntersections()
end

function onCreateSolarPlantButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateSolarPlantButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction)
    station.position = Matrix()
    station:addScript("data/scripts/entity/merchants/factory.lua", "Energy Cell")

    Placer.resolveIntersections()
end

function onCreateMineButtonPressed()

    if onClient() then
        invokeServerFunction("onCreateMineButtonPressed")
        return
    end

    local generator = SectorGenerator(Sector():getCoordinates())

    local faction = Galaxy():getNearestFaction(Sector():getCoordinates())
    local station = generator:createStation(faction)
    station.position = Matrix()
    station:addScript("data/scripts/entity/merchants/factory.lua", "Silicon")

    Placer.resolveIntersections()
end

function onClearButtonPressed()
    if onClient() then
        invokeServerFunction("onClearButtonPressed")
        return
    end

    -- portion that is executed on server
    local sector = Sector()
    local self = Entity()

    for _, entity in pairs({sector:getEntities()}) do
        if entity.factionIndex == nil or (entity.factionIndex ~= callingPlayer and entity.factionIndex ~= self.factionIndex) then
            sector:deleteEntity(entity)
        end
    end

end

function onClearFightersButtonPressed()
    if onClient() then
        invokeServerFunction("onClearFightersButtonPressed")
        return
    end

    -- portion that is executed on server
    local sector = Sector()
    local self = Entity()

    for _, entity in pairs({sector:getEntities()}) do
        if entity.type == EntityType.Fighter then
            sector:deleteEntity(entity)
        end
    end

end

function onClearTorpedosButtonPressed()
    if onClient() then
        invokeServerFunction("onClearTorpedosButtonPressed")
        return
    end

    -- portion that is executed on server
    local sector = Sector()
    local self = Entity()

    for _, entity in pairs({sector:getEntities()}) do
        if entity.type == EntityType.Torpedo then
            sector:deleteEntity(entity)
        end
    end

end


function onInfectAsteroidsButtonPressed()
    if onClient() then
        invokeServerFunction("onInfectAsteroidsButtonPressed")
        return
    end

    Xsotan.infectAsteroids()
end

function clearStations()
    local sector = Sector()
    for _, entity in pairs({sector:getEntitiesByType(EntityType.Station)}) do
        sector:deleteEntity(entity)
    end
end




callable(nil, "addEntityScript")
callable(nil, "addPlayerScript")
callable(nil, "addSectorScript")
callable(nil, "onAddCargoShuttlesButtonPressed")
callable(nil, "onAddCrewShuttlesButtonPressed")
callable(nil, "onAddCrewButtonPressed")
callable(nil, "onAddArmedFightersButtonPressed")
callable(nil, "onAddMiningFightersButtonPressed")
callable(nil, "onAddRawMiningFightersButtonPressed")
callable(nil, "onAddSalvagingFightersButtonPressed")
callable(nil, "onAddRawSalvagingFightersButtonPressed")
callable(nil, "onAddTorpedoesButtonPressed")
callable(nil, "onAlienAttackButtonPressed")
callable(nil, "onAlignButtonPressed")
callable(nil, "onClearButtonPressed")
callable(nil, "onClearCargoButtonPressed")
callable(nil, "onClearCrewButtonPressed")
callable(nil, "onClearFightersButtonPressed")
callable(nil, "onClearHangarButtonPressed")
callable(nil, "onClearInventoryButtonPressed")
callable(nil, "onClearTorpedoesButtonPressed")
callable(nil, "onClearTorpedosButtonPressed")
callable(nil, "onCoaxialGunsButtonPressed")
callable(nil, "onCondenseSectorButtonPressed")
callable(nil, "onCreateAdventurerPressed")
callable(nil, "onCreateAsteroidFieldButtonPressed")
callable(nil, "onCreateBeaconButtonPressed")
callable(nil, "onCreateStashButtonPressed")
callable(nil, "onCreateDistriButtonPressed")
callable(nil, "onCreateBigAsteroidButtonPressed")
callable(nil, "onCreateBigInfectedAsteroidPressed")
callable(nil, "onCreateClaimableWreckagePressed")
callable(nil, "onCreateCollectorButtonPressed")
callable(nil, "onCreateConsumerButtonPressed")
callable(nil, "onCreateContainerFieldButtonPressed")
callable(nil, "onCreateEmptyAsteroidFieldButtonPressed")
callable(nil, "onCreateEquipmentDockButtonPressed")
callable(nil, "onCreateFarmButtonPressed")
callable(nil, "onCreateFighterFactoryButtonPressed")
callable(nil, "onCreateFighterMerchantButtonPressed")
callable(nil, "onCreateHeadQuartersPressed")
callable(nil, "onCreateInfectedAsteroidPressed")
callable(nil, "onCreateManufacturerButtonPressed")
callable(nil, "onCreateMerchantPressed")
callable(nil, "onCreateMilitaryOutpostPressed")
callable(nil, "onCreateMineButtonPressed")
callable(nil, "onCreateOwnableAsteroidPressed")
callable(nil, "onCreatePirateButtonPressed")
callable(nil, "onCreatePlanetaryTradingPostButtonPressed")
callable(nil, "onCreateRepairDockButtonPressed")
callable(nil, "onCreateResearchStationPressed")
callable(nil, "onCreateResistanceOutpostPressed")
callable(nil, "onCreateResourceAsteroidButtonPressed")
callable(nil, "onCreateResourceDepotButtonPressed")
callable(nil, "onCreateRichAsteroidFieldButtonPressed")
callable(nil, "onCreateAsteroidFieldWithTinyAsteroidsButtonPressed")
callable(nil, "onCreateSpiralAsteroidFieldButtonPressed")
callable(nil, "onCreateRingAsteroidFieldButtonPressed")
callable(nil, "onCreateForestAsteroidFieldButtonPressed")
callable(nil, "onCreateBallAsteroidFieldButtonPressed")
callable(nil, "onCreateScrapyardButtonPressed")
callable(nil, "onCreateShipsButtonPressed")
callable(nil, "onCreateShipCopyButtonPressed")
callable(nil, "onCreateShipyardButtonPressed")
callable(nil, "onCreateSmugglersMarketPressed")
callable(nil, "onCreateSolarPlantButtonPressed")
callable(nil, "onCreateTorpedoMerchantButtonPressed")
callable(nil, "onCreateTradingPostButtonPressed")
callable(nil, "onCreateTurretFactoryButtonPressed")
callable(nil, "onCreateTurretMerchantButtonPressed")
callable(nil, "onCreateWreckagePressed")
callable(nil, "onCrewTransportButtonPressed")
callable(nil, "onDamagePressed")
callable(nil, "onDeleteButtonPressed")
callable(nil, "onDestroyButtonPressed")
callable(nil, "onCrashButtonPressed")
callable(nil, "onDisableEventsButtonPressed")
callable(nil, "onDislikePressed")
callable(nil, "onDistressCallButtonPressed")
callable(nil, "onExodusBeaconButtonPressed")
callable(nil, "onExodusFinalBeaconButtonPressed")
callable(nil, "onExodusPointsButtonPressed")
callable(nil, "onFakeDistressCallButtonPressed")
callable(nil, "onFlyButtonPressed")
callable(nil, "onGenerateFactoryButtonPressed")
callable(nil, "onGenerateTemplateButtonPressed")
callable(nil, "onGoodsButtonPressed")
callable(nil, "onGunsButtonPressed")
callable(nil, "onHeadhunterAttackButtonPressed")
callable(nil, "onInfectAsteroidsButtonPressed")
callable(nil, "onInvincibleButtonPressed")
callable(nil, "onShieldInvincibleButtonPressed")
callable(nil, "onInstaBoardButtonPressed")
callable(nil, "onKeysButtonPressed")
callable(nil, "onLikePressed")
callable(nil, "onMiningLasersButtonPressed")
callable(nil, "onOwnAllianceButtonPressed")
callable(nil, "onOwnButtonPressed")
callable(nil, "onPersecutorsButtonPressed")
callable(nil, "onPirateAttackButtonPressed")
callable(nil, "onXsotanSwarmButtonPressed")
callable(nil, "onXsotanSwarmEndButtonPressed")
callable(nil, "onPrintServerLogButtonPressed")
callable(nil, "onProgressBrakersButtonPressed")
callable(nil, "onGiveWeaponsButtonPressed")
callable(nil, "onQuestRewardButtonPressed")
callable(nil, "onResearchSatelliteButtonPressed")
callable(nil, "onResetMoneyButtonPressed")
callable(nil, "onResolveIntersectionsButtonPressed")
callable(nil, "onRespawnAsteroidsButtonPressed")
callable(nil, "onSearchAndRescueButtonPressed")
callable(nil, "onSmugglerRetaliationButtonPressed")
callable(nil, "onSpawnBattleButtonPressed")
callable(nil, "onSpawnBlockerButtonPressed")
callable(nil, "onSpawnCIWSButtonPressed")
callable(nil, "onSpawnCarrierButtonPressed")
callable(nil, "onSpawnDefendersButtonPressed")
callable(nil, "onSpawnDeferredBattleButtonPressed")
callable(nil, "onSpawnDisruptorButtonPressed")
callable(nil, "onSpawnFlagshipButtonPressed")
callable(nil, "onSpawnFleetButtonPressed")
callable(nil, "onSpawnFreighterButtonPressed")
callable(nil, "onSpawnGuardianButtonPressed")
callable(nil, "onSpawnLaserBossButtonPressed")
callable(nil, "onPirateDeliveryPressed")
callable(nil, "onSpawnMilitaryShipButtonPressed")
callable(nil, "onSpawnMinerButtonPressed")
callable(nil, "onSpawnPersecutorButtonPressed")
callable(nil, "onSpawnScientistButtonPressed")
callable(nil, "onSpawnSmugglerButtonPressed")
callable(nil, "onSpawnSwoksButtonPressed")
callable(nil, "onSpawnThe4ButtonPressed")
callable(nil, "onSpawnTheAIButtonPressed")
callable(nil, "onSpawnTorpedoBoatButtonPressed")
callable(nil, "onSpawnTraderButtonPressed")
callable(nil, "onSpawnXsotanCarrierButtonPressed")
callable(nil, "onSpawnQuantumXsotanButtonPressed")
callable(nil, "onSpawnXsotanSummonerButtonPressed")
callable(nil, "onSpawnXsotanSquadButtonPressed")
callable(nil, "onStartFighterButtonPressed")
callable(nil, "onSystemUpgradeButtonPressed")
callable(nil, "onSystemsButtonPressed")
callable(nil, "onTitlePressed")
callable(nil, "onTouchAllObjectsButtonPressed")
callable(nil, "onTraderAttackedByPiratesButtonPressed")
callable(nil, "removeEntityScript")
callable(nil, "removePlayerScript")
callable(nil, "removeSectorScript")
callable(nil, "sendEntityScripts")
callable(nil, "sendPlayerScripts")
callable(nil, "sendSectorScripts")
callable(nil, "setValue")
callable(nil, "syncDocks")
callable(nil, "syncValues")
callable(nil, "onEnergySuppressorButtonPressed")
callable(nil, "onAddPilotsPressed")
callable(nil, "onAddSecurityPressed")
callable(nil, "onAddBoardersPressed")
callable(nil, "onSpeechBubbleButtonPressed")
callable(nil, "onSpeechBubbleSpamButtonPressed")
callable(nil, "onSpeechBubbleDialogButtonPressed")
callable(nil, "onRMiningButtonPressed")
callable(nil, "onTorpedoesButtonPressed")
callable(nil, "onFighterButtonPressed")
callable(nil, "onOrdersButtonPressed")
callable(nil, "onStationTutorialButtonPressed")
callable(nil, "onFindAvorionButtonPressed")
callable(nil, "onBarrierButtonPressed")
callable(nil, "onReachCenterButtonPressed")
callable(nil, "onAsteroidShieldBossPressed")
callable(nil, "onJumperBossPressed")
callable(nil, "onPiratestationWavesPressed")
callable(nil, "onFakeStashWavesPressed")
callable(nil, "onHiddenTreasurePressed")
callable(nil, "onMothershipWavesPressed")
callable(nil, "onAmbushPreperationPressed")
callable(nil, "onPirateAsteroidWavesPressed")
callable(nil, "onPirateInitiationPressed")
callable(nil, "onPirateKingPressed")
callable(nil, "onPirateMeetingPressed")
callable(nil, "onPirateProvocationWavesPressed")
callable(nil, "onPiratesHidingTreasurePressed")
callable(nil, "onPiratestationWavesPressed")
callable(nil, "onTreasureHuntPressed")
callable(nil, "onPirateTraitorPressed")
callable(nil, "onPiratesWreackagePressed")
callable(nil, "onTraderAmbushedPressed")

