function checkCaptain()
    local entity = Entity()

    if not checkEntityInteractionPermissions(Entity(), AlliancePrivilege.FlyCrafts) then
        return false
    end

    local captains = entity:getCrewMembers(CrewProfessionType.Captain)
    if not captains or captains == 0 then
        local faction = Faction()
        if faction then
            faction:sendChatMessage("", 1, "Your ship has no captain!"%_t)
        end

        return false
    end

    local pilot = entity:getPilotIndices()
    if pilot then
        local faction = Faction()
        if faction then
            faction:sendChatMessage("", 1, "Can't assign orders: Ship %1% is piloted by a player!"%_t, entity.name or "")
        end

        return false
    end

    return true
end

function checkArmed()
    -- check armed
    local hangar = Hangar()
    local squads = {hangar:getSquads()}
    local armedFighters = false

    for _, index in pairs(squads) do
        local category = hangar:getSquadMainWeaponCategory(index)
        if category == WeaponCategory.Armed then
            armedFighters = true
        end
    end

    local entity = Entity()
    if entity:getNumArmedTurrets() <= 0 and not armedFighters then
        local faction = Faction(Entity().factionIndex)
        if faction then
            faction:sendChatMessage("", ChatMessageType.Error, "We have no turrets or combat fighters!"%_T)
        end
        return false
    end

    return true
end

function checkHeal()
    local hangar = Hangar()
    local squads = {hangar:getSquads()}
    local repairFighters = false

    for _, index in pairs(squads) do
        local category = hangar:getSquadMainWeaponCategory(index)
        if category == WeaponCategory.Heal then
            repairFighters = true
        end
    end

    local entity = Entity()
    local turrets = {entity:getTurrets()}
    local repairWeapons = false
    for _, turret  in pairs(turrets) do
        local weapons = Weapons(turret)

        if weapons.category == WeaponCategory.Heal then
            repairWeapons = true
        end
    end

    if not repairFighters and not repairWeapons then
        local faction = Faction(Entity().factionIndex)
        if faction then
            faction:sendChatMessage("", ChatMessageType.Error, "We need turrets or repair fighters to heal!"%_T)
        end
        return false
    end

    return true
end
