package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("stringutility")
include("reconstructiontoken")

function create(item, rarity)

    rarity = Rarity(RarityType.Legendary)

    item.stackable = true
    item.depleteOnUse = true
    item.name = "Empty Reconstruction Token"%_t
    item.price = 10000
    item.icon = "data/textures/icons/reconstruction-token.png"
    item.rarity = rarity
    item:setValue("subtype", "UnbrandedReconstructionToken")

    local tooltip = Tooltip()
    tooltip.icon = item.icon

    local title = item.name

    local headLineSize = 25
    local headLineFontSize = 15
    local line = TooltipLine(headLineSize, headLineFontSize)
    line.ctext = title
    line.ccolor = item.rarity.color
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Can be turned into a Reconstruction Token."%_t
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Ship"%_t
    line.rtext = "Not yet assigned"%_t
    line.icon = "data/textures/icons/round-star.png"
    line.iconColor = ColorRGB(0.3, 1, 1)
    line.lcolor = ColorRGB(0.3, 1, 1)
    line.rcolor = ColorRGB(0.3, 1, 1)
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Use to engrave all information of"%_t
    tooltip:addLine(line)

    local line = TooltipLine(18, 14)
    line.ltext = "your current ship into it to have"%_t
    tooltip:addLine(line)

    local line = TooltipLine(18, 14)
    line.ltext = "it reconstructed at any Repair Dock."%_t
    tooltip:addLine(line)


    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "An empty crystal with enough capacity to hold"%_t
    line.lcolor = ColorRGB(0.4, 0.4, 0.4)
    tooltip:addLine(line)

    local line = TooltipLine(18, 14)
    line.ltext = "all the information of an entire ship."%_t
    line.lcolor = ColorRGB(0.4, 0.4, 0.4)
    tooltip:addLine(line)


    item:setTooltip(tooltip)

    return item
end

function activate(item)

    local player = Player()
    local craft = Player().craft
    if not craft then return false end
    if craft.type ~= EntityType.Ship then return false end

    local receiver = player.craftFaction

    receiver:getInventory():addOrDrop(createReconstructionToken(craft))

    return true
end
