package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/?.lua"

include("stringutility")
local ShipGenerator = include("shipgenerator")
local JumperBoss = include("player/events/spawnjumperboss")

function create(item, rarity)

    rarity = Rarity(RarityType.Legendary)

    item.stackable = false
    item.depleteOnUse = true
    item.name = "Hyperspace Interrupter"%_t
    item.price = 50000
    item.icon = "data/textures/icons/screen-impact.png"
    item.rarity = rarity
    item:setValue("subtype", "JumperBossCaller")

    local tooltip = Tooltip()
    tooltip.icon = item.icon

    local title = "Hyperspace Interrupter"%_t

    local headLineSize = 25
    local headLineFontSize = 15
    local line = TooltipLine(headLineSize, headLineFontSize)
    line.ctext = title
    line.ccolor = item.rarity.color
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(18, 14)
    line.ltext = "Can be used to interrupt the hyperspace jump of Fidget."%_t
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(20, 15)
    line.ltext = "Depleted on Use"%_t
    line.lcolor = ColorRGB(1.0, 1.0, 0.3)
    tooltip:addLine(line)

    -- empty line
    tooltip:addLine(TooltipLine(14, 14))

    local line = TooltipLine(20, 14)
    line.ltext = "Can be activated by the player"%_t
    tooltip:addLine(line)

    item:setTooltip(tooltip)

    return item
end

function activate(item)
    local x, y = Sector():getCoordinates()
    local boss = JumperBoss.spawnBoss(x, y)

    return true
end
