package.path = package.path .. ";data/scripts/lib/?.lua"
package.path = package.path .. ";data/scripts/server/?.lua"
include ("factions")
include ("stringutility")
local FactionPacks = include ("factionpacks")

function initialize()
    Server():registerCallback("onPlayerLogIn", "onPlayerLogIn")
    Server():registerCallback("onPlayerLogOff", "onPlayerLogOff")
    Galaxy():registerCallback("onPlayerCreated", "onPlayerCreated")
    Galaxy():registerCallback("onFactionCreated", "onFactionCreated")

    FactionPacks.initialize()
end

-- guardian_respawn_time:   Time between Xsotan Swarm Event was lost and respawn of Guardian (line 64)
-- xsotan_swarm_time:   Time between Guardian was killed and Xsotan Event spawns (set in wormholeguardian.lua:77 in onDestroyed())
--                      Also time between Xsotan Event was won and restarts (line 53)
-- xsotan_swarm_duration:   Base time player have to complete the event, is increased by 10 min if Guardian Precursor spawns (line 40)
function update(timeStep)
    local server = Server()

    local guardianRespawnTime = server:getValue("guardian_respawn_time")
    if guardianRespawnTime then

        guardianRespawnTime = guardianRespawnTime - timeStep
        if guardianRespawnTime < 0 then
            guardianRespawnTime = nil
            server:broadcastChatMessage("Server", ChatMessageType.Information, "Strong subspace disturbances have been detected. They seem to be originating from the center of the galaxy."%_T)
        end

        server:setValue("guardian_respawn_time", guardianRespawnTime)
    end

    local xsotanSwarmSpawnTime = server:getValue("xsotan_swarm_time")
    if xsotanSwarmSpawnTime then
        xsotanSwarmSpawnTime = xsotanSwarmSpawnTime - timeStep
        if xsotanSwarmSpawnTime <= 0 then
            server:setValue("xsotan_swarm_active", true)
            server:setValue("xsotan_swarm_success", nil)
            server:setValue("xsotan_swarm_duration", 30 * 60)
            server:setValue("xsotan_swarm_time", nil)
            server:broadcastChatMessage("Admiral Tuagn"%_T, ChatMessageType.Information, "Massive amounts of Xsotan are spawning everywhere! We need to send them back home!"%_T)
        else
            server:setValue("xsotan_swarm_time", xsotanSwarmSpawnTime)
        end
    end

    local xsotanSwarmEventTime = server:getValue("xsotan_swarm_duration")
    if xsotanSwarmEventTime then
        xsotanSwarmEventTime = xsotanSwarmEventTime - timeStep
        local precursorFightOngoing = server:getValue("xsotan_swarm_precursor_fight")
        local success = server:getValue("xsotan_swarm_success")
        if success then
            -- xsotan swarm defeated => don't respawn guardian
            server:setValue("xsotan_swarm_time", 120 * 60)
            server:setValue("xsotan_swarm_duration", nil)
            server:setValue("xsotan_swarm_active", false)
            server:broadcastChatMessage("Admiral Tuagn"%_T, ChatMessageType.Information, "The invasion has been defeated!"%_T)

        elseif xsotanSwarmEventTime <= 0 and not precursorFightOngoing then
            server:setValue("xsotan_swarm_active", false)
            server:setValue("xsotan_swarm_duration", nil)
            if not success then
                -- xsotan swarm has not been defeated => respawn guardian
                server:setValue("guardian_respawn_time", 30 * 60)
                server:setValue("xsotan_swarm_success", false)
                server:broadcastChatMessage("Admiral Tuagn"%_T, ChatMessageType.Information, "We can't hold it anymore! Retreat! Retreat!"%_T)
            end
        else
            server:setValue("xsotan_swarm_duration", xsotanSwarmEventTime)
        end
    end

    local laserBossRespawnTime = server:getValue("laser_boss_respawn_timer")
    if laserBossRespawnTime then
        guardianRespawnTime = laserBossRespawnTime - timeStep;
        if laserBossRespawnTime < 0 then
            laserBossRespawnTime = nil
        end

        server:setValue("laser_boss_respawn_timer", laserBossRespawnTime)
    end

    local serverRuntime = server:getValue("online_time") or 0
    serverRuntime = serverRuntime + timeStep
    server:setValue("online_time", serverRuntime)

end

function onPlayerCreated(index)
    local player = Player(index)
    Server():broadcastChatMessage("Server", ChatMessageType.ServerInfo, "Player %s created!"%_t, player.name)
end

function onFactionCreated(index)

end

function onPlayerLogIn(playerIndex)
    local player = Player(playerIndex)
    Server():broadcastChatMessage("Server", ChatMessageType.ServerInfo, "Player %s joined the galaxy"%_t, player.name)

    matchResources(player)
end

function onPlayerLogOff(playerIndex)
    local player = Player(playerIndex)
    Server():broadcastChatMessage("Server", ChatMessageType.ServerInfo, "Player %s left the galaxy"%_t, player.name)

end
